/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.jsLibs;

import java.io.IOException;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.jsLibs.Scriptlet;
import org.apache.myfaces.trinidadinternal.resource.CoreRenderKitResourceLoader;

public class LibraryScriptlet
extends Scriptlet {
    private final String _libraryName;
    private final Object[] _functions;
    private final Object[] _dependencies;
    private static Boolean _debugJavascript;
    private static final String _DEBUG_JAVASCRIPT = "org.apache.myfaces.trinidad.DEBUG_JAVASCRIPT";
    private static String _LIBRARY_VERSION;
    private static final TrinidadLogger _LOG;
    private static final String _JSLIBS_DIRECTORY = "/adf/jsLibs/";

    public LibraryScriptlet(String libraryName, String[] functions) {
        this(libraryName, functions, null);
    }

    public LibraryScriptlet(String libraryName, Object[] functions, Object[] dependencies) {
        this._libraryName = libraryName;
        this._functions = functions == null ? null : (Object[])functions.clone();
        this._dependencies = dependencies == null ? null : (Object[])dependencies.clone();
    }

    public void registerSelf() {
        super.registerSelf();
        if (this._functions != null) {
            for (int i = 0; i < this._functions.length; ++i) {
                this.registerSelfWithKey(this._functions[i]);
            }
        }
    }

    public Object getScriptletKey() {
        return this._libraryName;
    }

    public static String getLibraryNameWithVersion(FacesContext context, String libraryName) {
        if (LibraryScriptlet._useLibraryVersions()) {
            return libraryName + _LIBRARY_VERSION;
        }
        return libraryName;
    }

    protected void outputScriptletImpl(FacesContext context, RenderingContext arc) throws IOException {
        if (this._dependencies != null) {
            for (int i = 0; i < this._dependencies.length; ++i) {
                this.outputDependency(context, arc, this._dependencies[i]);
            }
        }
        XhtmlUtils.writeLibImport(context, arc, this.getLibraryURL(context, arc));
    }

    protected void outputScriptletContent(FacesContext context, RenderingContext arc) throws IOException {
    }

    protected void embedInScriptTagImpl(FacesContext context, RenderingContext arc) throws IOException {
        throw new IllegalStateException();
    }

    protected String getLibraryName(FacesContext context, RenderingContext arc) {
        String libraryName = this._libraryName;
        if (LibraryScriptlet._isDebug(context)) {
            libraryName = "Debug" + libraryName;
        }
        return libraryName;
    }

    protected String getExtraParameters(FacesContext context, RenderingContext arc) {
        return null;
    }

    protected String getLibraryURL(FacesContext context, RenderingContext arc) {
        String libraryName = this.getLibraryName(context, arc);
        StringBuffer libURL = new StringBuffer(80);
        libURL.append(context.getExternalContext().getRequestContextPath());
        libURL.append(LibraryScriptlet.getBaseLibURL());
        libURL.append(libraryName);
        if (LibraryScriptlet._useLibraryVersions()) {
            libURL.append(_LIBRARY_VERSION);
        }
        libURL.append(".js");
        String extraParams = this.getExtraParameters(context, arc);
        if (extraParams != null) {
            libURL.append(extraParams);
        }
        return libURL.toString();
    }

    public static String getBaseLibURL() {
        return _JSLIBS_DIRECTORY;
    }

    private static boolean _useLibraryVersions() {
        return _LIBRARY_VERSION != null;
    }

    private static boolean _isDebug(FacesContext context) {
        if (_debugJavascript == null) {
            String debugJavascript = context.getExternalContext().getInitParameter(_DEBUG_JAVASCRIPT);
            if (debugJavascript != null && debugJavascript.equalsIgnoreCase("true")) {
                _debugJavascript = Boolean.TRUE;
                _LOG.info("RUNNING_DEBUG_JAVASCRIPT");
            } else {
                _debugJavascript = Boolean.FALSE;
            }
        }
        return _debugJavascript;
    }

    static {
        _LIBRARY_VERSION = null;
        _LOG = TrinidadLogger.createTrinidadLogger(LibraryScriptlet.class);
        _LIBRARY_VERSION = CoreRenderKitResourceLoader.__getVersion();
    }
}

