/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.skin;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.skin.SkinCSSDocumentHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkinCSSParser {
    private SkinCSSDocumentHandler _documentHandler;
    private CSSScanner _scanner;
    private int _currentType;
    private static final Pattern _COMMENT_PATTERN = Pattern.compile("(?s)/\\*.*?\\*/");
    private static final String[] _EMPTY_STRING_ARRAY = new String[0];
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(SkinCSSParser.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseCSSDocument(Reader in, SkinCSSDocumentHandler documentHandler) {
        try {
            this._documentHandler = documentHandler;
            this._scanner = new CSSScanner(in);
            this._documentHandler.startDocument();
            List<String> selectorList = null;
            this._currentType = this._nextIgnoreSpaces();
            while (this._currentType != 0) {
                if (this._currentType == 4) {
                    this._documentHandler.comment(this._scanner.getStringValue());
                } else if (this._currentType == 5) {
                    this._documentHandler.atRule(this._scanner.getStringValue());
                } else if (this._currentType == 1) {
                    this._documentHandler.startSelector();
                    selectorList = this._parseSelectorString(this._scanner.getStringValue());
                } else if (this._currentType == 2) {
                    String properties = this._scanner.getStringValue();
                    this._handlePropertiesString(properties);
                    if (selectorList == null && _LOG.isWarning()) {
                        _LOG.warning("IGNORING_PROPERTIES_WITHOUT_SELECTOR", (Object)properties);
                    }
                    this._documentHandler.endSelector(selectorList);
                }
                this._nextIgnoreSpaces();
            }
        }
        finally {
            this._documentHandler.endDocument();
        }
    }

    private List<String> _parseSelectorString(String selectors) {
        if (selectors == null) {
            return null;
        }
        ArrayList<String> selectorList = new ArrayList<String>();
        String[] selector = SkinCSSParser._splitString(selectors, ',', false);
        for (int i = 0; i < selector.length; ++i) {
            String trimmedSelector = i == 0 ? SkinCSSParser._trimChar(selector[i].trim(), '}') : selector[i].trim();
            selectorList.add(trimmedSelector);
        }
        return selectorList;
    }

    private void _handlePropertiesString(String properties) {
        if (properties == null) {
            return;
        }
        Matcher matcher = _COMMENT_PATTERN.matcher(properties);
        properties = matcher.replaceAll("");
        String[] property = SkinCSSParser._splitString(properties, ';', false);
        for (int i = 0; i < property.length; ++i) {
            int indexOfColon = property[i].indexOf(58);
            if (indexOfColon <= -1 || indexOfColon >= property[i].length()) continue;
            String name = property[i].substring(0, indexOfColon);
            String value = property[i].substring(indexOfColon + 1);
            this._documentHandler.property(name.trim(), value.trim());
        }
    }

    private static String[] _splitString(String in, char charDelimiter, boolean skipWhitespace) {
        int length = in.length();
        StringBuffer buffer = new StringBuffer(length);
        ArrayList<String> splitList = new ArrayList<String>();
        for (int i = 0; i < length; ++i) {
            char c = in.charAt(i);
            if (c == charDelimiter) {
                splitList.add(buffer.toString());
                buffer = new StringBuffer(length);
                continue;
            }
            if (skipWhitespace && Character.isWhitespace(c)) continue;
            buffer.append(c);
        }
        String lastString = buffer.toString();
        if (lastString.length() > 0) {
            splitList.add(lastString);
        }
        return splitList.toArray(_EMPTY_STRING_ARRAY);
    }

    private static String _trimChar(String in, char c) {
        int len = in.length();
        char currentChar = in.charAt(0);
        if (currentChar != c) {
            return in;
        }
        for (int i = 1; i < len; ++i) {
            currentChar = in.charAt(i);
            if (currentChar == c) continue;
            return in.substring(i);
        }
        return in;
    }

    private int _nextIgnoreSpaces() {
        this._currentType = this._scanner.getNextToken();
        while (this._currentType == 3) {
            this._currentType = this._scanner.getNextToken();
        }
        return this._currentType;
    }

    private static class CSSLexicalUnits {
        public static final int EOF = 0;
        public static final int LEFT_CURLY_BRACE = 1;
        public static final int RIGHT_CURLY_BRACE = 2;
        public static final int SPACE = 3;
        public static final int COMMENT = 4;
        public static final int AT_KEYWORD = 5;

        private CSSLexicalUnits() {
        }
    }

    private static class CSSScanner {
        private Reader _reader;
        private char[] _buffer = new char[1024];
        private int _position;
        private int _end;
        private int _type;
        private int _currentChar;

        public CSSScanner(Reader reader) {
            this._reader = reader;
        }

        public String getStringValue() {
            if (this._end <= 0) {
                return null;
            }
            return new String(this._buffer, 0, this._end);
        }

        public int getNextToken() {
            this._position = 0;
            this._fillToken();
            this._end = this._position;
            if (this._type == 2 || this._type == 1) {
                --this._end;
            }
            if (this._currentChar == -1) {
                return 0;
            }
            return this._type;
        }

        private void _fillToken() {
            block6: do {
                this._nextChar();
                switch (this._currentChar) {
                    case -1: {
                        this._type = 0;
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 12: 
                    case 13: 
                    case 32: {
                        if (this._type != 1) {
                            this._type = 3;
                            return;
                        }
                    }
                    case 47: {
                        if (this._type != 1) {
                            this._nextChar();
                            if (this._currentChar != 42) continue block6;
                            this._nextChar();
                            while (this._currentChar != -1) {
                                int prevChar = this._currentChar;
                                this._nextChar();
                                if (prevChar != 42 || this._currentChar != 47) continue;
                            }
                            this._type = 4;
                            return;
                        }
                    }
                    case 64: {
                        if (this._type != 1) {
                            this._nextChar();
                            int openBraceCount = 0;
                            boolean openBraceCountStarted = false;
                            while (this._currentChar != -1) {
                                if (this._currentChar == 123) {
                                    ++openBraceCount;
                                }
                                if (openBraceCount == 1) {
                                    openBraceCountStarted = true;
                                }
                                if (this._currentChar == 125 && openBraceCountStarted && openBraceCountStarted && --openBraceCount == 0 || this._currentChar == 59 && openBraceCount == 0) break;
                                this._nextChar();
                            }
                            this._type = 5;
                            return;
                        }
                    }
                    default: {
                        if (this._type == 1) {
                            while (this._currentChar != -1 && this._currentChar != 125) {
                                this._nextChar();
                            }
                            this._type = 2;
                        } else {
                            while (this._currentChar != -1 && this._currentChar != 123) {
                                this._nextChar();
                            }
                            this._type = 1;
                        }
                        return;
                    }
                }
            } while (this._currentChar != -1);
            this._type = 0;
        }

        private void _nextChar() {
            try {
                this._currentChar = this._reader.read();
            }
            catch (IOException e) {
                if (_LOG.isSevere()) {
                    _LOG.severe("ERR_READING_SKIN_CSS_FILE", (Throwable)e);
                }
                this._currentChar = -1;
                return;
            }
            if (this._buffer.length <= this._position) {
                char[] tmp = new char[this._buffer.length + this._buffer.length / 2];
                for (int i = 0; i < this._buffer.length; ++i) {
                    tmp[i] = this._buffer[i];
                }
                this._buffer = tmp;
            }
            this._buffer[this._position++] = (char)this._currentChar;
        }
    }
}

