/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.ui.data.bind;

import java.lang.reflect.UndeclaredThrowableException;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.util.ClassLoaderUtils;
import org.apache.myfaces.trinidadinternal.share.expl.Coercions;
import org.apache.myfaces.trinidadinternal.ui.UIXRenderingContext;
import org.apache.myfaces.trinidadinternal.ui.data.BoundValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class ConvertBoundValue
implements BoundValue {
    private BoundValue _wrapped;
    private String _javaType;
    private Class<?> _class;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(ConvertBoundValue.class);

    public ConvertBoundValue(BoundValue wrapped, String javaType) {
        if (wrapped == null) {
            throw new IllegalArgumentException();
        }
        this._wrapped = wrapped;
        this._javaType = ConvertBoundValue.getClassName(javaType);
    }

    public ConvertBoundValue(BoundValue wrapped, Class<?> javaType) {
        if (wrapped == null) {
            throw new IllegalArgumentException();
        }
        this._wrapped = wrapped;
        this._javaType = javaType.getName();
        this._class = javaType;
    }

    @Override
    public Object getValue(UIXRenderingContext context) {
        Object value = this._wrapped.getValue(context);
        try {
            return Coercions.coerce(value, this._getTargetType());
        }
        catch (NumberFormatException nfe) {
            if (_LOG.isWarning()) {
                _LOG.warning("CANNOT_CONVERT", new Object[]{value, this._getTargetType().getName()});
            }
        }
        catch (IllegalArgumentException e) {
            _LOG.severe((Throwable)e);
        }
        return null;
    }

    public static String getClassName(String javaType) {
        if ("byte".equals(javaType)) {
            return "java.lang.Byte";
        }
        if ("short".equals(javaType)) {
            return "java.lang.Short";
        }
        if ("int".equals(javaType)) {
            return "java.lang.Integer";
        }
        if ("long".equals(javaType)) {
            return "java.lang.Long";
        }
        if ("float".equals(javaType)) {
            return "java.lang.Float";
        }
        if ("double".equals(javaType)) {
            return "java.lang.Double";
        }
        if ("char".equals(javaType)) {
            return "java.lang.Character";
        }
        if ("boolean".equals(javaType)) {
            return "java.lang.Boolean";
        }
        if ("string".equals(javaType)) {
            return "java.lang.String";
        }
        return javaType;
    }

    private Class<?> _getTargetType() {
        if (this._class == null) {
            try {
                this._class = ClassLoaderUtils.loadClass((String)this._javaType);
            }
            catch (ClassNotFoundException e) {
                throw new UndeclaredThrowableException(e);
            }
        }
        return this._class;
    }
}

