/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.desktop;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.component.UIXProcess;
import org.apache.myfaces.trinidad.component.core.nav.CoreTrain;
import org.apache.myfaces.trinidad.context.FormData;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.render.CoreRenderer;
import org.apache.myfaces.trinidad.skin.Icon;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.OutputUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.PartialPageUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.ProcessUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrainRenderer
extends XhtmlRenderer {
    public static final int DEFAULT_MAX_VISIBLE_STOP_COUNT = 6;
    public static final boolean DEFAULT_RENDER_PARENT_TRAIN = false;
    private static final String _STATE_ACTIVE = "p_AFSelected";
    private static final String _STATE_DISABLED = "p_AFDisabled";
    private static final String _STATE_PARENT = "p_AFParent";
    private static final String _STATE_READ_ONLY = "p_AFReadOnly";
    private static final String _STATE_UNVISITED = "p_AFUnvisited";
    private static final String _STATE_VISITED = "p_AFVisited";
    private static final String _SUFFIX_CONTENT = "-content";
    private static final String _SUFFIX_ICON_CELL = "-icon-cell";
    private static final String _SUFFIX_ACTIVE = ":selected";
    private static final String _SUFFIX_READ_ONLY = ":read-only";
    private static final String _SUFFIX_UNVISITED = ":unvisited";
    private static final String _SUFFIX_VISITED = ":visited";
    private static final String _VISITED_KEY = "af_train.VISITED_TIP";
    private static final String _ACTIVE_KEY = "af_train.ACTIVE_TIP";
    private static final String _NEXT_KEY = "af_train.NEXT_TIP";
    private static final String _MORE_KEY = "af_train.MORE";
    private static final String _PREVIOUS_KEY = "af_train.PREVIOUS";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(TrainRenderer.class);
    private static final String[] _EMPTY_STRING_ARRAY = new String[0];
    private static final Map<String, String> _RESOURCE_KEY_MAP = new TreeMap<String, String>();

    public TrainRenderer() {
        super(CoreTrain.TYPE);
    }

    public void decode(FacesContext context, UIComponent component) {
        Object source;
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        Object event = requestMap.get("event");
        if (event != null && event.equals("goto") && (source = requestMap.get("source")) != null && source.equals(component.getClientId(context))) {
            Object valueObject = requestMap.get("value");
            Object sizeObject = requestMap.get("size");
            if (valueObject != null) {
                int value = -1;
                try {
                    value = Integer.parseInt(valueObject.toString());
                }
                catch (NumberFormatException nfe) {
                    _LOG.severe((Throwable)nfe);
                }
                int size = 0;
                try {
                    size = Integer.parseInt(sizeObject.toString());
                }
                catch (NumberFormatException nfe) {
                    _LOG.warning((Throwable)nfe);
                }
                if (size < 0) {
                    size = 0;
                }
                if (value >= 0) {
                    UIXProcess process = (UIXProcess)component;
                    Object oldPath = process.getRowKey();
                    Object focusPath = process.getFocusRowKey();
                    process.setRowKey(focusPath);
                    UIComponent stamp = process.getNodeStamp();
                    int index = process.getRowIndex();
                    index = size == 0 ? ProcessUtils.getBackIndex(process, stamp, index) : ProcessUtils.getNextIndex(process, stamp, index);
                    process.setRowIndex(index);
                    new ActionEvent(stamp).queue();
                    process.setRowKey(oldPath);
                }
            }
        }
    }

    public boolean getRendersChildren() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void encodeAll(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean) throws IOException {
        if (!PartialPageUtils.containsPprTargets(arc, component, this.getClientId(context, component))) {
            return;
        }
        if (!(component instanceof UIXProcess)) {
            throw new ClassCastException(_LOG.getMessage("TRAINRENDERER_ONLY_RENDERS_INSTANCE", new Object[]{UIXProcess.class.getName(), component.getClass().getName()}));
        }
        if (arc.getFormData() == null) {
            _LOG.warning("TRAIN_MUST_INSIDE_FORM");
            return;
        }
        UIXProcess process = (UIXProcess)component;
        UIComponent stamp = process.getNodeStamp();
        if (stamp != null) {
            Train train = new Train(context, arc, process, stamp);
            try {
                process.setRowKey(train.getFocusRowKey());
                this._renderHiddenFields(context, arc, train);
                ResponseWriter writer = context.getResponseWriter();
                writer.startElement("table", component);
                process.setRowKey(train.getInitialRowKey());
                this.renderId(context, component);
                this.renderAllAttributes(context, arc, bean);
                if (!train.getStations().isEmpty()) {
                    process.setRowKey(train.getFocusRowKey());
                    writer.startElement("tbody", null);
                    this._renderTrain(context, arc, process, bean, stamp, train);
                    writer.endElement("tbody");
                }
                writer.endElement("table");
            }
            finally {
                process.setRowKey(train.getInitialRowKey());
            }
        } else {
            _LOG.warning("NODESTAMP_FACET_NOT_FOUND_FOR_TRAIN", (Object)component);
        }
    }

    @Override
    protected void renderAllAttributes(FacesContext context, RenderingContext arc, FacesBean bean) throws IOException {
        super.renderAllAttributes(context, arc, bean);
        OutputUtils.renderLayoutTableAttributes(context, arc, "0", null);
    }

    @Override
    protected void renderStyleAttributes(FacesContext context, RenderingContext arc, FacesBean bean) throws IOException {
        this.renderStyleAttributes(context, arc, bean, "af|train");
    }

    private void _preRenderIconBlock(FacesContext context, RenderingContext arc) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("td", null);
        writer.startElement("table", null);
        OutputUtils.renderLayoutTableAttributes(context, arc, "0", null);
        writer.writeAttribute("style", (Object)"width: 100%", null);
        writer.startElement("tbody", null);
        writer.startElement("tr", null);
    }

    private void _postRenderIconBlock(FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement("tr");
        writer.endElement("tbody");
        writer.endElement("table");
        writer.endElement("td");
    }

    private void _renderHiddenFields(FacesContext context, RenderingContext arc, Train train) throws IOException {
        if (train.getFormName() != null && TrainRenderer.supportsScripting(arc)) {
            FormData formData = arc.getFormData();
            if (formData != null) {
                formData.addNeededValue("event");
                formData.addNeededValue("source");
                formData.addNeededValue("value");
                formData.addNeededValue("size");
            }
            ProcessUtils.renderNavSubmitScript(context, arc);
        }
    }

    private void _renderContentRowLtr(FacesContext context, RenderingContext arc, UIXProcess process, UIComponent stamp, Train train) throws IOException {
        ParentTrain parentTrain = train.getParentTrain();
        if (parentTrain != null && parentTrain.hasParentStart()) {
            this._renderParentContent(context, arc, parentTrain.getParentStart());
        }
        for (Station station : train.getStations()) {
            this._renderStationContent(context, arc, process, stamp, station);
        }
        if (parentTrain != null && parentTrain.hasParentEnd()) {
            this._renderParentContent(context, arc, parentTrain.getParentEnd());
        }
    }

    private void _renderContentRowRtl(FacesContext context, RenderingContext arc, UIXProcess process, UIComponent stamp, Train train) throws IOException {
        ParentTrain parentTrain = train.getParentTrain();
        if (parentTrain != null && parentTrain.hasParentEnd()) {
            this._renderParentContent(context, arc, parentTrain.getParentEnd());
        }
        List<Station> stations = train.getStations();
        ListIterator<Station> iterator = stations.listIterator(stations.size());
        while (iterator.hasPrevious()) {
            this._renderStationContent(context, arc, process, stamp, iterator.previous());
        }
        if (parentTrain != null && parentTrain.hasParentStart()) {
            this._renderParentContent(context, arc, parentTrain.getParentStart());
        }
    }

    private void _renderIconBlock(FacesContext context, RenderingContext arc, List<String> iconNames, String shortDesc, String styleClass, String iconStyleClass, List<String> stateStyleClasses) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("td", null);
        stateStyleClasses.add(styleClass);
        stateStyleClasses.add(iconStyleClass);
        TrainRenderer.renderStyleClasses((FacesContext)context, (RenderingContext)arc, (String[])stateStyleClasses.toArray(_EMPTY_STRING_ARRAY));
        if (iconNames != null) {
            for (String iconName : iconNames) {
                Icon icon = arc.getIcon(iconName);
                if (icon == null) continue;
                OutputUtils.renderIcon(context, arc, icon, shortDesc, null);
                break;
            }
        }
        writer.endElement("td");
    }

    private void _renderIconRowLtr(FacesContext context, RenderingContext arc, UIXProcess process, Train train) throws IOException {
        ParentTrain parentTrain = train.getParentTrain();
        if (parentTrain != null && parentTrain.hasParentStart()) {
            this._renderParentStartLtr(context, arc, process, train);
        }
        for (Station station : train.getStations()) {
            this._renderStationIconLtr(context, arc, process, station);
        }
        if (parentTrain != null && parentTrain.hasParentEnd()) {
            this._renderParentEndLtr(context, arc, process, train);
        }
    }

    private void _renderIconRowRtl(FacesContext context, RenderingContext arc, UIXProcess process, Train train) throws IOException {
        ParentTrain parentTrain = train.getParentTrain();
        if (parentTrain != null && parentTrain.hasParentEnd()) {
            this._renderParentEndRtl(context, arc, process, train);
        }
        List<Station> stations = train.getStations();
        ListIterator<Station> iterator = stations.listIterator(stations.size());
        while (iterator.hasPrevious()) {
            this._renderStationIconRtl(context, arc, process, iterator.previous());
        }
        if (parentTrain != null && parentTrain.hasParentStart()) {
            this._renderParentStartRtl(context, arc, process, train);
        }
    }

    private void _renderJoin(FacesContext context, RenderingContext arc, String stateStyleClass, boolean overflow) throws IOException {
        if (_STATE_PARENT.equals(stateStyleClass)) {
            this._renderJoin(context, arc, "af|train::join-parent", null);
        } else if (overflow) {
            this._renderJoin(context, arc, "af|train::join-overflow", stateStyleClass);
        } else {
            this._renderJoin(context, arc, "af|train::join", stateStyleClass);
        }
    }

    private void _renderJoin(FacesContext context, RenderingContext arc, String joinStyleClass, String stateStyleClass) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("td", null);
        TrainRenderer.renderStyleClasses((FacesContext)context, (RenderingContext)arc, (String[])new String[]{joinStyleClass, stateStyleClass});
        writer.endElement("td");
    }

    private void _renderJoinIconBlock(FacesContext context, RenderingContext arc, String stateStyleClass, boolean overflow) throws IOException {
        if (_STATE_PARENT.equals(stateStyleClass)) {
            this._renderJoinIconBlock(context, arc, "af|train::join-parent", null);
        } else if (overflow) {
            this._renderJoinIconBlock(context, arc, "af|train::join-overflow", stateStyleClass);
        } else {
            this._renderJoinIconBlock(context, arc, "af|train::join", stateStyleClass);
        }
    }

    private void _renderJoinIconBlock(FacesContext context, RenderingContext arc, String joinStyleClass, String stateStyleClass) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("td", null);
        writer.writeAttribute("style", (Object)"width: 50%", null);
        TrainRenderer.renderStyleClasses((FacesContext)context, (RenderingContext)arc, (String[])new String[]{joinStyleClass, stateStyleClass});
        writer.endElement("td");
    }

    private void _renderParentContent(FacesContext context, RenderingContext arc, Station parent) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String baseStyleClass = parent.getBaseStyleClass();
        writer.startElement("td", null);
        writer.writeAttribute("colspan", (Object)"3", null);
        TrainRenderer.renderStyleClasses((FacesContext)context, (RenderingContext)arc, (String[])new String[]{baseStyleClass, baseStyleClass + _SUFFIX_CONTENT});
        if (arc.getAgent().getAgentName().equalsIgnoreCase("ie")) {
            writer.writeAttribute("style", (Object)"background-image:none;", null);
        }
        writer.endElement("td");
    }

    private void _renderParentEnd(FacesContext context, RenderingContext arc, UIXProcess process, Train train, String leftState, String rightState) throws IOException {
        this._renderJoin(context, arc, leftState, false);
        this._preRenderIconBlock(context, arc);
        this._renderJoinIconBlock(context, arc, leftState, false);
        this._renderParentEndIconBlock(context, arc, process, train);
        this._renderJoinIconBlock(context, arc, rightState, false);
        this._postRenderIconBlock(context);
        this._renderJoin(context, arc, rightState, false);
    }

    private void _renderParentEndLtr(FacesContext context, RenderingContext arc, UIXProcess process, Train train) throws IOException {
        this._renderParentEnd(context, arc, process, train, _STATE_PARENT, null);
    }

    private void _renderParentEndRtl(FacesContext context, RenderingContext arc, UIXProcess process, Train train) throws IOException {
        this._renderParentEnd(context, arc, process, train, null, _STATE_PARENT);
    }

    private void _renderParentEndIconBlock(FacesContext context, RenderingContext arc, UIXProcess process, Train train) throws IOException {
        assert (train.getParentTrain().hasParentEnd());
        Station parent = train.getParentTrain().getParentEnd();
        process.setRowKey(parent.getRowKey());
        this._renderStationIconBlock(context, arc, process, parent);
        process.setRowKey(train.getInitialRowKey());
    }

    private void _renderParentStartIconBlock(FacesContext context, RenderingContext arc, UIXProcess process, Train train) throws IOException {
        assert (train.getParentTrain().hasParentStart());
        Station parent = train.getParentTrain().getParentStart();
        process.setRowKey(parent.getRowKey());
        this._renderStationIconBlock(context, arc, process, parent);
        process.setRowKey(train.getInitialRowKey());
    }

    private void _renderParentStart(FacesContext context, RenderingContext arc, UIXProcess process, Train train, String leftState, String rightState) throws IOException {
        this._renderJoin(context, arc, leftState, false);
        this._preRenderIconBlock(context, arc);
        this._renderJoinIconBlock(context, arc, leftState, false);
        this._renderParentStartIconBlock(context, arc, process, train);
        this._renderJoinIconBlock(context, arc, rightState, false);
        this._postRenderIconBlock(context);
        this._renderJoin(context, arc, rightState, false);
    }

    private void _renderParentStartLtr(FacesContext context, RenderingContext arc, UIXProcess process, Train train) throws IOException {
        this._renderParentStart(context, arc, process, train, null, _STATE_PARENT);
    }

    private void _renderParentStartRtl(FacesContext context, RenderingContext arc, UIXProcess process, Train train) throws IOException {
        this._renderParentStart(context, arc, process, train, _STATE_PARENT, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _renderStationContent(FacesContext context, RenderingContext arc, UIXProcess process, UIComponent stamp, Station station) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("td", null);
        writer.writeAttribute("colspan", (Object)"3", null);
        String baseStyleClass = station.getBaseStyleClass();
        List<String> stateStyleClasses = station.getStates();
        stateStyleClasses.add(baseStyleClass);
        stateStyleClasses.add(baseStyleClass + _SUFFIX_CONTENT);
        TrainRenderer.renderStyleClasses((FacesContext)context, (RenderingContext)arc, (String[])stateStyleClasses.toArray(_EMPTY_STRING_ARRAY));
        if (arc.getAgent().getAgentName().equalsIgnoreCase("ie")) {
            writer.writeAttribute("style", (Object)"background-image:none;", null);
        }
        Map originalMap = arc.getSkinResourceKeyMap();
        process.setRowIndex(station.getRowIndex());
        try {
            arc.setSkinResourceKeyMap(_RESOURCE_KEY_MAP);
            this.encodeChild(context, stamp);
        }
        finally {
            arc.setSkinResourceKeyMap(originalMap);
        }
        writer.endElement("td");
    }

    private void _renderStationIcon(FacesContext context, RenderingContext arc, UIXProcess process, Station station, String leftJoinState, String rightJoinState, boolean overflowLeft, boolean overflowRight) throws IOException {
        this._renderJoin(context, arc, leftJoinState, overflowLeft);
        this._preRenderIconBlock(context, arc);
        this._renderJoinIconBlock(context, arc, leftJoinState, overflowLeft);
        this._renderStationIconBlock(context, arc, process, station);
        this._renderJoinIconBlock(context, arc, rightJoinState, overflowRight);
        this._postRenderIconBlock(context);
        this._renderJoin(context, arc, rightJoinState, overflowRight);
    }

    private void _renderStationIconBlock(FacesContext context, RenderingContext arc, UIXProcess process, Station station) throws IOException {
        process.setRowIndex(station.getRowIndex());
        String baseStyleClass = station.getBaseStyleClass();
        this._renderIconBlock(context, arc, station.getIconNames(), station.getLabel(), baseStyleClass, baseStyleClass + _SUFFIX_ICON_CELL, station.getStates());
    }

    private void _renderStationIconLtr(FacesContext context, RenderingContext arc, UIXProcess process, Station station) throws IOException {
        this._renderStationIcon(context, arc, process, station, station.getStartJoinState(), station.getEndJoinState(), station.hasPrevious() && station.getPrevious().isOverflowStart(), station.hasNext() && station.getNext().isOverflowEnd());
    }

    private void _renderStationIconRtl(FacesContext context, RenderingContext arc, UIXProcess process, Station station) throws IOException {
        this._renderStationIcon(context, arc, process, station, station.getEndJoinState(), station.getStartJoinState(), station.hasNext() && station.getNext().isOverflowEnd(), station.hasPrevious() && station.getPrevious().isOverflowStart());
    }

    private void _renderTrain(FacesContext context, RenderingContext arc, UIXProcess process, FacesBean bean, UIComponent stamp, Train train) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("tr", null);
        if (arc.isRightToLeft()) {
            this._renderIconRowRtl(context, arc, process, train);
        } else {
            this._renderIconRowLtr(context, arc, process, train);
        }
        writer.endElement("tr");
        writer.startElement("tr", null);
        if (arc.isRightToLeft()) {
            this._renderContentRowRtl(context, arc, process, stamp, train);
        } else {
            this._renderContentRowLtr(context, arc, process, stamp, train);
        }
        writer.endElement("tr");
    }

    static {
        _RESOURCE_KEY_MAP.put("OraLink", "af|train::link");
        _RESOURCE_KEY_MAP.put("OraLinkDisabled", "af|train::link");
    }

    private static class ParentTrain {
        private Station _parentEnd;
        private Station _parentStart;

        public ParentTrain(RenderingContext arc, UIXProcess process, UIComponent stamp, Train train) {
            boolean hasParentEnd;
            List<Station> stations = train.getStations();
            int stationCount = stations.size();
            boolean hasParentStart = !stations.get(0).isOverflowStart();
            boolean bl = hasParentEnd = !stations.get(stationCount - 1).isOverflowEnd();
            if (hasParentStart || hasParentEnd) {
                Object parentStartRowKey = process.getContainerRowKey();
                process.setRowKey(parentStartRowKey);
                int rowIndex = process.getRowIndex();
                if (hasParentStart) {
                    this._parentStart = new Station(train, rowIndex, parentStartRowKey);
                    this._parentStart.setParentStart(true);
                    this._parentStart.initLabel(arc, stamp);
                }
                boolean bl2 = hasParentEnd = ++rowIndex < process.getRowCount();
                if (hasParentEnd) {
                    process.setRowIndex(rowIndex);
                    this._parentEnd = new Station(train, rowIndex, process.getRowKey());
                    this._parentEnd.setParentEnd(true);
                    this._parentEnd.initLabel(arc, stamp);
                }
                process.setRowKey(train.getInitialRowKey());
            }
        }

        public Station getParentEnd() {
            return this._parentEnd;
        }

        public Station getParentStart() {
            return this._parentStart;
        }

        public boolean hasParentEnd() {
            return this._parentEnd != null;
        }

        public boolean hasParentStart() {
            return this._parentStart != null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Station {
        private boolean _active;
        private boolean _disabled;
        private boolean _overflowEnd;
        private boolean _overflowStart;
        private boolean _parentEnd;
        private boolean _parentStart;
        private boolean _visited;
        private int _rowIndex;
        private Object _rowKey;
        private String _label;
        private Station _next;
        private Station _previous;
        private Train _train;

        public Station(Train train, int index, Object rowKey) {
            this._rowIndex = index;
            this._rowKey = rowKey;
            this._active = false;
            this._visited = false;
            this._disabled = false;
            this._parentEnd = false;
            this._parentStart = false;
            this._train = train;
        }

        public Station(Train train, UIComponent stamp, int index, Object rowKey, boolean active) {
            Map attributes = stamp.getAttributes();
            this._rowIndex = index;
            this._rowKey = rowKey;
            this._active = active;
            this._visited = this._getBooleanAttribute(attributes, "visited", false);
            this._disabled = this._getBooleanAttribute(attributes, "disabled", false);
            this._parentEnd = false;
            this._parentStart = false;
            this._train = train;
        }

        public String getBaseStyleClass() {
            if (this.isOverflowEnd()) {
                return "af|train::overflow-end";
            }
            if (this.isOverflowStart()) {
                return "af|train::overflow-start";
            }
            if (this.isParentStart()) {
                return "af|train::parent-start";
            }
            if (this.isParentEnd()) {
                return "af|train::parent-end";
            }
            return "af|train::stop";
        }

        public String getEndJoinState() {
            if (this.isOverflowEnd()) {
                return null;
            }
            if (!this.hasNext()) {
                ParentTrain parent = this._train.getParentTrain();
                if (parent != null && parent.hasParentEnd()) {
                    return TrainRenderer._STATE_PARENT;
                }
                return null;
            }
            if (this.getNext().isVisited()) {
                return TrainRenderer._STATE_VISITED;
            }
            if (this.getNext().isDisabled()) {
                return TrainRenderer._STATE_DISABLED;
            }
            return TrainRenderer._STATE_UNVISITED;
        }

        public List<String> getIconNames() {
            if (this.isOverflowEnd()) {
                return this._getOverflowEndIconNames();
            }
            if (this.isOverflowStart()) {
                return this._getOverflowStartIconNames();
            }
            if (this.isParentStart()) {
                return Collections.singletonList("af|train::parent-start-icon");
            }
            if (this.isParentEnd()) {
                return Collections.singletonList("af|train::parent-end-icon");
            }
            return this._getStopIconNames();
        }

        public String getLabel() {
            return this._label;
        }

        public Station getNext() {
            return this._next;
        }

        public Station getPrevious() {
            return this._previous;
        }

        public int getRowIndex() {
            return this._rowIndex;
        }

        public Object getRowKey() {
            return this._rowKey;
        }

        public String getStartJoinState() {
            if (this.isOverflowStart()) {
                return null;
            }
            if (!this.hasPrevious()) {
                ParentTrain parent = this._train.getParentTrain();
                if (parent != null && parent.hasParentStart()) {
                    return TrainRenderer._STATE_PARENT;
                }
                return null;
            }
            if (this.isVisited()) {
                return TrainRenderer._STATE_VISITED;
            }
            if (this.isDisabled()) {
                return TrainRenderer._STATE_DISABLED;
            }
            return TrainRenderer._STATE_UNVISITED;
        }

        public List<String> getStates() {
            ArrayList<String> states = new ArrayList<String>(5);
            if (this.isParentStart() || this.isParentEnd()) {
                return states;
            }
            if (this.isActive()) {
                states.add(TrainRenderer._STATE_ACTIVE);
                return states;
            }
            if (this.isVisited()) {
                states.add(TrainRenderer._STATE_VISITED);
            } else {
                states.add(TrainRenderer._STATE_UNVISITED);
            }
            if (this.isDisabled()) {
                states.add(TrainRenderer._STATE_READ_ONLY);
            }
            return states;
        }

        public boolean hasNext() {
            return this._next != null;
        }

        public boolean hasPrevious() {
            return this._previous != null;
        }

        public void initLabel(RenderingContext arc, UIComponent stamp) {
            if (this.isOverflowStart()) {
                this._label = arc.getTranslatedString(TrainRenderer._PREVIOUS_KEY);
            } else if (this.isOverflowEnd()) {
                this._label = arc.getTranslatedString(TrainRenderer._MORE_KEY);
            } else {
                Object text = stamp.getAttributes().get("text");
                if (text != null) {
                    this._label = text.toString();
                    if (CoreRenderer.isScreenReaderMode((RenderingContext)arc)) {
                        this._label = this._getDisabledUserText(arc, this._label);
                    }
                } else {
                    this._label = null;
                }
            }
        }

        public boolean isActive() {
            return this._active;
        }

        public boolean isDisabled() {
            return this._disabled;
        }

        public boolean isNextDisabled() {
            return this.hasNext() && this._next.isDisabled();
        }

        public boolean isOverflowEnd() {
            return this._overflowEnd;
        }

        public boolean isOverflowStart() {
            return this._overflowStart;
        }

        public boolean isParentEnd() {
            return this._parentEnd;
        }

        public boolean isParentStart() {
            return this._parentStart;
        }

        public boolean isPreviousDisabled() {
            return this.hasPrevious() && this._previous.isDisabled();
        }

        public boolean isVisited() {
            return this._visited;
        }

        public void setDisabled(boolean disabled) {
            this._disabled = disabled;
        }

        public void setNext(Station next) {
            this._next = next;
        }

        public void setOverflowEnd(boolean overflowEnd) {
            this._overflowEnd = overflowEnd;
        }

        public void setOverflowStart(boolean overflowStart) {
            this._overflowStart = overflowStart;
            this._visited = true;
        }

        public void setParentEnd(boolean parentEnd) {
            this._parentEnd = parentEnd;
        }

        public void setParentStart(boolean parentStart) {
            this._parentStart = parentStart;
        }

        public void setPrevious(Station previous) {
            this._previous = previous;
        }

        private boolean _getBooleanAttribute(Map<String, Object> attributes, String attributeName, boolean defaultValue) {
            Object value = attributes.get(attributeName);
            if (value == null) {
                return defaultValue;
            }
            return Boolean.TRUE.equals(value);
        }

        private String _getDisabledUserText(RenderingContext arc, String text) {
            String altTextKey = this.isActive() ? TrainRenderer._ACTIVE_KEY : (this.isVisited() ? TrainRenderer._VISITED_KEY : TrainRenderer._NEXT_KEY);
            String altText = XhtmlUtils.getFormattedString(arc.getTranslatedString(altTextKey), new String[]{text});
            return altText;
        }

        private List<String> _getIconNames(String baseSelector) {
            LinkedList<String> names = new LinkedList<String>();
            StringBuilder builder = new StringBuilder(64);
            builder.append(baseSelector);
            int suffixLength = "-icon".length();
            int baseIndex = builder.length();
            builder.append("-icon");
            names.addFirst(builder.toString());
            builder.delete(baseIndex, baseIndex + suffixLength);
            if (this.isActive()) {
                builder.append(TrainRenderer._SUFFIX_ACTIVE);
            } else if (this.isVisited()) {
                builder.append(TrainRenderer._SUFFIX_VISITED);
            } else {
                builder.append(TrainRenderer._SUFFIX_UNVISITED);
            }
            baseIndex = builder.length();
            builder.append("-icon");
            names.addFirst(builder.toString());
            builder.delete(baseIndex, baseIndex + suffixLength);
            if (this.isDisabled()) {
                builder.append(TrainRenderer._SUFFIX_READ_ONLY);
                builder.append("-icon");
                names.addFirst(builder.toString());
            }
            return names;
        }

        private List<String> _getOverflowEndIconNames() {
            return this._getIconNames("af|train::overflow-end");
        }

        private List<String> _getOverflowStartIconNames() {
            return this._getIconNames("af|train::overflow-start");
        }

        private List<String> _getStopIconNames() {
            return this._getIconNames("af|train::stop");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Train {
        private Object _focusRowKey;
        private String _formName;
        private Object _initialRowKey;
        private boolean _isSubTrain;
        private ParentTrain _parent;
        private List<Station> _stations;

        public Train(FacesContext context, RenderingContext arc, UIXProcess process, UIComponent stamp) {
            int activeIndex = this._loadStations(process, stamp);
            int visibleStopCount = this._getVisibleStopCount(arc);
            this._formName = arc.getFormData().getName();
            this._isSubTrain = this._loadIsSubTrain(process);
            if (!this._stations.isEmpty()) {
                if (this._stations.size() > visibleStopCount) {
                    this._resolveOverflow(visibleStopCount, activeIndex);
                } else {
                    this._resolveStandard();
                }
                this._initLabels(arc, process, stamp);
                this._initParentTrain(arc, process, stamp);
            }
        }

        public Object getFocusRowKey() {
            return this._focusRowKey;
        }

        public String getFormName() {
            return this._formName;
        }

        public Object getInitialRowKey() {
            return this._initialRowKey;
        }

        public ParentTrain getParentTrain() {
            return this._parent;
        }

        public List<Station> getStations() {
            return this._stations;
        }

        public boolean isSubTrain() {
            return this._isSubTrain;
        }

        private void _createStation(UIXProcess process, UIComponent stamp, int index, boolean active) {
            process.setRowIndex(index);
            if (stamp.isRendered()) {
                this._stations.add(new Station(this, stamp, index, process.getRowKey(), active));
            }
        }

        private int _getVisibleStopCount(RenderingContext arc) {
            Object propValue = arc.getSkin().getProperty((Object)"af|train-tr-visible-stop-count");
            if (propValue == null) {
                return 6;
            }
            try {
                int count = Integer.parseInt(propValue.toString());
                if (count <= 0) {
                    _LOG.warning("VISIBLE_STOP_COUNT_MUST_ABOVE_ZERO", (Object)count);
                    return 6;
                }
                return count;
            }
            catch (NumberFormatException e) {
                _LOG.warning("VISIBLE_STOP_COUNT_MYST_INTEGER", propValue);
                return 6;
            }
        }

        private void _initLabels(RenderingContext arc, UIXProcess process, UIComponent stamp) {
            for (Station s : this._stations) {
                process.setRowIndex(s.getRowIndex());
                s.initLabel(arc, stamp);
            }
        }

        private void _initParentTrain(RenderingContext arc, UIXProcess process, UIComponent stamp) {
            if (this._isSubTrain) {
                if (this._shouldRenderParentTrain(arc)) {
                    this._parent = new ParentTrain(arc, process, stamp, this);
                    if (!this._parent.hasParentStart() && !this._parent.hasParentEnd()) {
                        this._isSubTrain = false;
                    }
                } else {
                    this._isSubTrain = false;
                }
            }
        }

        private boolean _loadIsSubTrain(UIXProcess process) {
            Object focusRowKey = process.getFocusRowKey();
            return focusRowKey != null && process.getDepth(focusRowKey) > 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int _loadStations(UIXProcess process, UIComponent stamp) {
            this._initialRowKey = process.getRowKey();
            try {
                this._focusRowKey = process.getFocusRowKey();
                process.setRowKey(this._focusRowKey);
                int count = process.getRowCount();
                int activeIndex = process.getRowIndex();
                assert (activeIndex < count);
                this._stations = new ArrayList<Station>(count);
                boolean bActiveStop = false;
                for (int index = 0; index < count; ++index) {
                    bActiveStop = index == activeIndex;
                    this._createStation(process, stamp, index, bActiveStop);
                    if (!bActiveStop) continue;
                    activeIndex = this._stations.size() - 1;
                }
                int n = activeIndex;
                return n;
            }
            finally {
                process.setRowKey(this._initialRowKey);
            }
        }

        private void _resolveOverflow(int visibleStopCount, int activeIndex) {
            assert (this._stations != null);
            assert (activeIndex >= -1);
            assert (activeIndex < this._stations.size());
            this._resolveStandard();
            if (activeIndex <= 0) {
                this._resolveOverflowEnd(visibleStopCount);
                this._stations = this._stations.subList(0, visibleStopCount + 1);
            } else {
                int maxGroupIndex;
                int groupIndex = activeIndex / visibleStopCount;
                int startIndex = 0;
                int endIndex = this._stations.size();
                if (groupIndex > 0) {
                    startIndex = groupIndex * visibleStopCount - 1;
                    this._resolveOverflowStart(startIndex);
                }
                if (groupIndex < (maxGroupIndex = (this._stations.size() - 1) / visibleStopCount)) {
                    int overflowIndex = (groupIndex + 1) * visibleStopCount;
                    endIndex = overflowIndex + 1;
                    this._resolveOverflowEnd(overflowIndex);
                }
                this._stations = this._stations.subList(startIndex, endIndex);
            }
        }

        private void _resolveOverflowEnd(int index) {
            assert (this._stations != null);
            assert (index >= 0);
            assert (index < this._stations.size());
            Station station = this._stations.get(index);
            station.setOverflowEnd(true);
            if (station.hasPrevious() && station.getPrevious().isDisabled()) {
                station.setDisabled(true);
            }
            station.setNext(null);
        }

        private void _resolveOverflowStart(int index) {
            assert (this._stations != null);
            assert (index >= 0);
            assert (index < this._stations.size());
            Station station = this._stations.get(index);
            station.setOverflowStart(true);
            if (station.hasNext() && station.getNext().isDisabled()) {
                station.setDisabled(true);
            }
            station.setPrevious(null);
        }

        private void _resolveStandard() {
            if (this._stations.size() > 1) {
                Iterator<Station> iterator = this._stations.iterator();
                Station previous = null;
                Station current = iterator.next();
                Station next = iterator.next();
                this._updateStation(current, previous, next);
                while (iterator.hasNext()) {
                    previous = current;
                    current = next;
                    next = iterator.next();
                    this._updateStation(current, previous, next);
                }
                next.setPrevious(current);
            }
        }

        private boolean _shouldRenderParentTrain(RenderingContext arc) {
            Object propValue = arc.getSkin().getProperty((Object)"af|train-tr-render-parent-train");
            if (propValue == null) {
                return false;
            }
            return Boolean.TRUE.equals(propValue);
        }

        private void _updateStation(Station current, Station previous, Station next) {
            current.setPrevious(previous);
            current.setNext(next);
        }
    }
}

