/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.image.cache;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.share.io.InputStreamProvider;
import org.apache.myfaces.trinidadinternal.image.ImageConstants;
import org.apache.myfaces.trinidadinternal.image.ImageContext;
import org.apache.myfaces.trinidadinternal.image.ImageProviderRequest;
import org.apache.myfaces.trinidadinternal.image.cache.CacheEntry;

class SourceCheckingCacheEntry
extends CacheEntry {
    private Object _provider;
    private static final Object _NULL_PROVIDER = new Object();
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(SourceCheckingCacheEntry.class);

    public SourceCheckingCacheEntry(String uri, int width, int height, String encoding) {
        super(uri, width, height, encoding);
    }

    @Override
    public boolean isValid(ImageContext context, ImageProviderRequest request) {
        if (this._provider == _NULL_PROVIDER) {
            return true;
        }
        InputStreamProvider provider = (InputStreamProvider)this._provider;
        if (provider == null) {
            provider = SourceCheckingCacheEntry._getInputStreamProvider(context, request);
            if (provider == null) {
                this._provider = _NULL_PROVIDER;
                return true;
            }
            this._provider = provider;
        }
        return !provider.hasSourceChanged();
    }

    private static InputStreamProvider _getInputStreamProvider(ImageContext context, ImageProviderRequest request) {
        Map<Object, Object> properties = request.getRenderProperties(context);
        assert (properties != null);
        InputStreamProvider provider = (InputStreamProvider)properties.get(ImageConstants.SOURCE_INPUT_STREAM_PROVIDER_KEY);
        if (provider == null) {
            return null;
        }
        try {
            InputStream in = provider.openInputStream();
            in.close();
        }
        catch (IOException e) {
            _LOG.severe((Throwable)e);
            return null;
        }
        return provider;
    }
}

