/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.ppr;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.context.PartialPageContext;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.render.ExtendedRenderKitService;
import org.apache.myfaces.trinidad.render.RenderUtils;
import org.apache.myfaces.trinidad.util.Service;
import org.apache.myfaces.trinidadinternal.io.ResponseWriterDecorator;
import org.apache.myfaces.trinidadinternal.renderkit.core.pages.GenericEntry;
import org.apache.myfaces.trinidadinternal.renderkit.core.ppr.PartialPageContextImpl;
import org.apache.myfaces.trinidadinternal.renderkit.core.ppr.ScriptBufferingResponseWriter;
import org.apache.myfaces.trinidadinternal.renderkit.core.ppr.XmlResponseWriter;

public class PPRResponseWriter
extends ScriptBufferingResponseWriter {
    private State _state;
    private ResponseWriter _xml;
    private boolean _bufferScripts;
    private final FacesContext _facesContext = FacesContext.getCurrentInstance();
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(PPRResponseWriter.class);
    private static final String _ELEMENT_PARTIAL_RESPONSE = "partial-response";
    private static final String _ELEMENT_CHANGES = "changes";
    private static final String _ELEMENT_CHANGES_UPDATE = "update";
    private static final String _ELEMENT_EVAL = "eval";
    private static final String _ELEMENT_EXTENSION = "extension";
    private static final String _ATTRIBUTE_ID = "id";
    private static final List<String> _allowedIds = Arrays.asList("javax.faces.ViewState");

    public PPRResponseWriter(ResponseWriter out, RenderingContext rc, boolean bufferScripts) {
        super(out, bufferScripts);
        PartialPageContext pprContext = rc.getPartialPageContext();
        if (!(pprContext instanceof PartialPageContextImpl)) {
            throw new IllegalArgumentException();
        }
        this._state = new State((PartialPageContextImpl)pprContext);
        this._xml = new XmlResponseWriter((Writer)out, out.getCharacterEncoding());
        this._bufferScripts = bufferScripts;
    }

    PPRResponseWriter(ResponseWriter out, PPRResponseWriter base) {
        super(out, base._bufferScripts);
        this._xml = new XmlResponseWriter((Writer)out, out.getCharacterEncoding());
        this._state = base._state;
        this._bufferScripts = base._bufferScripts;
    }

    @Override
    public ResponseWriter cloneWithWriter(Writer writer) {
        PPRResponseWriter ppr = new PPRResponseWriter(this.getResponseWriter().cloneWithWriter(writer), this);
        this._state.forceInsideTarget = this._state.documentStarted && this._state.elementDepth == 0;
        return ppr;
    }

    public void startDocument() throws IOException {
        this._state.documentStarted = true;
        this._state.documentStarting = true;
        this._xml.startDocument();
        this._xml.startElement(_ELEMENT_PARTIAL_RESPONSE, null);
        this._state.documentStarting = false;
    }

    public void endDocument() throws IOException {
        this._writeFormActionScript();
        if (this._bufferScripts) {
            this.writeBufferedScripts();
        }
        this.writeFrameworkScripts();
        this._endChanges();
        this._xml.endElement(_ELEMENT_PARTIAL_RESPONSE);
        this._xml.endDocument();
        this._state.forceInsideTarget = true;
    }

    @Override
    public void writeComment(Object text) throws IOException {
        if (this._isInsideTarget()) {
            super.writeComment(text);
        }
    }

    @Override
    public void writeText(Object text, String property) throws IOException {
        if (this._isInsideTarget()) {
            super.writeText(text, property);
        }
    }

    @Override
    public void writeText(char[] text, int start, int length) throws IOException {
        if (this._isInsideTarget()) {
            super.writeText(text, start, length);
        }
    }

    @Override
    public void write(String text) throws IOException {
        this._disableIfNeeded();
        if (this._isInsideTarget()) {
            super.write(text);
        }
    }

    @Override
    public void write(char[] text, int start, int length) throws IOException {
        this._disableIfNeeded();
        if (this._isInsideTarget()) {
            super.write(text, start, length);
        }
    }

    @Override
    public void write(int ch) throws IOException {
        if (this._isInsideTarget()) {
            super.write(ch);
        }
    }

    @Override
    public void write(char[] c) throws IOException {
        this._disableIfNeeded();
        if (this._isInsideTarget()) {
            super.write(c);
        }
    }

    @Override
    public void write(String text, int off, int len) throws IOException {
        this._disableIfNeeded();
        if (this._isInsideTarget()) {
            super.write(text, off, len);
        }
    }

    public void writeText(Object text, UIComponent component, String propertyName) throws IOException {
        if (this._isInsideTarget() && text != null) {
            super.writeText(text, component, propertyName);
        }
    }

    @Override
    public void startElement(String name, UIComponent component) throws IOException {
        ++this._state.elementDepth;
        this._pushPartialTarget(component, name);
        if (this._isInsideTarget()) {
            if (_LOG.isFinest()) {
                _LOG.finest("PPR: Using element {0} in component {1}", new Object[]{name, component});
            }
            super.startElement(name, component);
        } else if (_LOG.isFinest()) {
            _LOG.finest("PPR: Ignoring element {0} in component {1}", new Object[]{name, component});
        }
    }

    @Override
    public void endElement(String name) throws IOException {
        --this._state.elementDepth;
        if (this._isInsideTarget()) {
            super.endElement(name);
        }
        this._popPartialTarget(name);
        super.flush();
    }

    @Override
    public void writeAttribute(String name, Object value, String property) throws IOException {
        if (value == null) {
            return;
        }
        if (this._isInsideTarget()) {
            this._handleIdAttribute(name, value);
            super.writeAttribute(name, value, property);
        }
    }

    @Override
    public void writeURIAttribute(String name, Object value, String property) throws IOException {
        if (this._isInsideTarget()) {
            this._handleIdAttribute(name, value);
            super.writeURIAttribute(name, value, property);
        }
    }

    public void writeViewState(String state) throws IOException {
        this._startChanges();
        this._xml.startElement(_ELEMENT_CHANGES_UPDATE, null);
        this._xml.writeAttribute(_ATTRIBUTE_ID, (Object)"javax.faces.ViewState", null);
        this._xml.startCDATA();
        this._xml.write(state);
        this._xml.endCDATA();
        this._xml.endElement(_ELEMENT_CHANGES_UPDATE);
        this._xml.flush();
    }

    protected ResponseWriter getXmlResponseWriter() {
        return this._xml;
    }

    protected void writeBufferedScripts() throws IOException {
        List<String> scripts;
        List<String> libraries = this.getBufferedLibraries();
        if (libraries != null) {
            for (String library : libraries) {
                this._xml.startElement(_ELEMENT_EXTENSION, null);
                this._xml.writeAttribute(_ATTRIBUTE_ID, (Object)"tr-script-library", null);
                this._xml.writeText((Object)library, null);
                this._xml.endElement(_ELEMENT_EXTENSION);
            }
        }
        if ((scripts = this.getBufferedScripts()) != null) {
            for (String script : scripts) {
                this._xml.startElement(_ELEMENT_EVAL, null);
                this._xml.startCDATA();
                this._xml.write(script);
                this._xml.endCDATA();
                this._xml.endElement(_ELEMENT_EVAL);
            }
        }
        this.clearBufferedContents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeFrameworkScripts() throws IOException {
        ResponseWriter old = this._facesContext.getResponseWriter();
        ResponseWriterDecorator xml = new ResponseWriterDecorator(this._xml){

            public void startElement(String name, UIComponent component) throws IOException {
                if ("script".equalsIgnoreCase(name)) {
                    PPRResponseWriter.this._xml.startElement(PPRResponseWriter._ELEMENT_EVAL, null);
                }
            }

            public void endElement(String name) throws IOException {
                if ("script".equalsIgnoreCase(name)) {
                    PPRResponseWriter.this._xml.endElement(PPRResponseWriter._ELEMENT_EVAL);
                }
            }

            public void writeAttribute(String name, Object value, String attrName) throws IOException {
            }
        };
        this._facesContext.setResponseWriter((ResponseWriter)xml);
        try {
            ExtendedRenderKitService erks = (ExtendedRenderKitService)Service.getService((Object)this._facesContext.getRenderKit(), ExtendedRenderKitService.class);
            if (erks != null) {
                erks.encodeScripts(this._facesContext);
            }
        }
        finally {
            this._facesContext.setResponseWriter(old);
        }
    }

    private void _writeFormActionScript() throws IOException {
        String viewId = this._facesContext.getViewRoot().getViewId();
        if (!GenericEntry.getViewId().equals(viewId)) {
            this._xml.startElement(_ELEMENT_EVAL, null);
            this._xml.startCDATA();
            StringBuilder script = new StringBuilder(128);
            script.append("TrPage.getInstance().__handlePprResponseAction('");
            String actionURL = this._facesContext.getApplication().getViewHandler().getActionURL(this._facesContext, viewId);
            ExternalContext external = this._facesContext.getExternalContext();
            script.append(external.encodeActionURL(actionURL));
            script.append("');");
            this._xml.write(script.toString());
            this._xml.endCDATA();
            this._xml.endElement(_ELEMENT_EVAL);
        }
    }

    private void _pushPartialTarget(UIComponent component, String elementName) throws IOException {
        PPRTag tag = null;
        if (!this._isInsideTarget() && component != null) {
            String clientId = component.getClientId(this._facesContext);
            String renderedClientId = RenderUtils.getRendererClientId((FacesContext)this._facesContext, (UIComponent)component);
            if (this._state.pprContext.isPartialTarget(clientId)) {
                tag = new PPRTag(clientId, renderedClientId);
                this._state.enteringPPR = component;
            }
        }
        if (tag != null) {
            super.flush();
            tag.startUpdate(this._state.pprContext, elementName);
        }
        this._state.componentStack.add(tag);
    }

    private void _popPartialTarget(String elementName) throws IOException {
        List<PPRTag> componentStack = this._state.componentStack;
        int pos = componentStack.size() - 1;
        PPRTag tag = componentStack.get(pos);
        componentStack.remove(pos);
        if (tag != null) {
            tag.finishUpdate(this._state.pprContext, elementName);
        }
    }

    private boolean _isInsideTarget() {
        return this._state.forceInsideTarget || this._state.pprContext.isInsidePartialTarget();
    }

    private void _disableIfNeeded() {
        if (this._state.documentStarting) {
            this._state = new State(this._state.pprContext);
            this._state.forceInsideTarget = true;
        }
    }

    private void _handleIdAttribute(String name, Object value) {
        if (this._state.enteringPPR != null && _ATTRIBUTE_ID.equals(name)) {
            if (_LOG.isFine()) {
                _LOG.fine("Using id {1} for element of {0}", new Object[]{this._state.enteringPPR, value});
            }
            this._state.pprContext.addRenderedPartialTarget(value.toString());
            this._state.enteringPPR = null;
        }
    }

    private void _startChanges() throws IOException {
        if (!this._state.changesStarted) {
            this._xml.startElement(_ELEMENT_CHANGES, null);
            this._state.changesStarted = true;
        }
    }

    private void _endChanges() throws IOException {
        if (this._state.changesStarted) {
            this._xml.endElement(_ELEMENT_CHANGES);
            this._state.changesStarted = false;
        }
    }

    public void startCDATA() throws IOException {
        this._xml.startCDATA();
    }

    public void endCDATA() throws IOException {
        this._xml.endCDATA();
    }

    private static class State {
        public UIComponent enteringPPR;
        public boolean forceInsideTarget;
        public int elementDepth;
        public boolean documentStarted;
        public boolean documentStarting;
        public boolean changesStarted;
        public final List<PPRTag> componentStack = new ArrayList<PPRTag>(50);
        public final PartialPageContextImpl pprContext;

        public State(PartialPageContextImpl pprContext) {
            this.pprContext = pprContext;
        }
    }

    private class PPRTag {
        private String _id;
        private String _renderedId;

        private PPRTag(String id, String renderedId) {
            this._id = id;
            this._renderedId = renderedId != null ? renderedId : id;
        }

        public void startUpdate(PartialPageContextImpl pprContext, String elementName) throws IOException {
            if (this._id != null) {
                PPRResponseWriter.this._startChanges();
                pprContext.pushRenderedPartialTarget(this._id);
                PPRResponseWriter.this._xml.startElement(PPRResponseWriter._ELEMENT_CHANGES_UPDATE, null);
                PPRResponseWriter.this._xml.writeAttribute(PPRResponseWriter._ATTRIBUTE_ID, (Object)this._renderedId, null);
                PPRResponseWriter.this._xml.startCDATA();
                PPRResponseWriter.this._xml.flush();
                if (_LOG.isFine()) {
                    _LOG.fine("Entering partial target id {0}", (Object)this._id);
                }
                this._startWrapperElements(elementName);
            }
        }

        public void finishUpdate(PartialPageContextImpl pprContext, String elementName) throws IOException {
            if (this._id != null) {
                if (((PPRResponseWriter)PPRResponseWriter.this)._state.enteringPPR != null) {
                    _LOG.warning("NO_PPR_CAPABLE_ID_FOUND_FOR_COMPONENT", (Object)((PPRResponseWriter)PPRResponseWriter.this)._state.enteringPPR);
                    ((PPRResponseWriter)PPRResponseWriter.this)._state.enteringPPR = null;
                }
                this._endWrapperElements(elementName);
                PPRResponseWriter.super.flush();
                PPRResponseWriter.this._xml.endCDATA();
                PPRResponseWriter.this._xml.endElement(PPRResponseWriter._ELEMENT_CHANGES_UPDATE);
                PPRResponseWriter.this._xml.flush();
                pprContext.popRenderedPartialTarget();
                _LOG.finer("Leaving partial target id {0}", (Object)this._id);
            }
        }

        private void _startWrapperElements(String elementName) throws IOException {
            boolean isTR = "tr".equalsIgnoreCase(elementName);
            boolean isTD = "td".equalsIgnoreCase(elementName);
            if (isTR || isTD) {
                PPRResponseWriter.super.startElement("table", null);
                if (isTD) {
                    PPRResponseWriter.super.startElement("tr", null);
                }
            }
        }

        private void _endWrapperElements(String elementName) throws IOException {
            boolean isTR = "tr".equalsIgnoreCase(elementName);
            boolean isTD = "td".equalsIgnoreCase(elementName);
            if (isTR || isTD) {
                if (isTD) {
                    PPRResponseWriter.super.endElement("tr");
                }
                PPRResponseWriter.super.endElement("table");
            }
        }
    }
}

