/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.share.text;

import java.awt.Color;
import java.text.FieldPosition;
import java.text.ParsePosition;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.share.text.ColorFormat;

public class RGBColorFormat
extends ColorFormat {
    private String _pattern;
    private static final int _RED_FIELD = 0;
    private static final int _GREEN_FIELD = 1;
    private static final int _BLUE_FIELD = 2;
    private static final int _ALPHA_FIELD = 3;
    private static final int _FIELD_COUNT = 4;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(RGBColorFormat.class);
    private static final long serialVersionUID = 1L;

    public RGBColorFormat(String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException();
        }
        this._pattern = pattern;
    }

    @Override
    public Object parseObject(String text, ParsePosition pos) {
        int start;
        if (text == null) {
            return null;
        }
        int oldStart = start = pos.getIndex();
        boolean inQuote = false;
        char prevCh = '\u0000';
        int count = 0;
        int interQuoteCount = 1;
        int[] rgba = new int[4];
        rgba[3] = 255;
        for (int i = 0; i < this._pattern.length(); ++i) {
            int startOffset;
            char ch = this._pattern.charAt(i);
            if (inQuote) {
                if (ch == '\'') {
                    inQuote = false;
                    if (count == 0) {
                        if (start >= text.length() || ch != text.charAt(start)) {
                            pos.setIndex(oldStart);
                            pos.setErrorIndex(start);
                            return null;
                        }
                        ++start;
                    }
                    count = 0;
                    interQuoteCount = 0;
                    continue;
                }
                if (start >= text.length() || ch != text.charAt(start)) {
                    pos.setIndex(oldStart);
                    pos.setErrorIndex(start);
                    return null;
                }
                ++count;
                ++start;
                continue;
            }
            if (ch == '\'') {
                inQuote = true;
                if (count > 0) {
                    startOffset = start;
                    if ((start = this._subParse(rgba, text, start, prevCh, count)) < 0) {
                        pos.setIndex(oldStart);
                        pos.setErrorIndex(startOffset);
                        return null;
                    }
                    count = 0;
                }
                if (interQuoteCount == 0) {
                    startOffset = start;
                    if (start >= text.length() || ch != text.charAt(start)) {
                        pos.setIndex(oldStart);
                        pos.setErrorIndex(startOffset);
                        return null;
                    }
                    ++start;
                    count = 1;
                }
            } else if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z') {
                if (ch != prevCh && count > 0) {
                    startOffset = start;
                    if ((start = this._subParse(rgba, text, start, prevCh, count)) < 0) {
                        pos.setIndex(oldStart);
                        pos.setErrorIndex(startOffset);
                        return null;
                    }
                    prevCh = ch;
                    count = 1;
                } else {
                    if (ch != prevCh) {
                        prevCh = ch;
                    }
                    ++count;
                }
            } else if (count > 0) {
                startOffset = start;
                if ((start = this._subParse(rgba, text, start, prevCh, count)) < 0) {
                    pos.setIndex(oldStart);
                    pos.setErrorIndex(startOffset);
                    return null;
                }
                if (start >= text.length() || ch != text.charAt(start)) {
                    pos.setIndex(oldStart);
                    pos.setErrorIndex(start);
                    return null;
                }
                ++start;
                count = 0;
                prevCh = '\u0000';
            } else {
                if (start >= text.length() || ch != text.charAt(start)) {
                    pos.setIndex(oldStart);
                    pos.setErrorIndex(start);
                    return null;
                }
                ++start;
            }
            ++interQuoteCount;
        }
        if (count > 0) {
            int startOffset = start;
            if ((start = this._subParse(rgba, text, start, prevCh, count)) < 0) {
                pos.setIndex(oldStart);
                pos.setErrorIndex(startOffset);
                return null;
            }
        }
        pos.setIndex(start);
        return new Color(rgba[0], rgba[1], rgba[2], rgba[3]);
    }

    @Override
    public StringBuffer format(Color color, StringBuffer toAppendTo, FieldPosition pos) {
        pos.setBeginIndex(0);
        pos.setEndIndex(0);
        if (color == null) {
            return toAppendTo;
        }
        boolean inQuote = false;
        char prevCh = '\u0000';
        int count = 0;
        for (int i = 0; i < this._pattern.length(); ++i) {
            char ch = this._pattern.charAt(i);
            if (ch != prevCh && count > 0) {
                toAppendTo = this._subFormat(color, prevCh, count, toAppendTo);
                count = 0;
            }
            if (ch == '\'') {
                if (i + 1 < this._pattern.length() && this._pattern.charAt(i + 1) == '\'') {
                    toAppendTo.append('\'');
                    ++i;
                    continue;
                }
                inQuote = !inQuote;
                continue;
            }
            if (!inQuote && (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z')) {
                prevCh = ch;
                ++count;
                continue;
            }
            toAppendTo.append(ch);
        }
        if (count > 0) {
            toAppendTo = this._subFormat(color, prevCh, count, toAppendTo);
        }
        return toAppendTo;
    }

    public int length() {
        int size = 0;
        boolean inQuote = false;
        char prevCh = '\u0000';
        int count = 0;
        for (int i = 0; i < this._pattern.length(); ++i) {
            char ch = this._pattern.charAt(i);
            if (ch != prevCh && count > 0) {
                size += this._subLength(prevCh);
                count = 0;
            }
            if (ch == '\'') {
                if (i + 1 < this._pattern.length() && this._pattern.charAt(i + 1) == '\'') {
                    ++size;
                    ++i;
                    continue;
                }
                inQuote = !inQuote;
                continue;
            }
            if (!inQuote && (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z')) {
                prevCh = ch;
                ++count;
                continue;
            }
            ++size;
        }
        if (count > 0) {
            size += this._subLength(prevCh);
        }
        return size;
    }

    private int _subLength(char ch) {
        switch (ch) {
            case 'a': 
            case 'b': 
            case 'g': 
            case 'r': {
                return 3;
            }
            case 'A': 
            case 'B': 
            case 'G': 
            case 'R': {
                return 2;
            }
        }
        throw new IllegalArgumentException(_LOG.getMessage("ILLEGAL_PATTERN_CHARACTER", (Object)Character.valueOf(ch)));
    }

    private int _subParse(int[] rgba, String text, int start, char ch, int count) {
        switch (ch) {
            case 'r': {
                return this._subParseDecimal(rgba, 0, text, start, count);
            }
            case 'g': {
                return this._subParseDecimal(rgba, 1, text, start, count);
            }
            case 'b': {
                return this._subParseDecimal(rgba, 2, text, start, count);
            }
            case 'a': {
                return this._subParseDecimal(rgba, 3, text, start, count);
            }
            case 'R': {
                return this._subParseHex(rgba, 0, text, start, count);
            }
            case 'G': {
                return this._subParseHex(rgba, 1, text, start, count);
            }
            case 'B': {
                return this._subParseHex(rgba, 2, text, start, count);
            }
            case 'A': {
                return this._subParseHex(rgba, 3, text, start, count);
            }
        }
        throw new IllegalArgumentException(_LOG.getMessage(">ILLEGAL_PATTERN_CHARACTER", (Object)Character.valueOf(ch)));
    }

    private int _subParseDecimal(int[] rgba, int field, String text, int start, int count) {
        return this._subParseBase(rgba, field, text, start, count, 3, 10);
    }

    private int _subParseHex(int[] rgba, int field, String text, int start, int count) {
        return this._subParseBase(rgba, field, text, start, count, 2, 16);
    }

    private int _subParseBase(int[] rgba, int field, String text, int start, int minDigits, int maxDigits, int base) {
        int index;
        int atLeast = start + minDigits;
        int length = text.length();
        if (atLeast > length) {
            return -start;
        }
        int end = Math.min(length, start + maxDigits);
        int value = 0;
        for (index = start; index < end; ++index) {
            int digit = Character.digit(text.charAt(index), base);
            if (digit == -1) {
                if (index >= atLeast) break;
                return -start;
            }
            value *= base;
            value += digit;
        }
        rgba[field] = value;
        return index;
    }

    private StringBuffer _subFormat(Color color, char ch, int count, StringBuffer toAppendTo) throws IllegalArgumentException {
        switch (ch) {
            case 'r': {
                return this._subFormatDecimal(color.getRed(), count, toAppendTo);
            }
            case 'g': {
                return this._subFormatDecimal(color.getGreen(), count, toAppendTo);
            }
            case 'b': {
                return this._subFormatDecimal(color.getBlue(), count, toAppendTo);
            }
            case 'a': {
                return this._subFormatDecimal(color.getAlpha(), count, toAppendTo);
            }
            case 'R': {
                return this._subFormatHex(color.getRed(), count, toAppendTo);
            }
            case 'G': {
                return this._subFormatHex(color.getGreen(), count, toAppendTo);
            }
            case 'B': {
                return this._subFormatHex(color.getBlue(), count, toAppendTo);
            }
            case 'A': {
                return this._subFormatHex(color.getAlpha(), count, toAppendTo);
            }
        }
        throw new IllegalArgumentException(_LOG.getMessage(">ILLEGAL_PATTERN_CHARACTER", (Object)Character.valueOf(ch)));
    }

    private StringBuffer _subFormatDecimal(int value, int minDigits, StringBuffer toAppendTo) {
        this._prefixZeros(value, 10, minDigits, toAppendTo);
        toAppendTo.append(value);
        return toAppendTo;
    }

    private StringBuffer _subFormatHex(int value, int minDigits, StringBuffer toAppendTo) {
        this._prefixZeros(value, 16, minDigits, toAppendTo);
        toAppendTo.append(Integer.toHexString(value).toUpperCase());
        return toAppendTo;
    }

    private StringBuffer _prefixZeros(int value, int base, int minDigits, StringBuffer toAppendTo) {
        if (value >= 0) {
            int digits;
            int n = digits = value > 0 ? (int)Math.ceil(Math.log(value) / Math.log(base)) : 1;
            while (minDigits > 0 && digits < minDigits) {
                toAppendTo.append('0');
                --minDigits;
            }
        }
        return toAppendTo;
    }
}

