/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.skin;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.skin.Skin;
import org.apache.myfaces.trinidad.skin.SkinFactory;
import org.apache.myfaces.trinidad.skin.SkinVersion;
import org.apache.myfaces.trinidadinternal.skin.RequestSkinWrapper;

public class SkinFactoryImpl
extends SkinFactory {
    private Map<String, Skin> _skins = new LinkedHashMap<String, Skin>();
    private static final String _SIMPLE_PDA = "simple.pda";
    private static final String _SIMPLE_DESKTOP = "simple.desktop";
    private static final String _SIMPLE_PORTLET = "simple.portlet";
    private static final String _DEFAULT = "default";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(SkinFactoryImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSkin(String skinId, Skin skin) {
        if (skinId == null || skin == null) {
            _LOG.warning("CANNOT_ADD_SKIN");
            return;
        }
        Map<String, Skin> map = this._skins;
        synchronized (map) {
            Skin previousValue = this._skins.put(skinId, skin);
            if (previousValue != null) {
                _LOG.warning("DUPLICATE_ADD_SKIN_TO_SKIN_FACTORY", (Object)skinId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Skin getSkin(FacesContext context, String skinId) {
        if (skinId == null) {
            _LOG.warning("CANNOT_GET_SKIN_WITH_NULL_SKINID");
            return null;
        }
        Skin skin = null;
        Map<String, Skin> map = this._skins;
        synchronized (map) {
            if (this._skins.containsKey(skinId)) {
                skin = this._skins.get(skinId);
            }
        }
        return skin;
    }

    public Skin getSkin(FacesContext context, String family, String renderKitId) {
        return this.getSkin(context, family, renderKitId, null);
    }

    public Skin getSkin(FacesContext context, String family, String renderKitId, String version) {
        if (version == null) {
            version = "";
        }
        if (family == null) {
            throw new NullPointerException("Null skin family");
        }
        if (renderKitId == null) {
            renderKitId = "org.apache.myfaces.trinidad.desktop";
        }
        Skin matchingSkin = null;
        ArrayList<Skin> matchingSkinList = new ArrayList<Skin>();
        for (Skin skin : this._skins.values()) {
            if (!family.equalsIgnoreCase(skin.getFamily()) || !renderKitId.equalsIgnoreCase(skin.getRenderKitId())) continue;
            matchingSkinList.add(skin);
        }
        if (matchingSkinList.isEmpty()) {
            if (_LOG.isWarning()) {
                _LOG.warning("CANNOT_FIND_MATCHING_SKIN", new Object[]{family, renderKitId});
            }
            matchingSkin = renderKitId.equals("portlet") ? this.getSkin(context, _SIMPLE_PORTLET) : (renderKitId.equals("org.apache.myfaces.trinidad.pda") ? this.getSkin(context, _SIMPLE_PDA) : this.getSkin(context, _SIMPLE_DESKTOP));
        } else {
            boolean versionIsDefault;
            boolean foundMatchingSkin = false;
            boolean bl = versionIsDefault = _DEFAULT.compareToIgnoreCase(version) == 0;
            if (!versionIsDefault) {
                for (Skin skin : matchingSkinList) {
                    String name;
                    SkinVersion skinVersion = skin.getVersion();
                    if (skinVersion == null || !version.equals(name = skinVersion.getName())) continue;
                    matchingSkin = skin;
                    break;
                }
            }
            if (matchingSkin == null || versionIsDefault) {
                matchingSkin = this._getDefaultVersionSkin(matchingSkinList);
                if (matchingSkin == null) {
                    matchingSkin = (Skin)matchingSkinList.get(matchingSkinList.size() - 1);
                } else if (matchingSkin != null && versionIsDefault) {
                    foundMatchingSkin = true;
                }
            } else {
                foundMatchingSkin = true;
            }
            if (foundMatchingSkin) {
                if (_LOG.isFine()) {
                    _LOG.fine("GET_SKIN_FOUND_SKIN_VERSION", new Object[]{family, version, matchingSkin.getId()});
                }
            } else if (_LOG.isWarning()) {
                if ("".equals(version)) {
                    _LOG.warning("GET_SKIN_CANNOT_FIND_NO_VERSION", new Object[]{family, matchingSkin.getId()});
                } else {
                    _LOG.warning("GET_SKIN_CANNOT_FIND_SKIN_VERSION", new Object[]{family, version, matchingSkin.getId()});
                }
            }
        }
        return matchingSkin == null ? null : new RequestSkinWrapper(matchingSkin);
    }

    private Skin _getDefaultVersionSkin(List<Skin> matchingSkinList) {
        Skin matchingSkin = null;
        for (Skin skin : matchingSkinList) {
            SkinVersion skinVersion = skin.getVersion();
            if (skinVersion == null || !skinVersion.isDefault()) continue;
            matchingSkin = skin;
            break;
        }
        return matchingSkin;
    }

    public Iterator<String> getSkinIds() {
        return this._skins.keySet().iterator();
    }
}

