/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.component;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.component.UIXEditableValue;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;

public class UIXSelectMany
extends UIXEditableValue {
    public static final FacesBean.Type TYPE = new FacesBean.Type(UIXEditableValue.TYPE);
    public static final String COMPONENT_FAMILY = "org.apache.myfaces.trinidad.SelectMany";
    public static final String COMPONENT_TYPE = "org.apache.myfaces.trinidad.SelectMany";
    public static final String REQUIRED_MESSAGE_ID = "org.apache.myfaces.trinidad.UIXSelectMany.REQUIRED";
    public static final String UNSUPPORTED_MODEL_TYPE_MESSAGE_ID = "org.apache.myfaces.trinidad.UIXSelectMany.UNSUPPORTED_MODEL_TYPE";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(UIXSelectMany.class);

    public UIXSelectMany() {
        super("org.apache.myfaces.trinidad.Listbox");
    }

    @Override
    protected void validateValue(FacesContext context, Object newValue) {
        super.validateValue(context, newValue);
    }

    @Override
    protected boolean isEmpty(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof Collection) {
            return ((Collection)value).isEmpty();
        }
        if (value.getClass().isArray()) {
            return Array.getLength(value) == 0;
        }
        return false;
    }

    @Override
    protected String getRequiredMessageKey() {
        return REQUIRED_MESSAGE_ID;
    }

    @Override
    protected boolean compareValues(Object previous, Object value) {
        int newSize;
        int prevSize = UIXSelectMany.__getSize(previous);
        if (prevSize != (newSize = UIXSelectMany.__getSize(value))) {
            return true;
        }
        if (prevSize == 0) {
            return false;
        }
        List<Object> prevList = UIXSelectMany.__toList(previous);
        List<Object> newList = UIXSelectMany.__toList(value);
        return UIXSelectMany._destructiveCompareOutOfOrderLists(prevList, newList);
    }

    static int __getSize(Object o) {
        if (o == null) {
            return 0;
        }
        if (o instanceof Collection) {
            return ((Collection)o).size();
        }
        if (o.getClass().isArray()) {
            return Array.getLength(o);
        }
        if (_LOG.isFine()) {
            _LOG.fine("Type " + o.getClass() + " is not a supported List model type");
        }
        return 0;
    }

    private static boolean _destructiveCompareOutOfOrderLists(List<Object> one, List<Object> two) {
        int size = one.size();
        assert (one.size() == two.size());
        for (int i = 0; i < size; ++i) {
            Object o = one.get(i);
            int indexOf = two.indexOf(o);
            if (indexOf < 0) {
                return true;
            }
            two.remove(indexOf);
        }
        return false;
    }

    static List<Object> __toList(Object o) {
        if (o == null) {
            return null;
        }
        ArrayList<Object> listCopy = new ArrayList<Object>();
        if (o instanceof Collection) {
            listCopy.addAll((Collection)o);
        } else if (o.getClass().isArray()) {
            int length = Array.getLength(o);
            listCopy.ensureCapacity(length);
            for (int i = 0; i < length; ++i) {
                listCopy.add(Array.get(o, i));
            }
        }
        return listCopy;
    }

    @Override
    public String getFamily() {
        return "org.apache.myfaces.trinidad.SelectMany";
    }

    @Override
    protected FacesBean.Type getBeanType() {
        return TYPE;
    }

    protected UIXSelectMany(String rendererType) {
        super(rendererType);
    }

    static {
        TYPE.lockAndRegister("org.apache.myfaces.trinidad.SelectMany", "org.apache.myfaces.trinidad.Listbox");
    }
}

