/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.RandomAccess;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.myfaces.trinidad.component.CompositeIterator;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;

public final class CollectionUtils {
    private static final Class<? extends List> _CHECKED_LIST;
    private static final Class<? extends List> _UNMODIFIABLE_LIST;
    private static final Class<? extends List> _SYNCHRONIZED_LIST;
    private static final Class<? extends Set> _EMPTY_SET;
    private static final Class<? extends Set> _SINGLETON_SET;
    private static final Queue _EMPTY_QUEUE;
    private static final Iterator _EMPTY_ITERATOR;
    private static final Iterator _EMPTY_LIST_ITERATOR;
    private static final TrinidadLogger _LOG;

    private CollectionUtils() {
    }

    public static <T> ArrayList<T> arrayList(Iterator<T> iterator) {
        ArrayList<T> arrayList = new ArrayList<T>();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    public static <T> T[] toArray(Iterator<? extends T> iterator, Class<T> type) {
        if (iterator.hasNext()) {
            ArrayList<Object> arrayList = CollectionUtils.arrayList(iterator);
            Object[] outArray = (Object[])Array.newInstance(type, arrayList.size());
            return arrayList.toArray(outArray);
        }
        return (Object[])Array.newInstance(type, 0);
    }

    public static <T> Queue<T> emptyQueue() {
        return _EMPTY_QUEUE;
    }

    public static <T> Iterator<T> emptyIterator() {
        return _EMPTY_ITERATOR;
    }

    public static <T> ListIterator<T> emptyListIterator() {
        return (ListIterator)_EMPTY_LIST_ITERATOR;
    }

    public static <T> Set<T> asSet(T ... a) {
        return CollectionUtils._asSet(a, false);
    }

    public static <T> Set<T> asUnmodifiableSet(T ... a) {
        return CollectionUtils._asSet(a, true);
    }

    public static <E extends Enum<E>> Set<E> unmodifiableCopyOfEnumSet(Set<E> s) {
        Class<?> copyClass = s.getClass();
        if (_EMPTY_SET == copyClass || _SINGLETON_SET == copyClass) {
            return s;
        }
        return Collections.unmodifiableSet(EnumSet.copyOf(s));
    }

    private static <T> Set<T> _asSet(T[] a, boolean makeImmutable) {
        Set outSet;
        int count;
        int n = count = a != null ? a.length : 0;
        if (count == 0) {
            outSet = Collections.emptySet();
        } else if (count == 1) {
            outSet = Collections.singleton(a[0]);
        } else {
            int initialSize = (int)Math.ceil((double)count / 0.75);
            outSet = new HashSet(initialSize, 0.75f);
            for (int i = 0; i < count; ++i) {
                outSet.add(a[i]);
            }
            if (makeImmutable) {
                outSet = Collections.unmodifiableSet(outSet);
            }
        }
        return outSet;
    }

    public static <T> Set<T> compositeSet(Set<T> primarySet, Set<T> secondarySet) {
        if (primarySet instanceof Serializable && secondarySet instanceof Serializable) {
            return new SerializableFixedCompositeSet<T>(primarySet, secondarySet);
        }
        return new FixedCompositeSet<T>(primarySet, secondarySet);
    }

    public static <T> Set<T> overlappingCompositeSet(Set<T> primarySet, Set<T> secondarySet) {
        if (primarySet instanceof Serializable && secondarySet instanceof Serializable) {
            return new SerializableLenientFixedCompositeSet<T>(primarySet, secondarySet);
        }
        return new LenientFixedCompositeSet<T>(primarySet, secondarySet);
    }

    public static <T> Collection<T> getSerializableCollection(Collection<T> c) {
        if (c instanceof Serializable) {
            return c;
        }
        return new SerializableCollection<T>(c);
    }

    public static <T> List<T> newSerializableList(List<T> l) {
        if (l instanceof RandomAccess) {
            return new SerializableRandomAccessList<T>(l);
        }
        return new SerializableList<T>(l);
    }

    public static <T> List<T> getSerializableList(List<T> l) {
        if (l instanceof Serializable && !_CHECKED_LIST.isInstance(l) && !_UNMODIFIABLE_LIST.isInstance(l) && !_SYNCHRONIZED_LIST.isInstance(l)) {
            return l;
        }
        return CollectionUtils.newSerializableList(l);
    }

    public static <K, V> Map<K, V> newMutationHookedMap(Map<K, V> map, MapMutationHooks<K, V> hooks) {
        if (map == null) {
            throw new NullPointerException();
        }
        if (hooks == null) {
            throw new NullPointerException();
        }
        if (map instanceof Serializable) {
            return new SerializableExternalAccessHookMap(map, hooks);
        }
        return new ExternalAccessHookMap<K, V>(map, hooks);
    }

    public static <K, V> Map<K, V> getCheckedSerializationMap(Map<K, V> map) {
        return CollectionUtils.getCheckedSerializationMap(map, true);
    }

    public static <K, V> Map<K, V> getCheckedSerializationMap(Map<K, V> map, boolean requireSerializable) {
        if (map instanceof CheckedSerializationMap) {
            return map;
        }
        return new CheckedSerializationMap<K, V>(map, requireSerializable);
    }

    public static <E> int getUnionSize(Collection<? extends E> firstCollection, Collection<? extends E> secondCollection) {
        int size;
        Collection<E> iteratingCollection;
        Collection<E> baseCollection;
        int secondSize;
        int firstSize = firstCollection != null ? firstCollection.size() : 0;
        int n = secondSize = secondCollection != null ? secondCollection.size() : 0;
        if (firstSize == 0) {
            return secondSize;
        }
        if (secondSize == 0) {
            return firstSize;
        }
        if (firstSize >= secondSize) {
            baseCollection = firstCollection;
            iteratingCollection = secondCollection;
            size = firstSize;
        } else {
            baseCollection = secondCollection;
            iteratingCollection = firstCollection;
            size = secondSize;
        }
        for (E currValue : iteratingCollection) {
            if (baseCollection.contains(currValue)) continue;
            ++size;
        }
        return size;
    }

    protected static <T> T[] copyOf(T[] original, int newLength) {
        return CollectionUtils.copyOf(original, newLength, original.getClass());
    }

    protected static <T, U> T[] copyOf(U[] original, int newLength, Class<? extends T[]> newType) {
        Object[] copy = newType == Object[].class ? new Object[newLength] : (Object[])Array.newInstance(newType.getComponentType(), newLength);
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    static {
        _EMPTY_SET = Collections.emptySet().getClass();
        _SINGLETON_SET = Collections.singleton(null).getClass();
        _EMPTY_QUEUE = new EmptyQueue();
        _EMPTY_ITERATOR = new EmptyIterator();
        _EMPTY_LIST_ITERATOR = new EmptyListIterator();
        LinkedList dummyList = new LinkedList();
        _CHECKED_LIST = Collections.checkedList(dummyList, Object.class).getClass();
        _UNMODIFIABLE_LIST = Collections.unmodifiableList(dummyList).getClass();
        _SYNCHRONIZED_LIST = Collections.synchronizedList(dummyList).getClass();
        _LOG = TrinidadLogger.createTrinidadLogger(CollectionUtils.class);
    }

    private static final class EmptyQueue
    extends AbstractQueue
    implements Serializable {
        private static final long serialVersionUID = 0L;

        private EmptyQueue() {
        }

        @Override
        public Iterator iterator() {
            return _EMPTY_ITERATOR;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean contains(Object o) {
            return false;
        }

        @Override
        public boolean offer(Object e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object poll() {
            return null;
        }

        @Override
        public Object peek() {
            return null;
        }

        private Object readResolve() {
            return _EMPTY_QUEUE;
        }
    }

    private static final class EmptyListIterator
    extends EmptyIterator
    implements ListIterator {
        private EmptyListIterator() {
        }

        @Override
        public boolean hasPrevious() {
            return false;
        }

        public Object previous() {
            throw new NoSuchElementException();
        }

        @Override
        public int nextIndex() {
            return 0;
        }

        @Override
        public int previousIndex() {
            return -1;
        }

        public void set(Object e) {
            throw new UnsupportedOperationException();
        }

        public void add(Object e) {
            throw new UnsupportedOperationException();
        }
    }

    private static class EmptyIterator
    implements Iterator {
        private EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class CheckedSerializationMap<K, V>
    extends AccessHookMap<K, V>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Map<K, V> _delegate;
        private final boolean _requireSerializable;

        public CheckedSerializationMap(Map<K, V> delegate, boolean requireSerializable) {
            if (delegate == null) {
                throw new NullPointerException();
            }
            this._delegate = delegate;
            this._requireSerializable = requireSerializable;
        }

        @Override
        protected Map<K, V> getDelegate() {
            return this._delegate;
        }

        @Override
        protected void writeNotify(K key, V value) {
            if (!(key instanceof String)) {
                if (key instanceof Serializable) {
                    try {
                        new ObjectOutputStream(new ByteArrayOutputStream()).writeObject(key);
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException(_LOG.getMessage("FAILED_SERIALIZATION_PROPERTY_KEY", new Object[]{key, this}), e);
                    }
                } else if (this._requireSerializable) {
                    throw new ClassCastException(_LOG.getMessage("UNSERIALIZABLE_PROPERTY_KEY", new Object[]{key, this}));
                }
            }
            if (value instanceof Serializable) {
                try {
                    new ObjectOutputStream(new ByteArrayOutputStream()).writeObject(value);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(_LOG.getMessage("FAILED_SERIALIZATION_PROPERTY_VALUE", new Object[]{value, key, this}), e);
                }
            } else if (value != null && this._requireSerializable) {
                throw new ClassCastException(_LOG.getMessage("UNSERIALIZABLE_PROPERTY_VALUE", new Object[]{value, key, this}));
            }
        }

        @Override
        protected void removeNotify(Object key) {
        }

        @Override
        protected void clearNotify() {
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> m) {
            Object[] values;
            Object[] keys = m.keySet().toArray();
            int keyCount = keys.length;
            if (keyCount != (values = m.values().toArray()).length) {
                throw new ConcurrentModificationException();
            }
            for (int k = 0; k < keyCount; ++k) {
                this.writeNotify(keys[k], values[k]);
            }
            Map<Object, Object> delegate = this.getDelegate();
            for (int k = 0; k < keyCount; ++k) {
                delegate.put(keys[k], values[k]);
            }
        }
    }

    private static final class SerializableExternalAccessHookMap<K, V>
    extends ExternalAccessHookMap<K, V>
    implements Serializable {
        private static final long serialVersionUID = 1L;

        private SerializableExternalAccessHookMap(Map<K, V> delegate, MapMutationHooks<K, V> mutationHooks) {
            super(delegate, mutationHooks);
            if (!(delegate instanceof Serializable)) {
                throw new IllegalArgumentException("Delegate must be Serializable");
            }
            if (!(mutationHooks instanceof Serializable)) {
                throw new IllegalArgumentException("mutation hooka must be Serializable");
            }
        }
    }

    protected static class ExternalAccessHookMap<K, V>
    extends AccessHookMap<K, V> {
        private static final long serialVersionUID = 1L;
        private final Map<K, V> _delegate;
        private final MapMutationHooks<K, V> _mutationHooks;

        protected ExternalAccessHookMap(Map<K, V> delegate, MapMutationHooks<K, V> mutationHooks) {
            if (delegate == null) {
                throw new NullPointerException("delegate is null");
            }
            if (mutationHooks == null) {
                throw new NullPointerException("accessHooks is null");
            }
            this._delegate = delegate;
            this._mutationHooks = mutationHooks;
        }

        @Override
        protected final Map<K, V> getDelegate() {
            return this._delegate;
        }

        @Override
        protected final void writeNotify(K key, V value) {
            this._mutationHooks.writeNotify(this, key, value);
        }

        @Override
        protected final void removeNotify(Object key) {
            this._mutationHooks.removeNotify(this, key);
        }

        @Override
        protected final void clearNotify() {
            this._mutationHooks.clearNotify(this);
        }
    }

    protected static abstract class AccessHookMap<K, V>
    extends DelegatingMap<K, V> {
        protected AccessHookMap() {
        }

        protected abstract void writeNotify(K var1, V var2);

        protected abstract void removeNotify(Object var1);

        protected abstract void clearNotify();

        @Override
        public V put(K key, V value) {
            this.writeNotify(key, value);
            return super.put(key, value);
        }

        @Override
        public V remove(Object key) {
            this.removeNotify(key);
            return super.remove(key);
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> m) {
            for (Map.Entry<K, V> entry : m.entrySet()) {
                K key = entry.getKey();
                V value = entry.getValue();
                this.writeNotify(key, value);
                super.put(key, value);
            }
        }

        @Override
        public void clear() {
            this.clearNotify();
            super.clear();
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new MutationHookedEntrySet(this);
        }

        private static class MutationHookedEntrySet<K, V>
        extends DelegatingCollection<Map.Entry<K, V>>
        implements Set<Map.Entry<K, V>> {
            private final AccessHookMap<K, V> _accessHookMap;
            private final Set<Map.Entry<K, V>> _delegate;

            private MutationHookedEntrySet(AccessHookMap<K, V> accessHookMap) {
                if (accessHookMap == null) {
                    throw new NullPointerException();
                }
                this._accessHookMap = accessHookMap;
                this._delegate = accessHookMap.getDelegate().entrySet();
            }

            @Override
            protected Set<Map.Entry<K, V>> getDelegate() {
                return this._delegate;
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new MutationHookedEntrySetIterator(super.iterator(), this._accessHookMap);
            }

            @Override
            public Object[] toArray() {
                Object[] delegateEntries = super.toArray();
                int entryCount = delegateEntries.length;
                Object[] entries = delegateEntries.getClass().getComponentType().isAssignableFrom(Map.Entry.class) ? delegateEntries : new Map.Entry[entryCount];
                for (int i = 0; i < entryCount; ++i) {
                    entries[i] = new MutationHookedEntry((Map.Entry)delegateEntries[i], this._accessHookMap);
                }
                return entries;
            }

            @Override
            public <T> T[] toArray(T[] a) {
                int inputSize = a.length;
                T[] outTypeArray = inputSize == 0 ? a : CollectionUtils.copyOf(a, 0);
                T[] delegateEntries = super.toArray(outTypeArray);
                int entryCount = delegateEntries.length;
                for (int i = 0; i < entryCount; ++i) {
                    delegateEntries[i] = new MutationHookedEntry((Map.Entry)delegateEntries[i], this._accessHookMap);
                }
                if (entryCount > inputSize) {
                    return delegateEntries;
                }
                System.arraycopy(delegateEntries, 0, a, 0, entryCount);
                if (inputSize > entryCount) {
                    a[entryCount] = null;
                }
                return a;
            }

            private static class MutationHookedEntry<K, V>
            extends DelegatingEntry<K, V> {
                private final Map.Entry<K, V> _delegate;
                private final AccessHookMap<K, V> _accessHookMap;

                private MutationHookedEntry(Map.Entry<K, V> delegate, AccessHookMap<K, V> accessHookMap) {
                    if (delegate == null) {
                        throw new NullPointerException();
                    }
                    this._delegate = delegate;
                    this._accessHookMap = accessHookMap;
                }

                @Override
                protected Map.Entry<K, V> getDelegate() {
                    return this._delegate;
                }

                @Override
                public V setValue(V value) {
                    this._accessHookMap.writeNotify(this.getKey(), value);
                    return super.setValue(value);
                }
            }

            private static final class MutationHookedEntrySetIterator<K, V>
            implements Iterator<Map.Entry<K, V>> {
                private static final Object _NO_KEY = new Object();
                private volatile Object _currKey = _NO_KEY;
                private final Iterator<Map.Entry<K, V>> _delegate;
                private final AccessHookMap<K, V> _accessHookMap;

                private MutationHookedEntrySetIterator(Iterator<Map.Entry<K, V>> delegate, AccessHookMap<K, V> accessHookMap) {
                    this._delegate = delegate;
                    this._accessHookMap = accessHookMap;
                }

                @Override
                public boolean hasNext() {
                    return this._delegate.hasNext();
                }

                @Override
                public Map.Entry<K, V> next() {
                    Map.Entry<K, V> nextEntry = this._delegate.next();
                    this._currKey = nextEntry.getKey();
                    return new MutationHookedEntry(nextEntry, this._accessHookMap);
                }

                @Override
                public void remove() {
                    if (this._currKey == _NO_KEY) {
                        throw new IllegalStateException();
                    }
                    this._accessHookMap.removeNotify(this._currKey);
                    this._delegate.remove();
                    this._currKey = _NO_KEY;
                }
            }
        }
    }

    protected static abstract class DelegatingEntry<K, V>
    implements Map.Entry<K, V> {
        protected DelegatingEntry() {
        }

        protected abstract Map.Entry<K, V> getDelegate();

        @Override
        public K getKey() {
            return this.getDelegate().getKey();
        }

        @Override
        public V getValue() {
            return this.getDelegate().getValue();
        }

        @Override
        public V setValue(V value) {
            return this.getDelegate().setValue(value);
        }

        @Override
        public boolean equals(Object o) {
            return ((Object)this.getDelegate()).equals(o);
        }

        @Override
        public int hashCode() {
            return ((Object)this.getDelegate()).hashCode();
        }
    }

    protected static abstract class DelegatingMap<K, V>
    implements Map<K, V> {
        protected DelegatingMap() {
        }

        protected abstract Map<K, V> getDelegate();

        @Override
        public int size() {
            return this.getDelegate().size();
        }

        @Override
        public boolean isEmpty() {
            return this.getDelegate().isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.getDelegate().containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.getDelegate().containsValue(value);
        }

        @Override
        public V get(Object key) {
            return this.getDelegate().get(key);
        }

        @Override
        public V put(K key, V value) {
            return this.getDelegate().put(key, value);
        }

        @Override
        public V remove(Object key) {
            return this.getDelegate().remove(key);
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> m) {
            this.getDelegate().putAll(m);
        }

        @Override
        public void clear() {
            this.getDelegate().clear();
        }

        @Override
        public Set<K> keySet() {
            return this.getDelegate().keySet();
        }

        @Override
        public Collection<V> values() {
            return this.getDelegate().values();
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return this.getDelegate().entrySet();
        }

        @Override
        public boolean equals(Object o) {
            return ((Object)this.getDelegate()).equals(o);
        }

        @Override
        public int hashCode() {
            return ((Object)this.getDelegate()).hashCode();
        }
    }

    private static class SerializableRandomAccessList<E>
    extends SerializableList<E>
    implements RandomAccess {
        private static final long serialVersionUID = 0L;

        SerializableRandomAccessList(List<E> delegate) {
            super(delegate);
        }
    }

    private static class SerializableList<E>
    extends SerializableCollection<E>
    implements List<E> {
        private static final long serialVersionUID = 0L;
        private final transient List<E> _delegate;

        SerializableList(List<E> delegate) {
            super(delegate);
            this._delegate = delegate;
        }

        @Override
        public void add(int index, E element) {
            this._delegate.add(index, element);
        }

        @Override
        public E remove(int index) {
            return this._delegate.remove(index);
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            return this._delegate.addAll(index, c);
        }

        @Override
        public E get(int index) {
            return this._delegate.get(index);
        }

        @Override
        public E set(int index, E element) {
            return this._delegate.set(index, element);
        }

        @Override
        public int indexOf(Object o) {
            return this._delegate.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this._delegate.lastIndexOf(o);
        }

        @Override
        public ListIterator<E> listIterator() {
            return this._delegate.listIterator();
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            return this._delegate.listIterator(index);
        }

        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            return CollectionUtils.getSerializableList(this._delegate.subList(fromIndex, toIndex));
        }
    }

    private static class SerializableCollection<E>
    extends DelegatingCollection<E>
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private final transient Collection<E> _delegate;

        SerializableCollection(Collection<E> delegate) {
            if (delegate == null) {
                throw new NullPointerException();
            }
            this._delegate = delegate;
        }

        @Override
        protected Collection<E> getDelegate() {
            return this._delegate;
        }

        protected Object writeReplace() throws ObjectStreamException {
            return new ArrayList<E>(this._delegate);
        }
    }

    private static final class SerializableLenientFixedCompositeSet<E>
    extends LenientFixedCompositeSet<E>
    implements Serializable {
        private static final long serialVersionUID = 0L;

        SerializableLenientFixedCompositeSet(Set<E> primarySet, Set<E> secondarySet) {
            super(primarySet, secondarySet);
        }
    }

    private static class LenientFixedCompositeSet<E>
    extends LenientCompositeSet<E> {
        private final Set<E> _primarySet;
        private final Set<E> _secondarySet;

        LenientFixedCompositeSet(Set<E> primarySet, Set<E> secondarySet) {
            if (primarySet == null) {
                throw new NullPointerException();
            }
            if (secondarySet == null) {
                throw new NullPointerException();
            }
            this._primarySet = primarySet;
            this._secondarySet = secondarySet;
        }

        @Override
        protected Set<E> getPrimaryDelegate() {
            return this._primarySet;
        }

        @Override
        protected Set<E> getSecondaryDelegate() {
            return this._secondarySet;
        }
    }

    protected static abstract class LenientCompositeSet<E>
    extends CompositeSet<E> {
        protected LenientCompositeSet() {
        }

        @Override
        public int size() {
            return CollectionUtils.getUnionSize(this.getPrimaryDelegate(), this.getSecondaryDelegate());
        }

        @Override
        public Iterator<E> iterator() {
            Collection primaryDelegate = this.getPrimaryDelegate();
            Collection secondaryDelegate = this.getSecondaryDelegate();
            if (primaryDelegate.size() >= secondaryDelegate.size()) {
                return new CompositeIterator(new RemovingIterator(primaryDelegate.iterator(), secondaryDelegate), new DisjointIterator(primaryDelegate, secondaryDelegate));
            }
            return new CompositeIterator(new RemovingIterator(secondaryDelegate.iterator(), primaryDelegate), new DisjointIterator(secondaryDelegate, primaryDelegate));
        }

        @Override
        public boolean add(E e) {
            boolean modified = this.getPrimaryDelegate().add(e);
            if (modified) {
                modified = !this.getSecondaryDelegate().contains(e);
            }
            return modified;
        }

        @Override
        public boolean remove(Object o) {
            boolean removed = this.getPrimaryDelegate().remove(0);
            return removed |= this.getSecondaryDelegate().remove(0);
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            boolean changed = !this.containsAll(c);
            this.getPrimaryDelegate().addAll(c);
            return changed;
        }

        @Override
        public int hashCode() {
            DisjointIterator disjointElements;
            int hashCode;
            Collection primaryDelegate = this.getPrimaryDelegate();
            Collection secondaryDelegate = this.getSecondaryDelegate();
            if (primaryDelegate.size() >= secondaryDelegate.size()) {
                hashCode = ((Object)primaryDelegate).hashCode();
                disjointElements = new DisjointIterator(primaryDelegate, secondaryDelegate);
            } else {
                hashCode = ((Object)secondaryDelegate).hashCode();
                disjointElements = new DisjointIterator(secondaryDelegate, primaryDelegate);
            }
            while (disjointElements.hasNext()) {
                Object currElement = disjointElements.next();
                if (currElement == null) continue;
                hashCode += currElement.hashCode();
            }
            return hashCode;
        }
    }

    private static final class SerializableFixedCompositeSet<E>
    extends FixedCompositeSet<E>
    implements Serializable {
        private static final long serialVersionUID = 0L;

        SerializableFixedCompositeSet(Set<E> primarySet, Set<E> secondarySet) {
            super(primarySet, secondarySet);
        }
    }

    private static class FixedCompositeSet<E>
    extends CompositeSet<E> {
        private final Set<E> _primarySet;
        private final Set<E> _secondarySet;

        FixedCompositeSet(Set<E> primarySet, Set<E> secondarySet) {
            if (primarySet == null) {
                throw new NullPointerException();
            }
            if (secondarySet == null) {
                throw new NullPointerException();
            }
            assert (Collections.disjoint(primarySet, secondarySet)) : "Composed Sets not disjoint";
            this._primarySet = primarySet;
            this._secondarySet = secondarySet;
        }

        @Override
        protected Set<E> getPrimaryDelegate() {
            return this._primarySet;
        }

        @Override
        protected Set<E> getSecondaryDelegate() {
            return this._secondarySet;
        }
    }

    protected static abstract class CompositeSet<E>
    extends CompositeCollection<E>
    implements Set<E> {
        protected CompositeSet() {
        }

        @Override
        protected abstract Set<E> getPrimaryDelegate();

        @Override
        protected abstract Set<E> getSecondaryDelegate();

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Set)) {
                return false;
            }
            Collection other = (Collection)o;
            if (other.size() != this.size()) {
                return false;
            }
            try {
                return this.containsAll(other);
            }
            catch (NullPointerException npe) {
                return false;
            }
            catch (ClassCastException npe) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            return ((Object)this.getPrimaryDelegate()).hashCode() + ((Object)this.getSecondaryDelegate()).hashCode();
        }
    }

    private static class DisjointIterator<E>
    implements Iterator<E> {
        private final Collection<E> _checkedCollection;
        private final Iterator<E> _disjointIterator;
        private AtomicReference<E> _nextHolder;

        public DisjointIterator(Collection<E> checkedCollection, Collection<E> disjointCollection) {
            this._checkedCollection = checkedCollection;
            this._disjointIterator = disjointCollection.iterator();
        }

        @Override
        public boolean hasNext() {
            block2: {
                if (this._nextHolder == null) {
                    while (this._disjointIterator.hasNext()) {
                        E next = this._disjointIterator.next();
                        if (this._checkedCollection.contains(next)) continue;
                        this._nextHolder = new AtomicReference<E>(next);
                        break block2;
                    }
                    return false;
                }
            }
            return true;
        }

        @Override
        public E next() {
            if (this.hasNext()) {
                E value = this._nextHolder.get();
                this._nextHolder = null;
                return value;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this._nextHolder != null) {
                throw new IllegalStateException();
            }
            this._disjointIterator.remove();
        }
    }

    private static class RemovingIterator<E>
    implements Iterator<E> {
        private final Iterator<E> _baseIterator;
        private final Collection<E> _disjointCollection;
        private E _last;

        public RemovingIterator(Iterator<E> baseIterator, Collection<E> disjointCollection) {
            this._baseIterator = baseIterator;
            this._disjointCollection = disjointCollection;
        }

        @Override
        public boolean hasNext() {
            return this._baseIterator.hasNext();
        }

        @Override
        public E next() {
            this._last = this._baseIterator.next();
            return this._last;
        }

        @Override
        public void remove() {
            this._baseIterator.remove();
            this._disjointCollection.remove(this._last);
            this._last = null;
        }
    }

    protected static abstract class CompositeCollection<E>
    implements Collection<E> {
        protected CompositeCollection() {
        }

        protected abstract Collection<E> getPrimaryDelegate();

        protected abstract Collection<E> getSecondaryDelegate();

        @Override
        public int size() {
            return this.getPrimaryDelegate().size() + this.getSecondaryDelegate().size();
        }

        @Override
        public boolean isEmpty() {
            return this.getPrimaryDelegate().isEmpty() && this.getSecondaryDelegate().isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.getPrimaryDelegate().contains(o) || this.getSecondaryDelegate().contains(o);
        }

        @Override
        public Iterator<E> iterator() {
            return new CompositeIterator<E>(this.getPrimaryDelegate().iterator(), this.getSecondaryDelegate().iterator());
        }

        @Override
        public Object[] toArray() {
            int size = this.size();
            Object[] out = new Object[size];
            int i = 0;
            for (E currObject : this) {
                out[i] = currObject;
                if (++i != size) continue;
                break;
            }
            return out;
        }

        @Override
        public <T> T[] toArray(T[] outArray) {
            int arraySize;
            int collectionSize = this.size();
            if (collectionSize > (arraySize = outArray.length)) {
                outArray = (Object[])Array.newInstance(outArray.getClass().getComponentType(), collectionSize);
            }
            Iterator<E> iterator = this.iterator();
            for (int i = 0; i < collectionSize && iterator.hasNext(); ++i) {
                outArray[i] = iterator.next();
            }
            return outArray;
        }

        @Override
        public boolean add(E e) {
            boolean modified = this.getPrimaryDelegate().add(e);
            if (modified) {
                modified = !this.getSecondaryDelegate().remove(e);
            }
            return modified;
        }

        @Override
        public boolean remove(Object o) {
            boolean removed = this.getPrimaryDelegate().remove(0);
            if (!removed) {
                removed = this.getSecondaryDelegate().remove(0);
            }
            return removed;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            HashSet<E> intersection = new HashSet<E>(this.getPrimaryDelegate());
            intersection.retainAll(c);
            if (intersection.size() == c.size()) {
                return true;
            }
            HashSet<E> remainder = new HashSet<E>(c);
            remainder.removeAll(intersection);
            return this.getSecondaryDelegate().containsAll(remainder);
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            boolean changed = !this.containsAll(c);
            this.getSecondaryDelegate().removeAll(c);
            this.getPrimaryDelegate().addAll(c);
            return changed;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.getPrimaryDelegate().removeAll(c) || this.getSecondaryDelegate().removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.getPrimaryDelegate().retainAll(c) || this.getSecondaryDelegate().retainAll(c);
        }

        @Override
        public void clear() {
            this.getPrimaryDelegate().clear();
            this.getSecondaryDelegate().clear();
        }

        public String toString() {
            return super.toString() + "[primary:" + this.getPrimaryDelegate() + ", secondary:" + this.getSecondaryDelegate() + "]";
        }
    }

    protected static abstract class DelegatingCollection<E>
    implements Collection<E> {
        protected DelegatingCollection() {
        }

        protected abstract Collection<E> getDelegate();

        @Override
        public int size() {
            return this.getDelegate().size();
        }

        @Override
        public boolean isEmpty() {
            return this.getDelegate().isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.getDelegate().contains(o);
        }

        @Override
        public Iterator<E> iterator() {
            return this.getDelegate().iterator();
        }

        @Override
        public Object[] toArray() {
            return this.getDelegate().toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.getDelegate().toArray(a);
        }

        @Override
        public boolean add(E e) {
            return this.getDelegate().add(e);
        }

        @Override
        public boolean remove(Object o) {
            return this.getDelegate().remove(0);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.getDelegate().containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            return this.getDelegate().addAll(c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.getDelegate().removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.getDelegate().retainAll(c);
        }

        @Override
        public void clear() {
            this.getDelegate().clear();
        }

        @Override
        public boolean equals(Object o) {
            return o == this || ((Object)this.getDelegate()).equals(o);
        }

        @Override
        public int hashCode() {
            return ((Object)this.getDelegate()).hashCode();
        }

        public String toString() {
            return this.getDelegate().toString();
        }
    }

    public static interface MapMutationHooks<K, V> {
        public void writeNotify(Map<K, V> var1, K var2, V var3);

        public void removeNotify(Map<K, V> var1, Object var2);

        public void clearNotify(Map<K, V> var1);
    }
}

