/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.component;

import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CompositeIterator<T>
implements Iterator<T> {
    private Iterator<T> _firstIterator;
    private Iterator<T> _secondIterator;
    private Iterator<T> _removeIterator;
    private boolean _hasNext;

    public CompositeIterator(Iterator<T> firstIterator, Iterator<T> secondIterator) {
        if (firstIterator == null) {
            throw new NullPointerException();
        }
        if (secondIterator == null) {
            throw new NullPointerException();
        }
        this._hasNext = firstIterator.hasNext();
        if (this._hasNext) {
            this._firstIterator = firstIterator;
            this._secondIterator = secondIterator;
        } else {
            this._firstIterator = secondIterator;
            this._secondIterator = null;
            this._hasNext = secondIterator.hasNext();
        }
    }

    @Override
    public boolean hasNext() {
        return this._hasNext;
    }

    @Override
    public T next() {
        this._removeIterator = this._firstIterator;
        T nextValue = this._firstIterator.next();
        this._hasNext = this._firstIterator.hasNext();
        if (!this._hasNext && this._secondIterator != null) {
            this._firstIterator = this._secondIterator;
            this._secondIterator = null;
            this._hasNext = this._firstIterator.hasNext();
        }
        return nextValue;
    }

    @Override
    public void remove() {
        if (this._removeIterator == null) {
            throw new IllegalStateException();
        }
        this._removeIterator.remove();
    }
}

