/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.application;

import javax.faces.application.NavigationHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.context.RequestContext;

public class NavigationHandlerImpl
extends NavigationHandler {
    private Boolean _disabled;
    private NavigationHandler _delegate;

    public NavigationHandlerImpl(NavigationHandler delegate) {
        this._delegate = delegate;
    }

    public void handleNavigation(FacesContext context, String fromAction, String outcome) {
        RequestContext afc;
        if (this._disableNavigationHandler(context)) {
            this._delegate.handleNavigation(context, fromAction, outcome);
            return;
        }
        UIViewRoot oldRoot = context.getViewRoot();
        this._delegate.handleNavigation(context, fromAction, outcome);
        UIViewRoot newRoot = context.getViewRoot();
        if (outcome != null && newRoot != oldRoot && outcome.startsWith((afc = RequestContext.getCurrentInstance()).getDialogService().getDialogNavigationPrefix())) {
            context.setViewRoot(oldRoot);
            afc.getPageFlowScopeProvider().pushPageFlowScope(context, true);
            afc.getDialogService().queueLaunchEvent(newRoot);
        }
    }

    private synchronized boolean _disableNavigationHandler(FacesContext context) {
        if (this._disabled == null) {
            this._disabled = Boolean.FALSE;
            Object disabledAttr = context.getExternalContext().getApplicationMap().get("org.apache.myfaces.trinidad.DISABLE_DIALOG_OUTCOMES");
            if (disabledAttr != null) {
                this._disabled = "true".equalsIgnoreCase(disabledAttr.toString());
            } else {
                String disabledParam = context.getExternalContext().getInitParameter("org.apache.myfaces.trinidad.DISABLE_DIALOG_OUTCOMES");
                if (disabledParam != null) {
                    this._disabled = "true".equalsIgnoreCase(disabledParam);
                }
            }
        }
        return this._disabled;
    }
}

