/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.image;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.util.Locale;
import java.util.Map;
import org.apache.myfaces.trinidadinternal.image.AbstractImageRenderer;
import org.apache.myfaces.trinidadinternal.image.ImageConstants;
import org.apache.myfaces.trinidadinternal.image.ImageContext;
import org.apache.myfaces.trinidadinternal.image.painter.FontUtils;
import org.apache.myfaces.trinidadinternal.image.painter.PaintContext;
import org.apache.myfaces.trinidadinternal.image.painter.Painter;
import org.apache.myfaces.trinidadinternal.style.util.FontProxy;
import org.apache.myfaces.trinidadinternal.style.util.GraphicsUtils;
import org.apache.myfaces.trinidadinternal.util.nls.LocaleUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PainterImageRenderer
extends AbstractImageRenderer
implements ImageConstants {
    private static final Color _TRANSPARENT_COLOR = new Color(255, 255, 255, 0);
    private Painter _painter;
    private static final float _CENTER_ALIGN = 0.5f;

    protected PainterImageRenderer(Painter painter) {
        this._painter = painter;
    }

    public Painter getPainter() {
        return this._painter;
    }

    @Override
    public Image renderImage(ImageContext imageContext, Map<Object, Object> requestedProperties, Map<Object, Object> responseProperties) {
        if (!this.isRenderable(imageContext, requestedProperties)) {
            return null;
        }
        Painter painter = this.getPainter(imageContext, requestedProperties);
        BufferedImage measureImage = this.createImage(1, 1);
        PaintContext measureContext = this.createPaintContext(imageContext, measureImage, requestedProperties, responseProperties);
        Dimension d = painter.getPreferredSize(measureContext);
        int width = d.width;
        int height = d.height;
        measureImage.flush();
        this.disposePaintContext(measureContext);
        BufferedImage paintImage = this.createImage(width, height);
        PaintContext paintContext = this.createPaintContext(imageContext, paintImage, requestedProperties, responseProperties);
        Graphics g = paintContext.getPaintGraphics();
        Color oldColor = g.getColor();
        g.setColor(paintContext.getSurroundingColor());
        g.fillRect(0, 0, width, height);
        g.setColor(oldColor);
        painter.paint(paintContext, g, 0, 0, width, height);
        this.disposePaintContext(paintContext);
        responseProperties.put(WIDTH_RESPONSE_KEY, width);
        responseProperties.put(HEIGHT_RESPONSE_KEY, height);
        return paintImage;
    }

    protected Painter getPainter(ImageContext imageContext, Map<Object, Object> requestedProperties) {
        return this.getPainter();
    }

    protected boolean isRenderable(ImageContext imageContext, Map<Object, Object> requestedProperties) {
        return GraphicsUtils.isGraphicalEnvironment();
    }

    protected Color getPaintForeground(ImageContext context, Map<Object, Object> d) {
        return (Color)d.get(FOREGROUND_KEY);
    }

    protected Color getPaintBackground(ImageContext context, Map<Object, Object> d) {
        return (Color)d.get(BACKGROUND_KEY);
    }

    protected Font getPaintFont(Map<Object, Object> d) {
        Object o = d.get(FONT_KEY);
        if (o instanceof FontProxy) {
            return ((FontProxy)o).getFont();
        }
        return (Font)d.get(FONT_KEY);
    }

    protected Object getPaintData(Object key, Map<Object, Object> d) {
        return d.get(key);
    }

    protected PaintContext createPaintContext(ImageContext imageContext, BufferedImage image, Map<Object, Object> requestedProperties, Map<Object, Object> responseProperties) {
        return new Context(imageContext, image, requestedProperties, responseProperties);
    }

    protected void disposePaintContext(PaintContext context) {
        context.getPaintGraphics().dispose();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Context
    implements PaintContext {
        private Graphics2D _graphics;
        private ImageContext _imageContext;
        private Map<Object, Object> _requested;
        private Map<Object, Object> _response;
        private int _direction;

        public Context(ImageContext imageContext, BufferedImage image, Map<Object, Object> requestedProperties, Map<Object, Object> responseProperties) {
            this._imageContext = imageContext;
            this._requested = requestedProperties;
            this._response = responseProperties;
            this._direction = LocaleUtils.getReadingDirection(imageContext.getLocaleContext());
            Object o = null;
            o = requestedProperties.get(ImageConstants.DIRECTION_KEY);
            if (o != null) {
                this._direction = (Integer)o;
            }
            Graphics2D g = image.createGraphics();
            g.setFont(this.getPaintFont());
            g.setColor(this.getPaintForeground());
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this._graphics = g;
        }

        @Override
        public int getPaintState() {
            int state = 0;
            if (Boolean.TRUE.equals(this._requested.get(ImageConstants.DISABLED_KEY))) {
                state |= 1;
            }
            return state;
        }

        @Override
        public ImageContext getImageContext() {
            return this._imageContext;
        }

        @Override
        public Color getPaintForeground() {
            PainterImageRenderer renderer = PainterImageRenderer.this;
            Color foreground = renderer.getPaintForeground(this._imageContext, this._requested);
            return foreground == null ? Color.black : foreground;
        }

        @Override
        public Color getPaintBackground() {
            PainterImageRenderer renderer = PainterImageRenderer.this;
            Color background = renderer.getPaintBackground(this._imageContext, this._requested);
            return background == null ? Color.white : background;
        }

        @Override
        public Color getSurroundingColor() {
            Color color = (Color)this._requested.get(ImageConstants.SURROUNDING_COLOR_KEY);
            if (color != null) {
                return color;
            }
            return _TRANSPARENT_COLOR;
        }

        @Override
        public Font getPaintFont() {
            PainterImageRenderer renderer = PainterImageRenderer.this;
            Font font = renderer.getPaintFont(this._requested);
            if (font != null) {
                return font;
            }
            return FontUtils.getDefaultSansSerifFont();
        }

        @Override
        public Locale getPaintLocale() {
            Locale l = this._imageContext.getLocaleContext().getTranslationLocale();
            if (l != null) {
                return l;
            }
            return Locale.getDefault();
        }

        @Override
        public void setResponseProperty(Object key, Object value) {
            this._response.put(key, value);
        }

        @Override
        public Graphics getPaintGraphics() {
            return this._graphics;
        }

        @Override
        public Object getPaintData(Object key) {
            PainterImageRenderer renderer = PainterImageRenderer.this;
            return renderer.getPaintData(key, this._requested);
        }

        @Override
        public float getInteriorAlignmentX() {
            return 0.5f;
        }

        @Override
        public float getInteriorAlignmentY() {
            return 0.5f;
        }

        @Override
        public FontMetrics getFontMetrics(Font font) {
            return this._graphics.getFontMetrics(font);
        }

        @Override
        public ImageObserver getImageObserver() {
            return PainterImageRenderer.this;
        }

        @Override
        public int getReadingDirection() {
            return this._direction;
        }
    }
}

