/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.io;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.faces.component.UIComponent;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.io.ResponseWriterDecorator;

public class DebugResponseWriter
extends ResponseWriterDecorator {
    private boolean _inElement;
    private Stack<String> _elementStack = new Stack();
    private int _endElementCount = 0;
    private Map<Object, Boolean> _idMap = new HashMap<Object, Boolean>();
    private Set<String> _attributes = new HashSet<String>();
    private UIComponent _lastComponentStarted;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(DebugResponseWriter.class);

    public DebugResponseWriter(ResponseWriter decorated) {
        super(decorated);
    }

    public ResponseWriter cloneWithWriter(Writer writer) {
        return new DebugResponseWriter(this.getResponseWriter().cloneWithWriter(writer));
    }

    public void endDocument() throws IOException {
        super.endDocument();
        if (!this._elementStack.empty()) {
            _LOG.warning("ELEMENTS_NOT_CLOSED");
            for (int i = this._elementStack.size() - 1; i >= 0; --i) {
                _LOG.warning((String)this._elementStack.elementAt(i));
            }
        }
    }

    public void writeComment(Object text) throws IOException {
        if (text != null && text.toString().indexOf("--") >= 0) {
            _LOG.warning("Comments cannot include \"--\"");
        }
        this._inElement = false;
        super.writeComment(text);
    }

    public void writeText(Object text, String componentPropertyName) throws IOException {
        this._inElement = false;
        super.writeText(text, componentPropertyName);
    }

    public void writeText(char[] text, int start, int length) throws IOException {
        this._inElement = false;
        super.writeText(text, start, length);
    }

    public void write(String text) throws IOException {
        this._inElement = false;
        super.write(text);
    }

    public void write(char[] text, int start, int length) throws IOException {
        this._inElement = false;
        super.write(text, start, length);
    }

    public void write(int ch) throws IOException {
        this._inElement = false;
        super.write(ch);
    }

    public void startElement(String name, UIComponent component) throws IOException {
        if (component != null && this._lastComponentStarted != component) {
            String componentAsString = component.getFamily();
            String id = component.getId();
            if (id != null) {
                componentAsString = componentAsString + "[\"" + id + "\"]";
            }
            this.writeComment("Start: " + componentAsString);
            this._lastComponentStarted = component;
        }
        super.startElement(name, component);
        this._inElement = true;
        this._elementStack.push(name);
        this._attributes.clear();
    }

    public void endElement(String name) throws IOException {
        this._inElement = false;
        this._lastComponentStarted = null;
        String topElement = this._elementStack.peek();
        if (!name.equals(topElement)) {
            if (_LOG.isWarning()) {
                _LOG.warning("ENDING_WHEN_OTHER_EXPECTED", new Object[]{name, topElement, this._endElementCount});
            }
            for (int i = this._elementStack.size() - 1; i >= 0; --i) {
                if (!name.equals(this._elementStack.elementAt(i))) continue;
                this._elementStack.setSize(i);
                break;
            }
        } else {
            this._elementStack.pop();
        }
        ++this._endElementCount;
        super.endElement(name);
    }

    public void writeAttribute(String name, Object value, String componentPropertyName) throws IOException {
        if (!this._inElement) {
            _LOG.warning("ATTRIBUTE_OUTSIDE_ELEMENT");
        }
        if ("id".equals(name)) {
            if (this._elementStack.size() > 0) {
                if (this._elementStack.peek().indexOf(":") == -1) {
                    this._checkDuplicateIds(value);
                }
            } else {
                this._checkDuplicateIds(value);
            }
        }
        if (value != null) {
            name = this._checkDuplicateAttribute(name);
        }
        super.writeAttribute(name, value, componentPropertyName);
    }

    public void writeURIAttribute(String name, Object value, String componentPropertyName) throws IOException {
        if (!this._inElement) {
            _LOG.warning("ATTRIBUTE_OUTSIDE_ELEMENT");
        }
        if (value != null) {
            name = this._checkDuplicateAttribute(name);
        }
        super.writeURIAttribute(name, value, componentPropertyName);
    }

    private String _checkDuplicateAttribute(String name) {
        if (this._attributes.contains(name)) {
            _LOG.warning("DUPLICATE_ATTRIBUTE_OUTPUT", new Object[]{name, name});
            return "duplicate_" + name;
        }
        this._attributes.add(name);
        return name;
    }

    private void _checkDuplicateIds(Object value) {
        if (value != null) {
            Boolean exists = this._idMap.get(value);
            if (exists != null) {
                if (Boolean.FALSE == exists) {
                    this._logDuplicateId(value);
                    this._idMap.put(value, Boolean.TRUE);
                }
            } else {
                this._idMap.put(value, Boolean.FALSE);
            }
        }
    }

    private void _logDuplicateId(Object value) {
        if (_LOG.isWarning()) {
            String logString = "The id \"" + value + "\" is used more than once.";
            _LOG.warning(logString);
        }
    }
}

