/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.core.layout.CorePanelPageHeader;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.render.CoreRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.OutputUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.PdaPanelPageHeaderRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;

public class DesktopPanelPageHeaderRenderer
extends XhtmlRenderer {
    private PropertyKey _chromeTypeKey;
    private CoreRenderer _pdaRenderer = new PdaPanelPageHeaderRenderer();
    private static final String _NAVIGATION1_SPACER_SIZE = "10";

    public DesktopPanelPageHeaderRenderer() {
        super(CorePanelPageHeader.TYPE);
    }

    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._chromeTypeKey = type.findKey("chromeType");
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void encodeAll(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean) throws IOException {
        if (!DesktopPanelPageHeaderRenderer.isDesktop((RenderingContext)arc)) {
            this.delegateRenderer(context, arc, component, bean, this._pdaRenderer);
        } else {
            this.encodeAllDesktop(context, arc, component, bean);
        }
    }

    protected void encodeAllDesktop(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean) throws IOException {
        UIComponent branding = DesktopPanelPageHeaderRenderer.getFacet((UIComponent)component, (String)"branding");
        UIComponent brandingApp = DesktopPanelPageHeaderRenderer.getFacet((UIComponent)component, (String)"brandingApp");
        UIComponent brandingAppCont = DesktopPanelPageHeaderRenderer.getFacet((UIComponent)component, (String)"brandingAppContextual");
        UIComponent navigationGlobal = DesktopPanelPageHeaderRenderer.getFacet((UIComponent)component, (String)"navigationGlobal");
        UIComponent navigation1 = DesktopPanelPageHeaderRenderer.getFacet((UIComponent)component, (String)"navigation1");
        UIComponent navigation2 = DesktopPanelPageHeaderRenderer.getFacet((UIComponent)component, (String)"navigation2");
        UIComponent menuSwitch = DesktopPanelPageHeaderRenderer.getFacet((UIComponent)component, (String)"menuSwitch");
        UIComponent search = DesktopPanelPageHeaderRenderer.getFacet((UIComponent)component, (String)"search");
        Object chromeType = this.getChromeType(bean);
        boolean isCompact = !"expanded".equals(chromeType);
        boolean AppContextOrCompact = brandingAppCont != null || isCompact;
        boolean isRTL = arc.isRightToLeft();
        boolean hasGlobal = navigationGlobal != null;
        boolean hasSwitch = menuSwitch != null;
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("span", component);
        this.renderAllAttributes(context, arc, bean);
        this.renderId(context, component);
        writer.startElement("table", null);
        OutputUtils.renderLayoutTableAttributes(context, arc, "0", "100%");
        int rowSpan = 0;
        if (hasGlobal || hasSwitch) {
            ++rowSpan;
        }
        if (navigation1 != null) {
            ++rowSpan;
        }
        int brandingCount = 0;
        if (branding != null) {
            ++brandingCount;
        }
        if (brandingApp != null) {
            ++brandingCount;
        }
        if (brandingAppCont != null) {
            ++brandingCount;
        }
        if (rowSpan != 0 || brandingCount > 0) {
            Integer rowSpanObject = rowSpan > 1 ? Integer.valueOf(rowSpan) : null;
            writer.startElement("tr", null);
            if (brandingCount > 0) {
                writer.startElement("td", null);
                writer.writeAttribute("nowrap", (Object)Boolean.TRUE, null);
                writer.writeAttribute("rowspan", (Object)rowSpanObject, null);
                if (brandingCount > 0) {
                    writer.writeAttribute("valign", (Object)"top", null);
                    writer.startElement("table", null);
                    OutputUtils.renderLayoutTableAttributes(context, arc, "2", "1%");
                    writer.startElement("tr", null);
                    writer.startElement("td", null);
                    writer.writeAttribute("nowrap", (Object)Boolean.TRUE, null);
                    if (brandingApp != null && branding != null && AppContextOrCompact) {
                        writer.writeAttribute("width", (Object)"1%", null);
                    }
                }
                if (branding != null) {
                    this.encodeChild(context, branding);
                }
                if (brandingApp != null && branding != null && AppContextOrCompact) {
                    writer.endElement("td");
                    writer.startElement("td", null);
                    writer.writeAttribute("nowrap", (Object)Boolean.TRUE, null);
                }
                if (brandingApp != null && (brandingCount == 1 || AppContextOrCompact)) {
                    if (!AppContextOrCompact) {
                        writer.writeAttribute("valign", (Object)"bottom", null);
                    } else if (DesktopPanelPageHeaderRenderer.isIE((RenderingContext)arc)) {
                        writer.writeAttribute("width", (Object)"2%", null);
                    }
                    this.encodeChild(context, brandingApp);
                }
                if (brandingCount > 0) {
                    writer.endElement("td");
                    writer.endElement("tr");
                    writer.startElement("tr", null);
                    writer.startElement("td", null);
                    writer.writeAttribute("valign", (Object)"top", null);
                    writer.writeAttribute("nowrap", (Object)Boolean.TRUE, null);
                }
                if (brandingAppCont != null || brandingApp != null && isCompact) {
                    writer.writeAttribute("colspan", (Object)"2", null);
                    writer.writeAttribute("height", (Object)"17", null);
                    if (brandingAppCont != null) {
                        this.encodeChild(context, brandingAppCont);
                    }
                } else if (brandingApp != null && branding != null) {
                    this.encodeChild(context, brandingApp);
                }
                if (brandingCount > 0) {
                    writer.endElement("td");
                    writer.endElement("tr");
                    writer.endElement("table");
                }
                writer.endElement("td");
            }
            if (rowSpan > 0) {
                boolean startNewRow = false;
                if (hasGlobal || hasSwitch) {
                    writer.startElement("td", null);
                    writer.writeAttribute("align", (Object)(isRTL ? "left" : "right"), null);
                    writer.writeAttribute("valign", (Object)"bottom", null);
                    if (DesktopPanelPageHeaderRenderer.isIE((RenderingContext)arc)) {
                        writer.writeAttribute("style", (Object)"position:relative;z-index:10;padding-bottom:8px", null);
                    } else {
                        writer.writeAttribute("style", (Object)"padding-bottom:8px", null);
                    }
                    if (hasGlobal && hasSwitch) {
                        writer.startElement("table", null);
                        writer.startElement("tr", null);
                        writer.startElement("td", null);
                        this.encodeChild(context, navigationGlobal);
                        writer.endElement("td");
                        writer.startElement("td", null);
                        writer.writeAttribute("valign", (Object)"bottom", null);
                        this.encodeChild(context, menuSwitch);
                        writer.endElement("td");
                        writer.endElement("tr");
                        writer.endElement("table");
                    } else if (hasGlobal) {
                        this.encodeChild(context, navigationGlobal);
                    } else {
                        this.encodeChild(context, menuSwitch);
                    }
                    writer.endElement("td");
                    startNewRow = true;
                }
                if (navigation1 != null) {
                    if (startNewRow) {
                        writer.endElement("tr");
                        writer.startElement("tr", null);
                    }
                    this._renderNavigation1(context, arc, writer, navigation1, isRTL);
                }
            }
            writer.endElement("tr");
        }
        boolean hasSearch = search != null;
        int colSpan = this._calculateColSpan(brandingCount, navigation1 != null, hasGlobal || hasSwitch);
        if (navigation2 != null) {
            this._renderNavigation2(context, writer, navigation2, colSpan);
        }
        if (hasSearch) {
            this._renderSearch(context, arc, writer, search, colSpan);
        }
        writer.endElement("table");
        writer.endElement("span");
    }

    protected Object getChromeType(FacesBean bean) {
        return bean.getProperty(this._chromeTypeKey);
    }

    private void _renderNavigation1(FacesContext context, RenderingContext arc, ResponseWriter writer, UIComponent navigation1, boolean isRTL) throws IOException {
        writer.startElement("td", null);
        writer.writeAttribute("align", (Object)(isRTL ? "left" : "right"), null);
        writer.writeAttribute("valign", (Object)"bottom", null);
        this.encodeChild(context, navigation1);
        writer.endElement("td");
        writer.startElement("td", null);
        this.renderSpacer(context, arc, _NAVIGATION1_SPACER_SIZE, "1");
        writer.endElement("td");
    }

    private void _renderNavigation2(FacesContext context, ResponseWriter writer, UIComponent navigation2, int colSpan) throws IOException {
        writer.startElement("tr", null);
        writer.startElement("td", null);
        if (colSpan > 1) {
            writer.writeAttribute("colspan", (Object)colSpan, null);
        }
        writer.writeAttribute("width", (Object)"100%", null);
        this.encodeChild(context, navigation2);
        writer.endElement("td");
        writer.endElement("tr");
    }

    private void _renderSearch(FacesContext context, RenderingContext arc, ResponseWriter writer, UIComponent search, int colSpan) throws IOException {
        writer.startElement("tr", null);
        writer.startElement("td", null);
        writer.writeAttribute("width", (Object)"100%", null);
        if (colSpan > 1) {
            writer.writeAttribute("colspan", (Object)colSpan, null);
        }
        writer.startElement("table", null);
        OutputUtils.renderLayoutTableAttributes(context, arc, "0", "100%");
        writer.writeAttribute("style", (Object)"margin-bottom:3px;", null);
        writer.startElement("tr", null);
        writer.startElement("td", null);
        writer.writeAttribute("width", (Object)"4", null);
        this.renderSpacer(context, arc, "4", "1");
        writer.endElement("td");
        writer.startElement("td", null);
        writer.writeAttribute("width", (Object)"100%", null);
        writer.writeAttribute("colspan", (Object)"3", null);
        DesktopPanelPageHeaderRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)"p_OraQuickSearchBox");
        this.encodeChild(context, search);
        writer.endElement("td");
        writer.startElement("td", null);
        writer.writeAttribute("width", (Object)"4", null);
        this.renderSpacer(context, arc, "4", "1");
        writer.endElement("td");
        writer.endElement("tr");
        writer.endElement("table");
        writer.endElement("td");
        writer.endElement("tr");
    }

    private int _calculateColSpan(int brandingCount, boolean navigation1Exists, boolean navigation2Exists) {
        int colSpan = 0;
        if (brandingCount > 0) {
            ++colSpan;
        }
        if (navigation2Exists || navigation1Exists) {
            ++colSpan;
            if (navigation1Exists) {
                ++colSpan;
            }
        }
        return colSpan;
    }
}

