/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.core.layout.CorePanelPopup;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.skin.Icon;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.GoLinkRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.OutputUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlUtils;

public class PanelPopupRenderer
extends XhtmlRenderer {
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(PanelPopupRenderer.class);
    private PropertyKey _textKey;
    private PropertyKey _titleKey;
    private PropertyKey _triggerTypeKey;
    private PropertyKey _positionKey;
    private PropertyKey _modalKey;
    private PropertyKey _contentStyleKey;
    private PropertyKey _widthKey;
    private PropertyKey _heightKey;
    private PropertyKey _horzOffsetKey;
    private PropertyKey _vertOffsetKey;
    private XhtmlRenderer _triggerRenderer;
    private PropertyKey _iconKey;
    private static final String _POPUP_CONTAINER_ID_SUFFIX = "_popupContainer";
    private static final String _POPUP_TRIGGER_ID_SUFFIX = "_popupTrigger";
    private static final String _POPUP_CONTAINER_DIV_STYLES = "position:absolute; top:0px; left:0px; visibility:hidden;";

    public PanelPopupRenderer() {
        this(CorePanelPopup.TYPE);
    }

    protected PanelPopupRenderer(FacesBean.Type type) {
        super(type);
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._textKey = type.findKey("text");
        this._iconKey = type.findKey("icon");
        this._titleKey = type.findKey("title");
        this._triggerTypeKey = type.findKey("triggerType");
        this._positionKey = type.findKey("position");
        this._modalKey = type.findKey("modal");
        this._contentStyleKey = type.findKey("contentStyle");
        this._widthKey = type.findKey("width");
        this._heightKey = type.findKey("height");
        this._horzOffsetKey = type.findKey("xoffset");
        this._vertOffsetKey = type.findKey("yoffset");
        this._triggerRenderer = new TriggerRenderer();
    }

    protected String getText(FacesBean bean) {
        return PanelPopupRenderer.toString((Object)this.resolveProperty(bean, this._textKey));
    }

    protected String getIcon(FacesBean bean) {
        return PanelPopupRenderer.toResourceUri((FacesContext)FacesContext.getCurrentInstance(), (Object)this.resolveProperty(bean, this._iconKey));
    }

    protected String getTitle(FacesBean bean) {
        return PanelPopupRenderer.toString((Object)this.resolveProperty(bean, this._titleKey));
    }

    protected String getTriggerType(FacesBean bean) {
        return PanelPopupRenderer.toString((Object)this.resolveProperty(bean, this._triggerTypeKey, true));
    }

    protected String getPosition(FacesBean bean) {
        return PanelPopupRenderer.toString((Object)this.resolveProperty(bean, this._positionKey));
    }

    protected String getContentStyle(FacesBean bean) {
        return PanelPopupRenderer.toString((Object)this.resolveProperty(bean, this._contentStyleKey));
    }

    protected int getWidth(FacesBean bean) {
        return PanelPopupRenderer.toInt((Object)this.resolveProperty(bean, this._widthKey, true));
    }

    protected int getHeight(FacesBean bean) {
        return PanelPopupRenderer.toInt((Object)this.resolveProperty(bean, this._heightKey, true));
    }

    protected int getHorzOffset(FacesBean bean) {
        return PanelPopupRenderer.toInt((Object)this.resolveProperty(bean, this._horzOffsetKey, true));
    }

    protected int getVertOffset(FacesBean bean) {
        return PanelPopupRenderer.toInt((Object)this.resolveProperty(bean, this._vertOffsetKey, true));
    }

    protected boolean isModal(FacesBean bean) {
        return (Boolean)this.resolveProperty(bean, this._modalKey, true);
    }

    protected boolean isCentered(FacesBean bean) {
        String centeredString = PanelPopupRenderer.toString((Object)this.resolveProperty(bean, this._positionKey));
        return "centered".equalsIgnoreCase(centeredString);
    }

    protected void encodeAll(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean) throws IOException {
        if (!PanelPopupRenderer.supportsScripting(arc)) {
            this.renderTrigger(context, arc, component, bean);
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        String clientId = this.getClientId(context, component);
        assert (arc.getCurrentClientId() == null);
        arc.setCurrentClientId(clientId);
        writer.startElement("span", component);
        writer.writeAttribute("id_popupTrigger", (Object)XhtmlUtils.getJSIdentifier(clientId), null);
        PanelPopupRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)"af|panelPopup::trigger");
        this.renderTrigger(context, arc, component, bean);
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)(XhtmlUtils.getJSIdentifier(clientId) + _POPUP_CONTAINER_ID_SUFFIX), null);
        writer.writeAttribute("style", (Object)_POPUP_CONTAINER_DIV_STYLES, null);
        writer.startElement("div", null);
        PanelPopupRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)"af|panelPopup::container");
        this.renderInlineStyle(context, arc, bean);
        this.renderTitleBar(context, arc, component, bean);
        writer.startElement("div", null);
        PanelPopupRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)"af|panelPopup::content");
        int height = this.getHeight(bean);
        if (height > 0) {
            String style = "overflow: auto; height:" + height + "px";
            writer.writeAttribute("style", (Object)style, null);
        }
        this.encodeAllChildren(context, component);
        writer.endElement("div");
        writer.endElement("div");
        writer.endElement("div");
        writer.endElement("span");
        arc.setCurrentClientId(null);
    }

    protected void renderTrigger(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean) throws IOException {
        this.delegateRendererBegin(context, arc, component, bean, this._triggerRenderer);
        UIComponent triggerFacet = PanelPopupRenderer.getFacet((UIComponent)component, (String)"trigger");
        if (triggerFacet != null) {
            this.encodeChild(context, triggerFacet);
        }
        OutputUtils.renderImage(context, arc, this.getIcon(bean), null, null, null, "", component, null, "af|panelPopup::icon-style");
        this.delegateRendererEnd(context, arc, component, bean, this._triggerRenderer);
    }

    protected void renderTitleBar(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String title = this.getTitle(bean);
        if (title == null) {
            return;
        }
        writer.startElement("div", null);
        PanelPopupRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)"af|panelPopup::title-bar");
        writer.startElement("div", null);
        PanelPopupRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)"af|panelPopup::title-text");
        writer.writeAttribute("style", (Object)"float:left;", null);
        writer.writeText((Object)title, "title");
        writer.endElement("div");
        Icon icon = arc.getIcon("af|panelPopup::close-icon");
        if (this.isModal(bean)) {
            writer.startElement("div", null);
            PanelPopupRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)"af|panelPopup::close-icon");
            writer.startElement("a", null);
            writer.writeAttribute("href", (Object)"#", null);
            writer.writeAttribute("onclick", (Object)"TrPanelPopup.hidePopup(event); return false;", null);
            if (icon != null && !icon.isNull()) {
                String closeText = arc.getTranslatedString("af_panelPopup.CLOSE");
                OutputUtils.renderIcon(context, arc, icon, closeText, null);
            } else {
                writer.writeText((Object)"X", "text");
            }
            writer.endElement("a");
            writer.endElement("div");
        }
        writer.startElement("div", null);
        writer.writeAttribute("style", (Object)"clear: left;", null);
        writer.endElement("div");
        writer.endElement("div");
    }

    private class TriggerRenderer
    extends GoLinkRenderer {
        private TriggerRenderer() {
        }

        protected boolean shouldRenderId(FacesContext context, UIComponent component) {
            return true;
        }

        protected String getClientId(FacesContext context, UIComponent component) {
            return XhtmlUtils.getJSIdentifier(PanelPopupRenderer.this.getClientId(context, component));
        }

        protected String getOnclick(FacesBean bean) {
            String onclick = PanelPopupRenderer.this.getOnclick(bean);
            String script = null;
            if ("click".equalsIgnoreCase(PanelPopupRenderer.this.getTriggerType(bean))) {
                String componentId = RenderingContext.getCurrentInstance().getCurrentClientId();
                script = this.getTriggerScript(bean, componentId);
            }
            return XhtmlUtils.getChainedJS(onclick, script, true);
        }

        protected String getOnmouseover(FacesBean bean) {
            String onclick = super.getOnmouseover(bean);
            String script = null;
            if ("hover".equalsIgnoreCase(PanelPopupRenderer.this.getTriggerType(bean))) {
                String componentId = RenderingContext.getCurrentInstance().getCurrentClientId();
                script = this.getTriggerScript(bean, componentId);
            }
            return XhtmlUtils.getChainedJS(onclick, script, true);
        }

        protected String getText(FacesBean bean) {
            return PanelPopupRenderer.this.getText(bean);
        }

        protected String getInlineStyle(FacesBean bean) {
            return PanelPopupRenderer.this.getInlineStyle(bean);
        }

        protected String getStyleClass(FacesBean bean) {
            return PanelPopupRenderer.this.getStyleClass(bean);
        }

        protected String getDefaultStyleClass(FacesBean bean) {
            return "af|panelPopup::link";
        }

        protected String getTriggerScript(FacesBean bean, String componentId) {
            String clientId = XhtmlUtils.getJSIdentifier(componentId);
            StringBuilder script = new StringBuilder();
            script.append("TrPanelPopup.showPopup('");
            script.append(clientId);
            script.append(PanelPopupRenderer._POPUP_CONTAINER_ID_SUFFIX);
            script.append("', '");
            script.append(clientId);
            script.append("', event, '");
            script.append(PanelPopupRenderer.this.getTriggerType(bean));
            script.append("','");
            script.append(PanelPopupRenderer.this.getPosition(bean));
            script.append("',");
            script.append(PanelPopupRenderer.this.isModal(bean));
            script.append(",");
            script.append(PanelPopupRenderer.this.getWidth(bean));
            script.append(",");
            script.append(PanelPopupRenderer.this.getHeight(bean));
            script.append(",");
            script.append(PanelPopupRenderer.this.getHorzOffset(bean));
            script.append(",");
            script.append(PanelPopupRenderer.this.getVertOffset(bean));
            script.append("); return false;");
            return script.toString();
        }
    }
}

