/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletResponse;
import org.apache.myfaces.trinidad.context.Agent;
import org.apache.myfaces.trinidad.context.PartialPageContext;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.util.ExternalContextUtils;
import org.apache.myfaces.trinidadinternal.agent.TrinidadAgent;
import org.apache.myfaces.trinidadinternal.renderkit.core.ppr.PartialPageContextImpl;
import org.apache.myfaces.trinidadinternal.renderkit.core.ppr.XmlResponseWriter;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;

public final class PartialPageUtils {
    private static final String _INIT_PROP_PPR_OPTIMIZATION_ENABLED = "org.apache.myfaces.trinidadinternal.ENABLE_PPR_OPTIMIZATION";
    private static final String _APP_PROP_PPR_OPTIMIZATION_DISABLED = "org.apache.myfaces.trinidadinternal.DISABLE_PPR_OPTIMIZATION";
    private static final String _PPR_ACTIVE_FLAG_NAME = "org.apache.myfaces.trinidadinternal.renderkit._pprActiveOnPage";

    private PartialPageUtils() {
    }

    public static boolean isOptimizedPPREnabled(FacesContext context, boolean checkIsPPR) {
        ExternalContext external;
        boolean optimizedPPREnabled = false;
        if ((!checkIsPPR || PartialPageUtils.isPartialRequest(context) && PartialPageUtils.isPPRActive(context)) && "true".equalsIgnoreCase((external = context.getExternalContext()).getInitParameter(_INIT_PROP_PPR_OPTIMIZATION_ENABLED))) {
            optimizedPPREnabled = !Boolean.TRUE.equals(external.getApplicationMap().get(_APP_PROP_PPR_OPTIMIZATION_DISABLED));
        }
        return optimizedPPREnabled;
    }

    public static boolean containsPprTargets(RenderingContext rc, UIComponent component, String clientId) {
        if (!(component instanceof NamingContainer)) {
            throw new IllegalArgumentException();
        }
        PartialPageContext ppc = rc.getPartialPageContext();
        if (ppc == null || ppc.isInsidePartialTarget()) {
            return true;
        }
        if (ppc.isPartialTarget(clientId)) {
            return true;
        }
        String clientIdPrefix = clientId + ':';
        Iterator targets = ppc.getPartialTargets();
        while (targets.hasNext()) {
            String target = (String)targets.next();
            if (target == null || !target.startsWith(clientIdPrefix)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPartialRequest(FacesContext context) {
        RequestContext rc = RequestContext.getCurrentInstance();
        if (rc == null) {
            return false;
        }
        return rc.isPartialRequest(context);
    }

    public static void forcePartialRendering(FacesContext context) {
    }

    public static PartialPageContext createPartialPageContext(FacesContext context, RequestContext afContext) {
        if (PartialPageUtils.isPartialRequest(context)) {
            return new PartialPageContextImpl(context, afContext);
        }
        return null;
    }

    public static boolean isPartialRenderingPass(RenderingContext arc) {
        PartialPageContext pprContext = arc.getPartialPageContext();
        return pprContext != null;
    }

    public static boolean supportsPartialRendering(RenderingContext arc) {
        Agent agent = arc.getAgent();
        Object capPartial = agent.getCapabilities().get(TrinidadAgent.CAP_PARTIAL_RENDERING);
        return Boolean.TRUE.equals(capPartial);
    }

    public static boolean supportsBlocking(RenderingContext arc) {
        if (PartialPageUtils.supportsPartialRendering(arc)) {
            return XhtmlRenderer.isIE((RenderingContext)arc) || XhtmlRenderer.isGecko((RenderingContext)arc);
        }
        return false;
    }

    public static boolean isPPRActive(FacesContext context) {
        Map requestScope = context.getExternalContext().getRequestMap();
        return Boolean.TRUE.equals(requestScope.get(_PPR_ACTIVE_FLAG_NAME));
    }

    public static void markPPRActive(FacesContext context) {
        Map requestScope = context.getExternalContext().getRequestMap();
        requestScope.put(_PPR_ACTIVE_FLAG_NAME, Boolean.TRUE);
    }

    public static void renderNoopResponse(FacesContext context) throws IOException {
        ExternalContext external = context.getExternalContext();
        Writer writer = ExternalContextUtils.getResponseWriter((ExternalContext)external);
        Object response = external.getResponse();
        if (response instanceof HttpServletResponse) {
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            httpResponse.setHeader("Cache-Control", "no-cache");
            httpResponse.setHeader("Pragma", "no-cache");
            httpResponse.setHeader("Expires", "-1");
        }
        XmlResponseWriter xrw = new XmlResponseWriter(writer, "utf-8");
        xrw.startDocument();
        xrw.startElement("noop", null);
        xrw.endElement("noop");
        xrw.endDocument();
        xrw.close();
    }
}

