/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.component.UIXHierarchy;
import org.apache.myfaces.trinidad.component.UIXTreeTable;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.model.RowKeySet;
import org.apache.myfaces.trinidad.skin.Icon;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.ColumnRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.OutputUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.TableRenderingContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.TreeTableRenderingContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.TreeUtils;

public class TreeNodeColumnRenderer
extends ColumnRenderer {
    private static final String _ICON_ID = "hgi";
    private static final String _DISABLED_COLLAPSE_TIP_KEY = "af_treeTable.DISABLED_COLLAPSE_TIP";
    private static final String _COLLAPSE_TIP_KEY = "af_treeTable.COLLAPSE_TIP";
    private static final String _EXPAND_TIP_KEY = "af_treeTable.EXPAND_TIP";
    private static final String _NODE_LEVEL_TEXT_KEY = "af_treeTable.NODE_LEVEL";
    public static final String NODE_ICON_EXPANDED_SUFFIX = "-expanded";
    public static final String NODE_ICON_COLLAPSED_SUFFIX = "-collapsed";
    public static final int NODE_ICON_MAX_WIDTH = 18;

    protected void renderKids(FacesContext context, RenderingContext arc, TableRenderingContext tContext, UIComponent column) throws IOException {
        String onclick;
        boolean disclosed;
        TreeTableRenderingContext ttrc = (TreeTableRenderingContext)tContext;
        boolean isRTL = arc.isRightToLeft();
        UIXTreeTable hGrid = ttrc.getUIXTreeTable();
        if (hGrid.isContainer()) {
            RowKeySet treeState = hGrid.getDisclosedRowKeys();
            String jsVarName = ttrc.getJSVarName();
            if (treeState.isContained()) {
                disclosed = true;
                onclick = TreeUtils.callJSExpandNode((UIXHierarchy)hGrid, jsVarName, false);
            } else {
                disclosed = false;
                onclick = TreeUtils.callJSExpandNode((UIXHierarchy)hGrid, jsVarName, true);
            }
        } else {
            disclosed = false;
            onclick = null;
        }
        int focusPath = hGrid.getDepth(TreeUtils.getFocusRowKey(hGrid));
        int depth = hGrid.getDepth() + 1 - focusPath;
        if (!ttrc.isRootNodeRendered()) {
            --depth;
        }
        int spacerWidth = this._getSpacerWidth(ttrc);
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        if (isRTL) {
            if (onclick != null) {
                --depth;
            }
            writer.writeAttribute("style", (Object)("margin-right:" + depth * spacerWidth + "px"), null);
        } else {
            writer.writeAttribute("style", (Object)("position:relative;top:0px;left:0px;margin-left:" + depth * spacerWidth + "px"), null);
        }
        if (onclick != null) {
            writer.startElement("a", null);
            this._renderIconID(context, tContext);
            TreeNodeColumnRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)"af|treeTable::expansion");
            if (XhtmlRenderer.supportsScripting(arc)) {
                writer.writeAttribute("onclick", (Object)onclick, null);
                writer.writeURIAttribute("href", (Object)"#", null);
            }
            this._renderExpansionIcon(context, arc, disclosed, onclick);
            writer.endElement("a");
        }
        this._renderNodeIcon(context, arc, hGrid, disclosed, onclick != null);
        UIComponent nodeStampColumn = ttrc.getTreeNodeStamp();
        this._renderNodeStampBasedOnAccessibilty(context, arc, ttrc, nodeStampColumn);
        writer.endElement("div");
    }

    private int _getSpacerWidth(TreeTableRenderingContext ttrc) {
        return ttrc.getSpacerWidth();
    }

    private void _renderIconID(FacesContext fc, TableRenderingContext tContext) throws IOException {
        String tableName = tContext.getTable().getContainerClientId(fc);
        String id = tableName + ':' + _ICON_ID;
        fc.getResponseWriter().writeAttribute("id", (Object)id, null);
    }

    private void _renderExpansionIcon(FacesContext context, RenderingContext arc, boolean disclosed, Object onclick) throws IOException {
        String altTextKey;
        String iconName;
        if (disclosed) {
            iconName = "af|treeTable::expanded-icon";
            altTextKey = onclick == null ? _DISABLED_COLLAPSE_TIP_KEY : _COLLAPSE_TIP_KEY;
        } else {
            iconName = "af|treeTable::collapsed-icon";
            altTextKey = _EXPAND_TIP_KEY;
        }
        Icon icon = arc.getIcon(iconName);
        if (icon != null) {
            String altText = arc.getTranslatedString(altTextKey);
            OutputUtils.renderIcon(context, arc, icon, altText, null);
        }
    }

    private void _renderNodeIcon(FacesContext context, RenderingContext arc, UIXTreeTable ttr, boolean disclosed, boolean hasChildren) throws IOException {
        Icon nodeIcon = this.getNodeIcon(arc, this.getNodeType(ttr), disclosed, hasChildren);
        if (nodeIcon != null) {
            OutputUtils.renderIcon(context, arc, nodeIcon, null, null);
        }
    }

    protected String getNodeType(UIXTreeTable ttr) {
        String nodeType = null;
        Object rowData = ttr.getRowData();
        Class<?> rowClass = rowData.getClass();
        Method method = null;
        try {
            method = rowClass.getMethod("getNodeType", new Class[0]);
            if (method != null && method.getReturnType().equals(String.class)) {
                nodeType = (String)method.invoke(rowData, new Object[0]);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return nodeType;
    }

    protected String getNodeIconSelector(String nodeType, boolean disclosed, boolean hasChildren) {
        if (hasChildren) {
            nodeType = disclosed ? nodeType + NODE_ICON_EXPANDED_SUFFIX : nodeType + NODE_ICON_COLLAPSED_SUFFIX;
        }
        return "af|treeTable::node-icon:" + nodeType;
    }

    protected Icon getNodeIcon(RenderingContext rc, String nodeType, boolean disclosed, boolean hasChildren) {
        if (nodeType == null || nodeType.length() == 0) {
            return null;
        }
        Icon icon = rc.getIcon(this.getNodeIconSelector(nodeType, disclosed, hasChildren));
        if (icon == null) {
            icon = hasChildren ? rc.getIcon(this.getNodeIconSelector(nodeType, disclosed, false)) : rc.getIcon(this.getNodeIconSelector(nodeType, false, true));
        }
        return icon;
    }

    private void _renderNodeStampBasedOnAccessibilty(FacesContext context, RenderingContext arc, TreeTableRenderingContext ttrc, UIComponent column) throws IOException {
        if (XhtmlRenderer.isScreenReaderMode((RenderingContext)arc)) {
            int depth = ttrc.getUIXTreeTable().getDepth() + 1;
            if (arc.isRightToLeft()) {
                super.renderKids(context, arc, ttrc, column);
                TreeUtils.writeNodeLevel(context, arc, depth, _NODE_LEVEL_TEXT_KEY);
            } else {
                TreeUtils.writeNodeLevel(context, arc, depth, _NODE_LEVEL_TEXT_KEY);
                super.renderKids(context, arc, ttrc, column);
            }
        } else {
            super.renderKids(context, arc, ttrc, column);
        }
    }
}

