/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.ui.action;

import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.share.url.FormEncoder;
import org.apache.myfaces.trinidadinternal.ui.UIConstants;
import org.apache.myfaces.trinidadinternal.ui.UINode;
import org.apache.myfaces.trinidadinternal.ui.UIXRenderingContext;
import org.apache.myfaces.trinidadinternal.ui.collection.Parameter;
import org.apache.myfaces.trinidadinternal.ui.data.BoundValue;
import org.apache.myfaces.trinidadinternal.ui.laf.base.xhtml.XhtmlLafUtils;

@Deprecated
class ActionUtils {
    private static final String _FORM_WARNING = "Action can only be used within a form, or by specifying the formName attribute";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(ActionUtils.class);

    ActionUtils() {
    }

    public static Parameter[] cloneParameterArray(Parameter[] parameters) {
        if (parameters == null) {
            return null;
        }
        int length = parameters.length;
        if (length == 0) {
            return new Parameter[0];
        }
        Parameter[] copied = new Parameter[length];
        for (int i = 0; i < length; ++i) {
            copied[i] = (Parameter)parameters[i].clone();
        }
        return copied;
    }

    public static Parameter[] joinParameterArrays(Parameter[] parametersA, Parameter[] parametersB) {
        int i;
        if (parametersA == null || parametersA.length == 0) {
            return ActionUtils.cloneParameterArray(parametersB);
        }
        if (parametersB == null || parametersB.length == 0) {
            return ActionUtils.cloneParameterArray(parametersA);
        }
        int lengthA = parametersA.length;
        int lengthB = parametersB.length;
        int index = 0;
        Parameter[] copied = new Parameter[lengthA + lengthB];
        for (i = 0; i < lengthA; ++i) {
            copied[index++] = (Parameter)parametersA[i].clone();
        }
        for (i = 0; i < lengthB; ++i) {
            copied[index++] = (Parameter)parametersB[i].clone();
        }
        return copied;
    }

    public static String[] copyPartialTargets(String[] targets) {
        if (targets == null) {
            return null;
        }
        String[] copyTargets = new String[targets.length];
        System.arraycopy(targets, 0, copyTargets, 0, targets.length);
        return copyTargets;
    }

    public static void appendClientParameters(UIXRenderingContext context, StringBuilder buffer, Parameter[] parameters) {
        ActionUtils.appendClientParameters(context, buffer, parameters, null, null);
    }

    public static void appendClientParameters(UIXRenderingContext context, StringBuilder buffer, Parameter[] parameters, String event, String source) {
        ActionUtils.appendClientParameters(context, buffer, parameters, event, source, null);
    }

    public static void appendClientParameters(UIXRenderingContext context, StringBuilder buffer, Parameter[] parameters, String event, String source, String formName) {
        boolean gotSource;
        boolean gotParams = parameters != null && parameters.length > 0;
        boolean gotEvent = event != null;
        boolean bl = gotSource = source != null;
        if (buffer.charAt(buffer.length() - 1) != ',') {
            buffer.append(',');
        }
        if (!(gotEvent || gotSource || gotParams)) {
            buffer.append('0');
            return;
        }
        buffer.append('{');
        FormEncoder formEncoder = context.getFormEncoder();
        boolean firstParameter = true;
        if (gotParams) {
            for (int i = 0; i < parameters.length; ++i) {
                Parameter param = parameters[i];
                String paramKey = param.getKey();
                if (gotEvent && paramKey.equalsIgnoreCase("event") || gotSource && paramKey.equalsIgnoreCase("source")) continue;
                if (!firstParameter) {
                    buffer.append(',');
                } else {
                    firstParameter = false;
                }
                buffer.append("'");
                buffer.append(paramKey);
                buffer.append("':'");
                String value = param.getValue(context);
                String encodedValue = XhtmlLafUtils.getFormEncodedParameter(formEncoder, formName, paramKey, value);
                if (encodedValue != null) {
                    XhtmlLafUtils.escapeJS(buffer, encodedValue, true);
                }
                buffer.append("'");
            }
        }
        if (gotEvent) {
            if (!firstParameter) {
                buffer.append(',');
            } else {
                firstParameter = false;
            }
            buffer.append("event:'");
            String encodedEvent = XhtmlLafUtils.getFormEncodedParameter(formEncoder, formName, "event", event);
            if (encodedEvent != null) {
                XhtmlLafUtils.escapeJS(buffer, encodedEvent, true);
            }
            buffer.append("'");
        }
        if (gotSource) {
            if (!firstParameter) {
                buffer.append(',');
            } else {
                firstParameter = false;
            }
            buffer.append("source:'");
            String encodedSource = XhtmlLafUtils.getFormEncodedParameter(formEncoder, formName, "source", source);
            if (encodedSource != null) {
                XhtmlLafUtils.escapeJS(buffer, encodedSource, true);
            }
            buffer.append("'");
        }
        buffer.append("}");
    }

    static String appendURLParameters(UIXRenderingContext context, String base, Parameter[] params) {
        int bufLen = 1 + base.length() + ActionUtils.getClientParametersSize(context, params);
        StringBuilder buffer = new StringBuilder(bufLen);
        buffer.append(base);
        if (base.indexOf(63) < 0) {
            buffer.append('?');
        }
        ActionUtils.appendURLParameters(buffer, params);
        return buffer.toString();
    }

    static void appendURLParameters(StringBuilder buffer, Parameter[] params) {
        for (int i = 0; i < params.length; ++i) {
            ActionUtils.appendURLParameter(buffer, params[i].getKey(), params[i].getValue());
        }
    }

    static void appendURLParameter(StringBuilder buffer, Parameter param) {
        ActionUtils.appendURLParameter(buffer, param.getKey(), param.getValue());
    }

    static void appendURLParameter(StringBuilder buffer, String name, String value) {
        if (value == null) {
            return;
        }
        char lastChar = buffer.charAt(buffer.length() - 1);
        if (lastChar != '?' && lastChar != '&') {
            buffer.append('&');
        }
        buffer.append(name);
        buffer.append('=');
        buffer.append(value);
    }

    public static final int getClientParametersSize(UIXRenderingContext context, Parameter[] parameters) {
        if (parameters == null || parameters.length == 0) {
            return 1;
        }
        int length = 2;
        for (int i = 0; i < parameters.length; ++i) {
            Parameter param = parameters[i];
            length += param.getKey().length();
            String value = param.getValue(context);
            if (value != null) {
                length += value.length();
            }
            length += 4;
            if (i >= parameters.length - 1) continue;
            ++length;
        }
        return length;
    }

    public static String getFormName(UIXRenderingContext context) {
        Object formName = context.getProperty("http://myfaces.apache.org/uix/ui", "formName");
        if (formName == null) {
            if (_LOG.isWarning()) {
                _LOG.warning(_FORM_WARNING);
            }
            assert (false) : "Action can only be used within a form, or by specifying the formName attribute";
            return null;
        }
        return formName.toString();
    }

    public static String getSource(UIXRenderingContext context, UINode node, BoundValue binding, String actionSource) {
        String source = null;
        if (binding != null) {
            source = (String)binding.getValue(context);
        }
        if (source == null) {
            source = actionSource;
        }
        if (source == null) {
            Object id = node.getAttributeValue(context, UIConstants.ID_ATTR);
            if (id == null) {
                id = node.getAttributeValue(context, UIConstants.NAME_ATTR);
            }
            source = id == null ? null : id.toString();
        }
        return source;
    }

    static Parameter buildParameter(UIXRenderingContext context, UINode node, BoundValue binding, String param, String paramName) {
        Parameter parameter = new Parameter();
        parameter.setKey(paramName);
        parameter.setValue(param);
        parameter.setValueBinding(binding);
        return parameter;
    }

    public static Object getValue(UIXRenderingContext context, BoundValue boundValue, Object defaultValue) {
        if (boundValue != null) {
            return boundValue.getValue(context);
        }
        return defaultValue;
    }
}

