/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.image.painter;

import java.awt.Dimension;
import java.awt.Graphics;
import org.apache.myfaces.trinidadinternal.image.painter.AbstractWrappingPainter;
import org.apache.myfaces.trinidadinternal.image.painter.BorderPainter;
import org.apache.myfaces.trinidadinternal.image.painter.ImmInsets;
import org.apache.myfaces.trinidadinternal.image.painter.PaintContext;
import org.apache.myfaces.trinidadinternal.image.painter.Painter;

public abstract class AbstractBorderPainter
extends AbstractWrappingPainter
implements BorderPainter {
    private BorderPainter _wrappedBorderPainter;
    private boolean _alwaysAddInsets;

    public AbstractBorderPainter() {
        this._init(null, true);
    }

    public AbstractBorderPainter(Painter wrappedPainter) {
        this(wrappedPainter, true);
    }

    public AbstractBorderPainter(Painter wrappedPainter, boolean alwaysAddInsets) {
        super(wrappedPainter);
        this._init(wrappedPainter, alwaysAddInsets);
    }

    @Override
    public Dimension getPreferredSize(PaintContext context) {
        return this._addInsets(context, super.getPreferredSize(context));
    }

    @Override
    public Dimension getMinimumSize(PaintContext context) {
        return this._addInsets(context, super.getMinimumSize(context));
    }

    @Override
    public final void paint(PaintContext context, Graphics g, int x, int y, int width, int height) {
        this.paintBorder(context, g, x, y, width, height);
        ImmInsets borderSizes = this.getOwnInsets(context);
        super.paint(context, g, x + borderSizes.left, y + borderSizes.top, width - borderSizes.left - borderSizes.right, height - borderSizes.top - borderSizes.bottom);
    }

    @Override
    public final ImmInsets getInsets(PaintContext context) {
        ImmInsets ownInsets = this.getOwnInsets(context);
        if (this._wrappedBorderPainter != null) {
            ImmInsets wrappedInsets = this._wrappedBorderPainter.getInsets(context);
            ownInsets = new ImmInsets(ownInsets.top + wrappedInsets.top, ownInsets.left + wrappedInsets.left, ownInsets.bottom + wrappedInsets.bottom, ownInsets.right + wrappedInsets.right);
        }
        return ownInsets;
    }

    @Override
    public final ImmInsets getFillInsets(PaintContext context) {
        if (this._wrappedBorderPainter != null) {
            ImmInsets wrappedInsets = this._wrappedBorderPainter.getFillInsets(context);
            if (wrappedInsets.equals(ImmInsets.getEmptyInsets())) {
                return this.getOwnFillInsets(context);
            }
            ImmInsets ownInsets = this.getOwnInsets(context);
            return new ImmInsets(ownInsets.top + wrappedInsets.top, ownInsets.left + wrappedInsets.left, ownInsets.bottom + wrappedInsets.bottom, ownInsets.right + wrappedInsets.right);
        }
        return this.getOwnFillInsets(context);
    }

    protected ImmInsets getOwnInsets(PaintContext context) {
        return ImmInsets.getEmptyInsets();
    }

    protected ImmInsets getOwnFillInsets(PaintContext context) {
        return this.getOwnInsets(context);
    }

    protected void paintBorder(PaintContext context, Graphics g, int x, int y, int width, int height) {
    }

    private Dimension _addInsets(PaintContext context, Dimension innerSize) {
        if (this._alwaysAddInsets || innerSize.width > 0 && innerSize.height > 0) {
            ImmInsets borderSizes = this.getOwnInsets(context);
            innerSize.width += borderSizes.left + borderSizes.right;
            innerSize.height += borderSizes.top + borderSizes.bottom;
        }
        return innerSize;
    }

    private void _init(Painter wrappedPainter, boolean alwaysAddInsets) {
        if (wrappedPainter instanceof BorderPainter) {
            this._wrappedBorderPainter = (BorderPainter)wrappedPainter;
        }
        this._alwaysAddInsets = alwaysAddInsets;
    }
}

