/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.share.xml.beans;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.share.xml.BaseNodeParser;
import org.apache.myfaces.trinidadinternal.share.xml.NodeParser;
import org.apache.myfaces.trinidadinternal.share.xml.ParseContext;
import org.apache.myfaces.trinidadinternal.share.xml.beans.BeanDef;
import org.apache.myfaces.trinidadinternal.share.xml.beans.PropertyDef;
import org.xml.sax.Attributes;

public class BeanParser
extends BaseNodeParser {
    private final BeanDef _beanDef;
    private Object _bean;
    private String _namespaceURI;
    private PropertyDef _currentPropDef;
    private boolean _currentPropDefUsed;
    private boolean _currentPropDefInline;
    private boolean _currentPropDefIsArray;
    private List<Object> _currentArray;
    private Map<PropertyDef, List<Object>> _inlineArrays;
    private String _defaultPropertyText;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(BeanParser.class);

    public BeanParser(BeanDef beanDef) {
        if (beanDef == null) {
            throw new NullPointerException();
        }
        this._beanDef = beanDef;
    }

    @Override
    public void startElement(ParseContext context, String namespaceURI, String localName, Attributes attrs) {
        block4: {
            try {
                boolean otherNamespaces;
                Object bean = this._beanDef.createBean(namespaceURI, localName);
                int length = attrs.getLength();
                if (length > 0 && (otherNamespaces = this._parseAttributes(context, bean, attrs, true))) {
                    this._parseAttributes(context, bean, attrs, false);
                }
                this._namespaceURI = namespaceURI;
                this._bean = bean;
                PropertyDef defaultPropertyDef = this._beanDef.getDefaultPropertyDef();
                if (defaultPropertyDef != null && defaultPropertyDef.getPropertyType() != String.class) {
                    this._currentPropDef = defaultPropertyDef;
                    this.startEnvelopeChildProperty(context, namespaceURI, defaultPropertyDef.getName(), null, defaultPropertyDef);
                }
            }
            catch (Exception e) {
                if (!_LOG.isWarning()) break block4;
                _LOG.warning((Throwable)e);
            }
        }
    }

    @Override
    public NodeParser startChildElement(ParseContext context, String namespaceURI, String localName, Attributes attrs) {
        if (this._bean == null) {
            return null;
        }
        if (this._currentPropDef != null) {
            if (this._currentPropDefUsed) {
                _LOG.warning("ONLY_ONE_CHILD_ELEMENT_ALLOWED");
                return null;
            }
            if (this._currentPropDefIsArray) {
                Class<?> cls = this._currentPropDef.getPropertyType().getComponentType();
                return context.getParser(cls, namespaceURI, localName);
            }
            this._currentPropDefUsed = true;
            return context.getParser(this._currentPropDef.getPropertyType(), namespaceURI, localName);
        }
        PropertyDef def = null;
        if (namespaceURI == this._namespaceURI) {
            def = this._beanDef.getPropertyDef(localName);
        }
        if (def == null) {
            def = this._beanDef.getElementPropertyDef(namespaceURI, localName, attrs);
        }
        if (def != null) {
            return this.startChildProperty(context, namespaceURI, localName, attrs, def);
        }
        return null;
    }

    @Override
    public void endChildElement(ParseContext context, String namespaceURI, String localName) {
        if (this._currentPropDefIsArray) {
            assert (this._currentPropDef != null && this._currentArray != null);
            Object[] array = BeanParser._getArray(this._currentPropDef, this._currentArray);
            this._currentPropDef.setValue(context, this._bean, array);
            this._currentArray = null;
        }
        this._currentPropDef = null;
    }

    @Override
    public void addText(ParseContext context, char[] text, int start, int length) {
        PropertyDef defaultPropertyDef = this._beanDef.getDefaultPropertyDef();
        if (defaultPropertyDef != null && defaultPropertyDef.getPropertyType() == String.class) {
            String s = new String(text, start, length);
            this._defaultPropertyText = this._defaultPropertyText == null ? s : this._defaultPropertyText + s;
        }
    }

    @Override
    public void addCompletedChild(ParseContext context, String namespaceURI, String localName, Object child) {
        if (child == null) {
            if (this._currentPropDefInline) {
                this._currentPropDef = null;
            }
            return;
        }
        assert (this._currentPropDef != null && this._bean != null);
        if (this._currentPropDefIsArray) {
            if (this._currentPropDefInline) {
                this._inlineArrays.get(this._currentPropDef).add(child);
                this._currentPropDef = null;
            } else {
                this._currentArray.add(child);
            }
        } else {
            this._currentPropDef.setValue(context, this._bean, child);
            if (this._currentPropDefInline) {
                this._currentPropDef = null;
            }
        }
    }

    @Override
    public Object endElement(ParseContext context, String namespaceURI, String localName) {
        if (this._bean == null) {
            return null;
        }
        PropertyDef defaultPropertyDef = this._beanDef.getDefaultPropertyDef();
        if (defaultPropertyDef != null) {
            if (defaultPropertyDef.getPropertyType() != String.class) {
                this.endChildElement(context, namespaceURI, defaultPropertyDef.getName());
            } else if (this._defaultPropertyText != null) {
                defaultPropertyDef.setValue(context, this._bean, this._defaultPropertyText);
            }
        }
        if (this._inlineArrays != null) {
            for (Map.Entry<PropertyDef, List<Object>> entry : this._inlineArrays.entrySet()) {
                PropertyDef def = entry.getKey();
                Object[] array = BeanParser._getArray(def, entry.getValue());
                def.setValue(context, this._bean, array);
            }
        }
        return this._beanDef.finishBean(this._bean);
    }

    protected final NodeParser startChildProperty(ParseContext context, String namespaceURI, String localName, Attributes attrs, PropertyDef def) {
        if (this.isInlineChildProperty(context, namespaceURI, localName, def)) {
            return this.startInlineChildProperty(context, namespaceURI, localName, attrs, def);
        }
        return this.startEnvelopeChildProperty(context, namespaceURI, localName, attrs, def);
    }

    protected NodeParser startInlineChildProperty(ParseContext context, String namespaceURI, String localName, Attributes attrs, PropertyDef def) {
        NodeParser parser;
        Class<?> cls = def.getPropertyType();
        boolean isArray = cls.isArray();
        if (isArray) {
            cls = cls.getComponentType();
        }
        if ((parser = context.getParser(cls, namespaceURI, localName)) != null) {
            this._currentPropDef = def;
            this._currentPropDefUsed = true;
            this._currentPropDefInline = true;
            this._currentPropDefIsArray = isArray;
            if (isArray) {
                if (this._inlineArrays == null) {
                    this._inlineArrays = new HashMap<PropertyDef, List<Object>>(3);
                }
                if (this._inlineArrays.get(def) == null) {
                    this._inlineArrays.put(def, new ArrayList());
                }
            }
        }
        return parser;
    }

    protected NodeParser startEnvelopeChildProperty(ParseContext context, String namespaceURI, String localName, Attributes attrs, PropertyDef def) {
        this._currentPropDef = def;
        this._currentPropDefUsed = false;
        this._currentPropDefInline = false;
        this._currentPropDefIsArray = def.getPropertyType().isArray();
        if (this._currentPropDefIsArray) {
            this._currentArray = new ArrayList<Object>();
        }
        return this;
    }

    protected boolean isInlineChildProperty(ParseContext context, String namespaceURI, String localName, PropertyDef def) {
        return this._beanDef.isInlineChildProperty(namespaceURI, localName, def);
    }

    protected final BeanDef getBeanDef() {
        return this._beanDef;
    }

    protected final Object getBean() {
        return this._bean;
    }

    private boolean _parseAttributes(ParseContext context, Object bean, Attributes attrs, boolean defaultNamespace) {
        boolean otherNamespaces = false;
        int length = attrs.getLength();
        for (int i = 0; i < length; ++i) {
            String attrNamespace = attrs.getURI(i);
            if ("".equals(attrNamespace) ^ !defaultNamespace) {
                String attrLocalName = attrs.getLocalName(i);
                PropertyDef propertyDef = defaultNamespace ? this._beanDef.getPropertyDef(attrLocalName) : this._beanDef.getPropertyDef(attrNamespace, attrLocalName);
                if (propertyDef != null) {
                    String valueText = attrs.getValue(i);
                    try {
                        Object value = propertyDef.parseText(context, attrNamespace, valueText);
                        propertyDef.setValue(context, bean, value);
                    }
                    catch (IllegalArgumentException iae) {
                        if (!_LOG.isWarning()) continue;
                        if (defaultNamespace) {
                            _LOG.warning("CANNOT_PARSE_ATTRIBUTE_VALUE", (Object)attrLocalName);
                            _LOG.warning((Throwable)iae);
                            continue;
                        }
                        _LOG.warning("CANNOT_PARSE_ATTRIBUTE_VALUE_NAMESPACE", new Object[]{attrLocalName, attrNamespace});
                        _LOG.warning((Throwable)iae);
                    }
                    continue;
                }
                this.logUnknownAttribute(context, attrNamespace, attrLocalName);
                continue;
            }
            otherNamespaces = true;
        }
        return otherNamespaces;
    }

    protected void logUnknownAttribute(ParseContext context, String namespaceURI, String localName) {
        if (_LOG.isWarning()) {
            if ("".equals(namespaceURI)) {
                _LOG.warning("UNKNOWN_ATTRIBUTE", (Object)localName);
            } else {
                _LOG.warning("UNKNOWN_ATTRIBUTE_NAMESPACE", new Object[]{localName, namespaceURI});
            }
        }
    }

    private static Object[] _getArray(PropertyDef def, List<Object> list) {
        Object[] array = (Object[])Array.newInstance(def.getPropertyType().getComponentType(), list.size());
        list.toArray(array);
        return array;
    }
}

