/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.bean;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.component.PartialStateHolder;
import javax.faces.component.StateHolder;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.bean.util.StateUtils;

public class AttachedObjects<K, T>
implements PartialStateHolder {
    private Map<K, List<T>> _objectMap = new HashMap<K, List<T>>(5, 1.0f);
    private Map<K, List<T>> _readOnlyObjectMap = null;
    private boolean _initialStateMarked = false;
    private boolean _transient = false;

    public final void addAttachedObject(K key, T obj) {
        List<T> objects = this._objectMap.get(key);
        if (objects == null) {
            objects = new ArrayList<T>(5);
            this._objectMap.put(key, objects);
        }
        objects.add(obj);
        if (this.initialStateMarked()) {
            this.clearInitialState();
        }
    }

    public final boolean removeAttachedObject(K key, T obj) {
        List<T> objects = this._objectMap.get(key);
        if (objects == null) {
            return false;
        }
        boolean removed = objects.remove(obj);
        if (removed && this.initialStateMarked()) {
            this.clearInitialState();
        }
        return removed;
    }

    public final List<T> getAttachedObjectList(K key) {
        List<T> objects = this._objectMap.get(key);
        if (objects == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(objects);
    }

    public final Map<K, List<T>> getAttachedObjectMap() {
        if (this._readOnlyObjectMap == null) {
            this._readOnlyObjectMap = Collections.unmodifiableMap(this._objectMap);
        }
        return this._readOnlyObjectMap;
    }

    public void markInitialState() {
        for (Map.Entry<K, List<T>> e : this._objectMap.entrySet()) {
            for (T obj : e.getValue()) {
                if (!(obj instanceof PartialStateHolder)) continue;
                ((PartialStateHolder)obj).markInitialState();
            }
        }
        this._initialStateMarked = true;
    }

    public void clearInitialState() {
        this._initialStateMarked = false;
        for (Map.Entry<K, List<T>> e : this._objectMap.entrySet()) {
            for (T obj : e.getValue()) {
                if (!(obj instanceof PartialStateHolder)) continue;
                ((PartialStateHolder)obj).clearInitialState();
            }
        }
    }

    public boolean initialStateMarked() {
        return this._initialStateMarked;
    }

    public Object saveState(FacesContext facesContext) {
        HashMap<K, Object[]> state = new HashMap<K, Object[]>(this._objectMap.size());
        for (Map.Entry<K, List<T>> e : this._objectMap.entrySet()) {
            List<T> l = e.getValue();
            Object[] entryState = new Object[l.size()];
            boolean stateWasSaved = false;
            int size = entryState.length;
            for (int i = 0; i < size; ++i) {
                T obj = l.get(i);
                if (this._initialStateMarked) {
                    if (obj instanceof StateHolder) {
                        entryState[i] = ((StateHolder)obj).saveState(facesContext);
                    }
                } else {
                    entryState[i] = StateUtils.saveStateHolder(facesContext, obj);
                }
                stateWasSaved = entryState[i] != null ? true : stateWasSaved;
            }
            if (!stateWasSaved) continue;
            state.put(e.getKey(), entryState);
        }
        Object[] savedState = null;
        if (!state.isEmpty()) {
            savedState = new Object[]{this._initialStateMarked, state};
        }
        return savedState;
    }

    public void restoreState(FacesContext facesContext, Object state) {
        if (state == null) {
            return;
        }
        Object[] stateArray = (Object[])state;
        boolean usePartialStateSaving = (Boolean)stateArray[0];
        Map savedState = (Map)stateArray[1];
        if (usePartialStateSaving) {
            for (Map.Entry e : savedState.entrySet()) {
                List<T> l = this._objectMap.get(e.getKey());
                Object[] entryState = (Object[])e.getValue();
                int size = entryState.length;
                for (int i = 0; i < size; ++i) {
                    T obj;
                    if (entryState[i] == null || !((obj = l.get(i)) instanceof StateHolder)) continue;
                    ((StateHolder)obj).restoreState(facesContext, entryState[i]);
                }
            }
        } else {
            this._objectMap.clear();
            for (Map.Entry e : savedState.entrySet()) {
                Object[] entryState = (Object[])e.getValue();
                ArrayList<Object> list = new ArrayList<Object>(entryState.length);
                int size = entryState.length;
                for (int i = 0; i < size; ++i) {
                    list.add(StateUtils.restoreStateHolder(facesContext, entryState[i]));
                }
                this._objectMap.put(e.getKey(), list);
            }
        }
    }

    public boolean isTransient() {
        return this._transient;
    }

    public void setTransient(boolean newTransientValue) {
        this._transient = newTransientValue;
    }
}

