/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.util;

import org.apache.myfaces.trinidad.util.Args;

public final class Range<C extends Comparable> {
    private final C _start;
    private final C _end;
    private static final Range<? extends Comparable> _EMPTY_RANGE = new Range<Object>(null, null);

    public static <C extends Comparable> Range<C> of(C start, C end) {
        Args.notNull(start, "start");
        Args.notNull(end, "end");
        if (start.compareTo(end) > 0) {
            return Range.emptyRange();
        }
        return new Range<C>(start, end);
    }

    public static <C extends Comparable> Range<C> emptyRange() {
        return _EMPTY_RANGE;
    }

    public C getStart() {
        return this._start;
    }

    public C getEnd() {
        return this._end;
    }

    public boolean isEmpty() {
        if (this._start == null) {
            assert (this._end == null);
            return true;
        }
        return false;
    }

    public boolean contains(C value) {
        if (this.isEmpty()) {
            return false;
        }
        return this._start.compareTo(value) <= 0 && this._end.compareTo(value) >= 0;
    }

    public Range<C> intersect(Range<C> otherRange) {
        C end;
        Args.notNull(otherRange, "otherRange");
        if (this.isEmpty() || otherRange.isEmpty()) {
            return Range.emptyRange();
        }
        C start = Range._max(this.getStart(), otherRange.getStart());
        if (start.compareTo(end = Range._min(this.getEnd(), otherRange.getEnd())) > 0) {
            return Range.emptyRange();
        }
        return new Range<C>(start, end);
    }

    private static <C extends Comparable> C _min(C c1, C c2) {
        return c1.compareTo(c2) > 0 ? c2 : c1;
    }

    private static <C extends Comparable> C _max(C c1, C c2) {
        return c1.compareTo(c2) < 0 ? c2 : c1;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this._start + " - " + this._end + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Range)) {
            return false;
        }
        Range otherRange = (Range)o;
        if (this.isEmpty() || otherRange.isEmpty()) {
            return this == o;
        }
        return this.getStart().equals(otherRange.getStart()) && this.getEnd().equals(otherRange.getEnd());
    }

    public int hashCode() {
        int result = 17;
        if (!this.isEmpty()) {
            assert (this._start != null);
            assert (this._end != null);
            result = 31 * result + this._start.hashCode();
            result = 31 * result + this._end.hashCode();
        }
        return result;
    }

    private Range(C start, C end) {
        this._start = start;
        this._end = end;
    }
}

