/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.style.util;

import java.util.Collection;
import org.apache.myfaces.trinidadinternal.style.xml.parse.StyleSheetNode;

public final class StyleSheetVisitUtils {
    public static StyleSheetVisitor compoundStyleSheetVisitor(Collection<? extends StyleSheetVisitor> visitors) {
        return new CompoundVisitor(visitors);
    }

    public static void visitStyleSheets(Iterable<StyleSheetNode> styleSheets, StyleSheetVisitor visitor) {
        assert (styleSheets != null);
        assert (visitor != null);
        for (StyleSheetNode styleSheet : styleSheets) {
            visitor.visit(styleSheet);
        }
    }

    private StyleSheetVisitUtils() {
    }

    private static final class CompoundVisitor
    implements StyleSheetVisitor {
        private final Collection<? extends StyleSheetVisitor> _visitors;

        public CompoundVisitor(Collection<? extends StyleSheetVisitor> visitors) {
            assert (visitors != null);
            this._visitors = visitors;
        }

        @Override
        public void visit(StyleSheetNode styleSheet) {
            for (StyleSheetVisitor styleSheetVisitor : this._visitors) {
                styleSheetVisitor.visit(styleSheet);
            }
        }
    }

    public static interface StyleSheetVisitor {
        public void visit(StyleSheetNode var1);
    }
}

