/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.skin;

import java.util.HashMap;
import java.util.Map;
import javax.el.ValueExpression;
import org.apache.myfaces.trinidad.skin.CustomMetadata;
import org.apache.myfaces.trinidad.skin.SkinFeatures;
import org.apache.myfaces.trinidad.skin.SkinVersion;

public final class SkinMetadata {
    private String _id;
    private String _family;
    private RenderKitId _renderKitId;
    private String _baseSkinId;
    private String _styleSheetName;
    private String _resourceBundleName;
    private ValueExpression _translationSource;
    private SkinVersion _version;
    private SkinFeatures _features;
    private CustomMetadata _metadata;

    private SkinMetadata(Builder builder) {
        this._id = builder._id;
        this._family = builder._family;
        this._version = builder._version == null ? SkinVersion.EMPTY_SKIN_VERSION : builder._version;
        this._renderKitId = builder._renderKitId == null ? RenderKitId.DESKTOP : builder._renderKitId;
        this._baseSkinId = builder._baseSkinId;
        this._styleSheetName = builder._styleSheetName;
        this._resourceBundleName = builder._resourceBundleName;
        this._translationSource = builder._translationSource;
        this._features = builder._features;
        this._metadata = builder._metadata;
    }

    public String getId() {
        return this._id;
    }

    public String getFamily() {
        return this._family;
    }

    public String getRenderKitId() {
        return this._renderKitId.id();
    }

    public SkinVersion getVersion() {
        return this._version;
    }

    public String getStyleSheetName() {
        return this._styleSheetName;
    }

    public String getResourceBundleName() {
        return this._resourceBundleName;
    }

    public ValueExpression getTranslationSource() {
        return this._translationSource;
    }

    public String getBaseSkinId() {
        return this._baseSkinId;
    }

    public SkinFeatures getFeatures() {
        return this._features;
    }

    public CustomMetadata getMetadata() {
        return this._metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SkinMetadata that = (SkinMetadata)o;
        if (this._id != null ? !this._id.equals(that._id) : that._id != null) {
            return false;
        }
        if (this._family != null ? !this._family.equals(that._family) : that._family != null) {
            return false;
        }
        if (this._renderKitId != null ? !this._renderKitId.equals((Object)that._renderKitId) : that._renderKitId != null) {
            return false;
        }
        if (this._resourceBundleName != null ? !this._resourceBundleName.equals(that._resourceBundleName) : that._resourceBundleName != null) {
            return false;
        }
        if (this._styleSheetName != null ? !this._styleSheetName.equals(that._styleSheetName) : that._styleSheetName != null) {
            return false;
        }
        if (this._translationSource != null ? !this._translationSource.equals((Object)that._translationSource) : that._translationSource != null) {
            return false;
        }
        if (this._version != null ? !this._version.equals(that._version) : that._version != null) {
            return false;
        }
        if (this._baseSkinId != null ? !this._baseSkinId.equals(that._baseSkinId) : that._baseSkinId != null) {
            return false;
        }
        if (this._features != null ? !this._features.equals(that._features) : that._features != null) {
            return false;
        }
        return !(this._metadata != null ? !this._metadata.equals(that._metadata) : that._metadata != null);
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (null == this._id ? 0 : this._id.hashCode());
        result = 37 * result + (null == this._family ? 0 : this._family.hashCode());
        result = 37 * result + (null == this._renderKitId ? 0 : this._renderKitId.hashCode());
        result = 37 * result + (null == this._version ? 0 : this._version.hashCode());
        result = 37 * result + (null == this._resourceBundleName ? 0 : this._resourceBundleName.hashCode());
        result = 37 * result + (null == this._translationSource ? 0 : this._translationSource.hashCode());
        result = 37 * result + (null == this._styleSheetName ? 0 : this._styleSheetName.hashCode());
        result = 37 * result + (null == this._baseSkinId ? 0 : this._baseSkinId.hashCode());
        result = 37 * result + (null == this._features ? 0 : this._features.hashCode());
        result = 37 * result + (null == this._metadata ? 0 : this._metadata.hashCode());
        return result;
    }

    public String toString() {
        StringBuilder toString = new StringBuilder("SkinMetadata [");
        if (this._id != null) {
            toString.append("Id: ").append(this._id).append(", ");
        }
        if (this._family != null) {
            toString.append("Family: ").append(this._family).append(", ");
        }
        if (this._renderKitId != null) {
            toString.append("RenderKitId: ").append((Object)this._renderKitId).append(", ");
        }
        if (this._version != SkinVersion.EMPTY_SKIN_VERSION) {
            toString.append("Version: ").append(this._version).append(", ");
        }
        if (this._resourceBundleName != null) {
            toString.append("ResourceBundleName: ").append(this._resourceBundleName).append(", ");
        }
        if (this._styleSheetName != null) {
            toString.append("StyleSheetName: ").append(this._styleSheetName).append(", ");
        }
        if (this._translationSource != null) {
            toString.append("TranslationSource: ").append(this._translationSource).append(", ");
        }
        if (this._baseSkinId != null) {
            toString.append("BaseSkinId: ").append(this._baseSkinId).append(", ");
        }
        if (this._features != null && !this._features.isEmpty()) {
            toString.append(this._features).append(", ");
        }
        if (this._metadata != null && !this._metadata.isEmpty()) {
            toString.append(this._metadata).append(", ");
        }
        toString.append(']');
        return toString.toString();
    }

    public static class Builder {
        private String _id;
        private String _family;
        private RenderKitId _renderKitId;
        private String _styleSheetName;
        private String _resourceBundleName;
        private ValueExpression _translationSource;
        private String _baseSkinId;
        private SkinVersion _version;
        private SkinFeatures _features = new SkinFeatures();
        private CustomMetadata _metadata = new CustomMetadata();

        public Builder id(String id) {
            this._id = id;
            return this;
        }

        public Builder family(String family) {
            this._family = family;
            return this;
        }

        public Builder renderKitId(RenderKitId renderKitId) {
            this._renderKitId = renderKitId;
            return this;
        }

        public Builder styleSheetName(String styleSheetName) {
            this._styleSheetName = styleSheetName;
            return this;
        }

        public Builder resourceBundleName(String resourceBundleName) {
            this._resourceBundleName = resourceBundleName;
            return this;
        }

        public Builder translationSource(ValueExpression translationSource) {
            this._translationSource = translationSource;
            return this;
        }

        public Builder baseSkinId(String baseSkinId) {
            this._baseSkinId = baseSkinId;
            return this;
        }

        public Builder version(SkinVersion version) {
            this._version = version;
            return this;
        }

        public Builder features(SkinFeatures features) {
            if (features != null) {
                this._features = features;
            }
            return this;
        }

        public Builder metadata(CustomMetadata metadata) {
            if (metadata != null) {
                this._metadata = metadata;
            }
            return this;
        }

        public SkinMetadata build() {
            return new SkinMetadata(this);
        }
    }

    public static enum RenderKitId {
        DESKTOP("org.apache.myfaces.trinidad.desktop"),
        PDA("org.apache.myfaces.trinidad.pda"),
        PORTLET("portlet");

        private static final Map<String, RenderKitId> ID_TO_RENDER_KIT;
        private final String _id;

        private RenderKitId(String id) {
            if (id == null) {
                throw new NullPointerException();
            }
            this._id = id;
        }

        public String id() {
            return this._id;
        }

        public String toString() {
            return this._id;
        }

        public static RenderKitId fromId(String id) {
            if (id == null) {
                return null;
            }
            RenderKitId renderKit = ID_TO_RENDER_KIT.get(id);
            if (renderKit == null) {
                throw new IllegalArgumentException();
            }
            return renderKit;
        }

        static {
            ID_TO_RENDER_KIT = new HashMap<String, RenderKitId>();
            RenderKitId[] instances = (RenderKitId[])RenderKitId.class.getEnumConstants();
            for (int i = 0; i < instances.length; ++i) {
                ID_TO_RENDER_KIT.put(instances[i].toString(), instances[i]);
            }
        }
    }
}

