/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.context;

import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidadinternal.util.FrameBustingUtils;

public class TrinidadPhaseListener
implements PhaseListener {
    public static final String INITIAL_VIEW_ROOT_KEY = "org.apache.myfaces.trinidadinternal.InitialViewRoot";
    private static final String _POSTBACK_KEY = "org.apache.myfaces.trinidadinternal.context.AdfFacesPhaseListener.POSTBACK";
    private static final long serialVersionUID = 1234567L;

    public static boolean isPostback(FacesContext context) {
        return !Boolean.FALSE.equals(context.getExternalContext().getRequestMap().get(_POSTBACK_KEY));
    }

    public static void markPostback(FacesContext context) {
        context.getExternalContext().getRequestMap().remove(_POSTBACK_KEY);
    }

    public void afterPhase(PhaseEvent event) {
        FacesContext context = event.getFacesContext();
        if (event.getPhaseId() == PhaseId.RESTORE_VIEW) {
            context.getExternalContext().getRequestMap().put(INITIAL_VIEW_ROOT_KEY, context.getViewRoot());
        }
    }

    public void beforePhase(PhaseEvent event) {
        FacesContext context;
        FrameBustingUtils.FrameBustingParamValue frameBusting;
        PhaseId phaseId = event.getPhaseId();
        if (phaseId == PhaseId.RESTORE_VIEW) {
            FacesContext context2 = event.getFacesContext();
            ExternalContext ec = context2.getExternalContext();
            ec.getRequestMap().put(_POSTBACK_KEY, Boolean.FALSE);
        } else if (phaseId == PhaseId.APPLY_REQUEST_VALUES) {
            FacesContext context3 = event.getFacesContext();
            TrinidadPhaseListener.markPostback(context3);
        } else if (phaseId == PhaseId.RENDER_RESPONSE && !FrameBustingUtils.FrameBustingParamValue.FRAME_BUSTING_NEVER.equals((Object)(frameBusting = FrameBustingUtils.getFrameBustingValue(context = event.getFacesContext(), RequestContext.getCurrentInstance())))) {
            String xFrameOptions = FrameBustingUtils.FrameBustingParamValue.FRAME_BUSTING_ALWAYS.equals((Object)frameBusting) ? "deny" : "sameorigin";
            context.getExternalContext().addResponseHeader("X-Frame-Options", xFrameOptions);
        }
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }
}

