/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.pages;

import java.util.Calendar;
import java.util.Date;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.component.core.input.CoreChooseDate;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.pages.CalendarDialogJSP;

class CalendarUtils {
    public static CoreChooseDate createChooseDate(FacesContext context) {
        String displayTimeString;
        String selectedTimeString;
        String maxTimeString;
        final String id = CalendarDialogJSP.__getParam(context, "source");
        CoreChooseDate ccd = new CoreChooseDate(){

            public String getClientId(FacesContext context) {
                return id;
            }
        };
        String minTimeString = CalendarDialogJSP.__getParam(context, "minValue");
        if (minTimeString != null) {
            ccd.setMinValue(CalendarUtils.parseTime(minTimeString));
        }
        if ((maxTimeString = CalendarDialogJSP.__getParam(context, "maxValue")) != null) {
            ccd.setMaxValue(CalendarUtils.parseTime(maxTimeString));
        }
        if ((selectedTimeString = CalendarDialogJSP.__getParam(context, "value")) != null) {
            ccd.getAttributes().put("value", CalendarUtils.parseTime(selectedTimeString));
        }
        if ((displayTimeString = CalendarDialogJSP.__getParam(context, "scrolledValue")) != null) {
            ccd.getAttributes().put("scrolledValue", CalendarUtils.parseTime(displayTimeString));
        }
        return ccd;
    }

    private static Date parseTime(String timeString) {
        if (timeString == null || timeString.equals("")) {
            return null;
        }
        try {
            int colonIndex = timeString.indexOf(58);
            if (colonIndex > 0) {
                long start = Long.parseLong(timeString.substring(0, colonIndex));
                timeString = Long.toString(start + 1L) + "0" + timeString.substring(colonIndex + 1);
            }
            return new Date(CalendarUtils._adjustTimeZone(Long.parseLong(timeString)));
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    private static long _adjustTimeZone(long dateValueInMs) {
        Calendar clientCal = Calendar.getInstance(RenderingContext.getCurrentInstance().getLocaleContext().getTimeZone());
        clientCal.setTimeInMillis(dateValueInMs);
        long tzOffset = clientCal.get(15) + clientCal.get(16);
        Calendar serverCal = Calendar.getInstance();
        serverCal.setTimeInMillis(dateValueInMs);
        tzOffset = (tzOffset -= (long)(serverCal.get(15) + serverCal.get(16))) < 0L ? (long)Math.max((float)tzOffset, -9.223372E18f - (float)dateValueInMs) : (long)Math.min((float)tzOffset, 9.223372E18f - (float)dateValueInMs);
        return dateValueInMs + tzOffset;
    }

    private CalendarUtils() {
    }
}

