/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.skin;

import java.util.concurrent.ConcurrentMap;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.skin.Skin;
import org.apache.myfaces.trinidad.util.Args;
import org.apache.myfaces.trinidad.util.ToStringHelper;
import org.apache.myfaces.trinidadinternal.skin.DocumentProviderSkin;
import org.apache.myfaces.trinidadinternal.skin.RequestSkinWrapper;
import org.apache.myfaces.trinidadinternal.skin.SkinImpl;
import org.apache.myfaces.trinidadinternal.style.StyleContext;
import org.apache.myfaces.trinidadinternal.style.StyleProvider;
import org.apache.myfaces.trinidadinternal.style.cache.FileSystemStyleCache;
import org.apache.myfaces.trinidadinternal.style.xml.StyleSheetDocumentUtils;
import org.apache.myfaces.trinidadinternal.style.xml.parse.StyleSheetDocument;
import org.apache.myfaces.trinidadinternal.util.CopyOnWriteArrayMap;

public class SkinStyleProvider
extends FileSystemStyleCache {
    private Skin _skin;
    private StyleSheetDocument _skinDocument;
    private static final String _SKIN_PROVIDERS_KEY = "org.apache.myfaces.trinidadinternal.skin.SKIN_PROVIDERS_KEY";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(SkinStyleProvider.class);
    private static final String _MAX_SKINS_CACHED = "org.apache.myfaces.trinidad.skin.MAX_SKINS_CACHED";
    private static final int _MAX_SKINS_CACHED_DEFAULT = 20;

    public static StyleProvider getSkinStyleProvider(Skin skin, String targetDirectoryPath) throws IllegalArgumentException {
        if (skin == null) {
            throw new IllegalArgumentException(_LOG.getMessage("NO_SKIN_SPECIFIED"));
        }
        if (skin instanceof RequestSkinWrapper) {
            skin = ((RequestSkinWrapper)skin).getWrappedSkin();
        }
        ProviderKey key = new ProviderKey(skin, targetDirectoryPath);
        ConcurrentMap<ProviderKey, StyleProvider> providers = SkinStyleProvider._getProviders();
        StyleProvider provider = (StyleProvider)providers.get(key);
        if (provider != null) {
            _LOG.fine("Style provider served from cache {0}", (Object)provider);
            return provider;
        }
        provider = new SkinStyleProvider(skin, targetDirectoryPath);
        boolean cacheStyleProvider = true;
        boolean logStyleProviderCreated = false;
        if (skin instanceof SkinImpl && !((SkinImpl)skin).isCacheable()) {
            cacheStyleProvider = false;
            logStyleProviderCreated = true;
        }
        if (cacheStyleProvider) {
            StyleProvider existing = providers.putIfAbsent(key, provider);
            if (existing != null) {
                provider = existing;
            } else {
                logStyleProviderCreated = true;
            }
        }
        if (logStyleProviderCreated && _LOG.isFine()) {
            _LOG.fine("Create a new SkinStyleProvider for skin {0} and targetDirectoryPath {1}. Skin cacheability is: {2}", new Object[]{skin.getId(), targetDirectoryPath, cacheStyleProvider});
        }
        return provider;
    }

    public String toString() {
        return new ToStringHelper((Object)this).append("skinId", (Object)this._skin.getId()).toString();
    }

    protected SkinStyleProvider(Skin skin, String targetDirectoryPath) throws IllegalArgumentException {
        super(targetDirectoryPath);
        if (skin == null) {
            throw new IllegalArgumentException(_LOG.getMessage("NO_SKIN_SPECIFIED"));
        }
        this._skin = skin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected StyleSheetDocument createStyleSheetDocument(StyleContext context) {
        StyleSheetDocument customDocument = super.createStyleSheetDocument(context);
        StyleSheetDocument skinDocument = null;
        SkinStyleProvider skinStyleProvider = this;
        synchronized (skinStyleProvider) {
            skinDocument = this._skinDocument = ((DocumentProviderSkin)this._skin).getStyleSheetDocument(context);
        }
        return StyleSheetDocumentUtils.mergeStyleSheetDocuments(skinDocument, customDocument);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean hasSourceDocumentChanged(StyleContext context) {
        if (super.hasSourceDocumentChanged(context)) {
            return true;
        }
        SkinStyleProvider skinStyleProvider = this;
        synchronized (skinStyleProvider) {
            return this._skinDocument != ((DocumentProviderSkin)this._skin).getStyleSheetDocument(context);
        }
    }

    @Override
    protected String getTargetStyleSheetName(StyleContext context, StyleSheetDocument document) {
        String name = super.getTargetStyleSheetName(context, document);
        String id = this._skin.getId();
        if (id != null) {
            StringBuffer buffer = new StringBuffer(id.length() + name.length() + 1);
            buffer.append(id.replace('.', '-'));
            buffer.append('-');
            buffer.append(name);
            return buffer.toString();
        }
        return name;
    }

    private static ConcurrentMap<ProviderKey, StyleProvider> _getProviders() {
        ConcurrentMap<ProviderKey, StyleProvider> oldStyleProviders;
        ConcurrentMap appMap = RequestContext.getCurrentInstance().getApplicationScopedConcurrentMap();
        ConcurrentMap<ProviderKey, StyleProvider> styleProviders = (ConcurrentMap<ProviderKey, StyleProvider>)appMap.get(_SKIN_PROVIDERS_KEY);
        if (styleProviders == null && (oldStyleProviders = appMap.putIfAbsent(_SKIN_PROVIDERS_KEY, styleProviders = SkinStyleProvider._createProvidersCache())) != null) {
            styleProviders = oldStyleProviders;
        }
        return styleProviders;
    }

    private static ConcurrentMap<ProviderKey, StyleProvider> _createProvidersCache() {
        return CopyOnWriteArrayMap.newLRUConcurrentMap(SkinStyleProvider._getCacheSize());
    }

    private static int _getCacheSize() {
        FacesContext context = FacesContext.getCurrentInstance();
        String lruCacheSize = context.getExternalContext().getInitParameter(_MAX_SKINS_CACHED);
        int lruCacheSizeInt = 20;
        boolean invalidInt = false;
        if (lruCacheSize != null && !lruCacheSize.isEmpty()) {
            try {
                lruCacheSizeInt = Integer.parseInt(lruCacheSize);
            }
            catch (NumberFormatException nfe) {
                invalidInt = true;
            }
            if (lruCacheSizeInt <= 0) {
                invalidInt = true;
            }
        }
        if (invalidInt) {
            if (_LOG.isWarning()) {
                _LOG.warning("INVALID_INTEGER_MAX_SKINS_CACHED", new Object[]{lruCacheSize, 20});
            }
            lruCacheSizeInt = 20;
        }
        return lruCacheSizeInt;
    }

    private static class ProviderKey {
        private final String _skinId;
        private final String _targetDirectoryPath;

        public ProviderKey(Skin skin, String targetDirectoryPath) {
            Args.notNull((Object)skin, (String)"skin");
            Args.notNull((Object)targetDirectoryPath, (String)"targetDirectoryPath");
            this._skinId = skin.getId();
            this._targetDirectoryPath = targetDirectoryPath;
        }

        public String toString() {
            return new ToStringHelper((Object)this).append("skinId", (Object)this._skinId).append("targetDirectoryPath", (Object)this._targetDirectoryPath).toString();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProviderKey)) {
                return false;
            }
            ProviderKey key = (ProviderKey)o;
            return this._equals(this._skinId, key._skinId) && this._equals(this._targetDirectoryPath, key._targetDirectoryPath);
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + this._skinId.hashCode();
            result = 37 * result + this._targetDirectoryPath.hashCode();
            return result;
        }

        private boolean _equals(Object o1, Object o2) {
            if (o1 == null) {
                return o1 == o2;
            }
            return o1.equals(o2);
        }
    }
}

