/*
 * Decompiled with CFR 0.152.
 */
package org.apache.netbeans.nbpackage;

import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.Optional;

public enum Architecture {
    X86_64("x86_64", "x86-64", "amd64", "x64"),
    AARCH64("aarch64", "arm64");

    private final List<String> synonyms;

    private Architecture(String ... synonyms) {
        this.synonyms = List.of(synonyms);
    }

    public List<String> synonyms() {
        return this.synonyms;
    }

    public boolean isSynonym(String arch) {
        return this.synonyms.contains(arch.toLowerCase(Locale.ROOT));
    }

    public static Optional<Architecture> detectFromPath(Path path) {
        String fileName = path.getFileName().toString().toLowerCase(Locale.ROOT);
        for (Architecture arch : Architecture.values()) {
            for (String synonym : arch.synonyms()) {
                if (!fileName.contains(synonym)) continue;
                return Optional.of(arch);
            }
        }
        return Optional.empty();
    }
}

