/*
 * Decompiled with CFR 0.152.
 */
package org.apache.netbeans.nbpackage.rpm;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermissions;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.netbeans.nbpackage.AbstractPackagerTask;
import org.apache.netbeans.nbpackage.Architecture;
import org.apache.netbeans.nbpackage.ExecutionContext;
import org.apache.netbeans.nbpackage.FileUtils;
import org.apache.netbeans.nbpackage.NBPackage;
import org.apache.netbeans.nbpackage.StringUtils;
import org.apache.netbeans.nbpackage.rpm.RpmPackager;

class RpmTask
extends AbstractPackagerTask {
    private static final String RPM = "rpm";
    private static final String RPMBUILD = "rpmbuild";
    private static final String ARCH_AARCH64 = "aarch64";
    private static final String ARCH_NOARCH = "noarch";
    private static final String ARCH_X86_64 = "x86_64";
    private String packageName;
    private String packageVersion;
    private String packageArch;

    RpmTask(ExecutionContext context) {
        super(context);
    }

    @Override
    protected void checkPackageRequirements() throws Exception {
        this.validateTools(RPM, RPMBUILD);
    }

    @Override
    protected void customizeImage(Path image) throws Exception {
        String pkgName = this.packageName();
        String base = "usr";
        Path baseDir = image.resolve(base);
        Path appDir = baseDir.resolve("lib").resolve(pkgName);
        Files.move(baseDir.resolve("lib").resolve("APPDIR"), appDir, new CopyOption[0]);
        String execName = this.findLauncher(appDir.resolve("bin")).getFileName().toString();
        String packageLocation = "/" + base + "/lib/" + pkgName;
        Path binDir = baseDir.resolve("bin");
        Files.createDirectories(binDir, new FileAttribute[0]);
        this.setupLauncher(binDir, packageLocation, execName);
        Path share = baseDir.resolve("share");
        Files.createDirectories(share, new FileAttribute[0]);
        this.setupIcons(share, pkgName);
        Path desktopFile = this.setupDesktopFile(share, "/" + base + "/bin/" + execName, pkgName);
        Path buildRootDir = image.resolve("BUILDROOT");
        Files.createDirectories(buildRootDir, new FileAttribute[0]);
        String buildName = this.packageName() + "-" + this.packageVersion() + "-0." + this.packageArch();
        Path buildNameDir = buildRootDir.resolve(buildName);
        Files.createDirectories(buildNameDir, new FileAttribute[0]);
        Path buildUsrDir = buildNameDir.resolve(base);
        Files.move(baseDir, buildUsrDir, new CopyOption[0]);
        Path rpmsDir = image.resolve("RPMS");
        Files.createDirectories(rpmsDir, new FileAttribute[0]);
    }

    @Override
    protected void finalizeImage(Path image) throws Exception {
        this.setupSpecFile(image);
    }

    @Override
    protected Path buildPackage(Path image) throws Exception {
        Path rpmFile;
        Path spec = image.resolve("SPECS").resolve(this.packageName() + ".spec");
        int result = this.context().exec(RPMBUILD, "--target", this.packageArch(), "--define", "_topdir " + image.toAbsolutePath().toString(), "-bb", spec.toAbsolutePath().toString(), "--noclean");
        if (result != 0) {
            throw new Exception();
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(image.resolve("RPMS").resolve(this.packageArch()), "*.rpm");){
            Iterator<Path> itr = stream.iterator();
            if (!itr.hasNext()) {
                throw new Exception(image.toString());
            }
            rpmFile = itr.next();
        }
        Path output = this.context().destination().resolve(rpmFile.getFileName());
        Files.move(rpmFile, output, new CopyOption[0]);
        return output;
    }

    @Override
    protected String calculateImageName(Path input) throws Exception {
        return this.packageName() + "-" + this.packageVersion() + "." + this.packageArch();
    }

    @Override
    protected Path calculateAppPath(Path image) throws Exception {
        return image.resolve("usr").resolve("lib").resolve("APPDIR");
    }

    @Override
    protected Path calculateRootPath(Path image) throws Exception {
        List<Path> builds = FileUtils.find(image, "BUILDROOT/*");
        if (builds.size() != 1) {
            throw new IOException(builds.toString());
        }
        return builds.get(0);
    }

    private void validateTools(String ... tools) throws Exception {
        if (this.context().isVerbose()) {
            this.context().infoHandler().accept(MessageFormat.format(RpmPackager.MESSAGES.getString("message.validatingtools"), Arrays.toString(tools)));
        }
        for (String tool : tools) {
            if (this.context().exec(List.of("which", tool)) == 0) continue;
            throw new IllegalStateException(RpmPackager.MESSAGES.getString("message.missingrpmtools"));
        }
    }

    private String packageName() {
        if (this.packageName == null) {
            String name = this.sanitize(this.context().getValue(NBPackage.PACKAGE_NAME).orElseThrow());
            if (name.length() < 2 || !Character.isLetter(name.charAt(0))) {
                throw new IllegalArgumentException();
            }
            this.packageName = name;
        }
        return this.packageName;
    }

    private String packageVersion() {
        if (this.packageVersion == null) {
            String version;
            this.packageVersion = version = this.sanitizeVersion(this.context().getValue(NBPackage.PACKAGE_VERSION).orElse("1.0"));
        }
        return this.packageVersion;
    }

    private String packageArch() {
        if (this.packageArch == null) {
            this.packageArch = this.context().getValue(NBPackage.PACKAGE_ARCH).orElseGet(() -> {
                Optional<Path> runtime = this.context().getValue(NBPackage.PACKAGE_RUNTIME);
                if (runtime.isPresent()) {
                    return Architecture.detectFromPath(runtime.get()).map(a -> switch (a) {
                        default -> throw new IncompatibleClassChangeError();
                        case Architecture.AARCH64 -> ARCH_AARCH64;
                        case Architecture.X86_64 -> ARCH_X86_64;
                    }).orElseGet(() -> {
                        this.context().warningHandler().accept(RpmPackager.MESSAGES.getString("message.unknownarch"));
                        return ARCH_NOARCH;
                    });
                }
                return ARCH_NOARCH;
            });
        }
        return this.packageArch;
    }

    private String sanitize(String text) {
        return text.toLowerCase(Locale.ROOT).replaceAll("[^a-z0-9\\+\\-\\.]", "-");
    }

    private String sanitizeVersion(String text) {
        return text.toLowerCase(Locale.ROOT).replaceAll("[^a-z0-9\\+\\.\\~]", "~");
    }

    private Path findLauncher(Path binDir) throws IOException {
        try (Stream<Path> files = Files.list(binDir);){
            Path path = files.filter(f -> !f.getFileName().toString().endsWith(".exe")).findFirst().orElseThrow(IOException::new);
            return path;
        }
    }

    private void setupLauncher(Path binDir, String packageLocation, String execName) throws IOException {
        String template = RpmPackager.LAUNCHER_TEMPLATE.load(this.context());
        String script = StringUtils.replaceTokens(template, Map.of("PACKAGE", packageLocation, "EXEC", execName));
        Path bin = binDir.resolve(execName);
        Files.writeString(bin, (CharSequence)script, StandardOpenOption.CREATE_NEW);
        try {
            Files.setPosixFilePermissions(bin, PosixFilePermissions.fromString("rwxr-xr-x"));
        }
        catch (UnsupportedOperationException ex) {
            this.context().warningHandler().accept("UnsupportedOperationException : PosixFilePermissions");
        }
    }

    private void setupIcons(Path share, String pkgName) throws IOException {
        Path iconDir = share.resolve("icons").resolve("hicolor").resolve("48x48").resolve("apps");
        Path svgDir = share.resolve("icons").resolve("hicolor").resolve("scalable").resolve("apps");
        Path icon = this.context().getValue(RpmPackager.ICON_PATH).orElse(null);
        Path svg = this.context().getValue(RpmPackager.SVG_ICON_PATH).orElse(null);
        if (svg != null && icon == null) {
            this.context().warningHandler().accept(RpmPackager.MESSAGES.getString("message.svgnoicon"));
            svg = null;
        }
        Files.createDirectories(iconDir, new FileAttribute[0]);
        if (icon != null) {
            Files.copy(icon, iconDir.resolve(pkgName + ".png"), new CopyOption[0]);
        } else {
            Files.copy(this.getClass().getResourceAsStream("/org/apache/netbeans/nbpackage/apache-netbeans-48x48.png"), iconDir.resolve(pkgName + ".png"), new CopyOption[0]);
        }
        if (svg != null) {
            Files.createDirectories(svgDir, new FileAttribute[0]);
            Files.copy(svg, svgDir.resolve(pkgName + ".svg"), new CopyOption[0]);
        } else if (icon == null) {
            Files.createDirectories(svgDir, new FileAttribute[0]);
            Files.copy(this.getClass().getResourceAsStream("/org/apache/netbeans/nbpackage/apache-netbeans.svg"), svgDir.resolve(pkgName + ".svg"), new CopyOption[0]);
        }
    }

    private Path setupDesktopFile(Path share, String exec, String pkgName) throws IOException {
        String template = RpmPackager.DESKTOP_TEMPLATE.load(this.context());
        Map<String, String> tokens = Map.of("EXEC", exec, "ICON", pkgName);
        String desktop = StringUtils.replaceTokens(template, key -> {
            String ret = (String)tokens.get(key);
            if (ret != null) {
                return ret;
            }
            return this.context().tokenReplacementFor((String)key);
        });
        Path desktopDir = share.resolve("applications");
        Files.createDirectories(desktopDir, new FileAttribute[0]);
        String desktopFileName = this.context().getValue(RpmPackager.DESKTOP_FILENAME).map(name -> this.sanitize((String)name)).orElse(pkgName);
        Path desktopFile = desktopDir.resolve(desktopFileName + ".desktop");
        Files.writeString(desktopFile, (CharSequence)desktop, StandardOpenOption.CREATE_NEW);
        return desktopFile;
    }

    private void setupSpecFile(Path image) throws Exception {
        String template = RpmPackager.SPEC_TEMPLATE.load(this.context());
        String fileList = this.buildSpecFilesList(image);
        String spec = StringUtils.replaceTokens(template, Map.ofEntries(Map.entry("RPM_PACKAGE", this.packageName()), Map.entry("RPM_VERSION", this.packageVersion()), Map.entry("RPM_ARCH", this.packageArch()), Map.entry("RPM_SUMMARY_LINE", this.context().getValue(NBPackage.PACKAGE_DESCRIPTION).map(value -> "Summary: " + value).orElse("")), Map.entry("RPM_LICENSE_LINE", this.context().getValue(RpmPackager.RPM_LICENSE).map(value -> "License: " + value).orElse("")), Map.entry("RPM_GROUP_LINE", this.context().getValue(RpmPackager.RPM_GROUP).map(value -> "Group: " + value).orElse("")), Map.entry("RPM_URL_LINE", this.context().getValue(NBPackage.PACKAGE_URL).map(value -> "URL: " + String.valueOf(value)).orElse("")), Map.entry("RPM_VENDOR_LINE", this.context().getValue(NBPackage.PACKAGE_PUBLISHER).map(value -> "Vendor: " + value).orElse("")), Map.entry("RPM_MAINTAINER_LINE", this.context().getValue(RpmPackager.RPM_MAINTAINER).map(value -> "Packager: " + value).orElse("")), Map.entry("RPM_RECOMMENDS_LINE", this.context().getValue(NBPackage.PACKAGE_RUNTIME).map(value -> "").orElse("Recommends: java-devel >= 17")), Map.entry("RPM_DESCRIPTION", this.context().getValue(NBPackage.PACKAGE_DESCRIPTION).orElse("")), Map.entry("RPM_FILES", fileList)));
        Path specsDir = image.resolve("SPECS");
        Files.createDirectories(specsDir, new FileAttribute[0]);
        Path specFile = specsDir.resolve(this.packageName + ".spec");
        Files.writeString(specFile, (CharSequence)spec, StandardOpenOption.CREATE_NEW);
    }

    private String buildSpecFilesList(Path image) throws IOException {
        List<Path> builds = FileUtils.find(image, "BUILDROOT/*");
        if (builds.size() != 1) {
            throw new IOException(builds.toString());
        }
        Path root = builds.get(0);
        Path appParent = root.resolve("usr").resolve("lib");
        try (Stream<Path> stream = Files.find(root, Integer.MAX_VALUE, (file, attr) -> {
            if (file.equals(root)) {
                return false;
            }
            if (attr.isDirectory()) {
                return file.getParent().equals(appParent);
            }
            return !file.startsWith(appParent);
        }, new FileVisitOption[0]);){
            String string = stream.map(path -> root.relativize((Path)path)).sorted().map(Path::toString).map(p -> "/" + p).collect(Collectors.joining("\n", "", "\n"));
            return string;
        }
    }
}

