/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.bootstrap.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.minifi.bootstrap.SensitiveProperty;
import org.apache.nifi.minifi.properties.BootstrapProperties;
import org.apache.nifi.minifi.properties.BootstrapPropertiesLoader;
import org.apache.nifi.util.file.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootstrapFileProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(BootstrapFileProvider.class);
    private static final String MINIFI_PID_FILE_NAME = "minifi.pid";
    private static final String MINIFI_STATUS_FILE_NAME = "minifi.status";
    private static final String MINIFI_LOCK_FILE_NAME = "minifi.lock";
    private static final String DEFAULT_CONFIG_FILE = "./conf/bootstrap.conf";
    private static final String BOOTSTRAP_CONFIG_FILE_SYSTEM_PROPERTY_KEY = "org.apache.nifi.minifi.bootstrap.config.file";
    private static final String MINIFI_HOME_ENV_VARIABLE_KEY = "MINIFI_HOME";
    private static final String MINIFI_PID_DIR_PROP = "org.apache.nifi.minifi.bootstrap.config.pid.dir";
    private static final String DEFAULT_PID_DIR = "bin";
    private final File bootstrapConfigFile;

    public BootstrapFileProvider(File bootstrapConfigFile) {
        if (bootstrapConfigFile == null || !bootstrapConfigFile.exists()) {
            throw new IllegalArgumentException("The specified bootstrap file doesn't exists: " + String.valueOf(bootstrapConfigFile));
        }
        this.bootstrapConfigFile = bootstrapConfigFile;
    }

    public String getBootstrapFilePath() {
        return this.bootstrapConfigFile.getAbsolutePath();
    }

    public static File getBootstrapConfFile() {
        File bootstrapConfigFile = Optional.ofNullable(System.getProperty(BOOTSTRAP_CONFIG_FILE_SYSTEM_PROPERTY_KEY)).map(File::new).orElseGet(() -> Optional.ofNullable(System.getenv(MINIFI_HOME_ENV_VARIABLE_KEY)).map(File::new).map(nifiHomeFile -> new File((File)nifiHomeFile, DEFAULT_CONFIG_FILE)).orElseGet(() -> new File(DEFAULT_CONFIG_FILE)));
        LOGGER.debug("Bootstrap config file: {}", (Object)bootstrapConfigFile);
        return bootstrapConfigFile;
    }

    public File getPidFile() throws IOException {
        return this.getBootstrapFile(MINIFI_PID_FILE_NAME);
    }

    public File getStatusFile() throws IOException {
        return this.getBootstrapFile(MINIFI_STATUS_FILE_NAME);
    }

    public File getLockFile() throws IOException {
        return this.getBootstrapFile(MINIFI_LOCK_FILE_NAME);
    }

    public File getReloadLockFile() {
        File confDir = this.bootstrapConfigFile.getParentFile();
        File nifiHome = confDir.getParentFile();
        File bin = new File(nifiHome, DEFAULT_PID_DIR);
        File reloadFile = new File(bin, "minifi.reload.lock");
        LOGGER.debug("Reload File: {}", (Object)reloadFile);
        return reloadFile;
    }

    public File getBootstrapConfSwapFile() {
        File confDir = this.bootstrapConfigFile.getParentFile();
        File swapFile = new File(confDir, "bootstrap-swap.conf");
        LOGGER.debug("Bootstrap Swap File: {}", (Object)swapFile);
        return swapFile;
    }

    public File getBootstrapConfNewFile() {
        File confDir = this.bootstrapConfigFile.getParentFile();
        File newFile = new File(confDir, "bootstrap-updated.conf");
        LOGGER.debug("Bootstrap new File: {}", (Object)newFile);
        return newFile;
    }

    public BootstrapProperties getBootstrapProperties() {
        return BootstrapPropertiesLoader.load((File)this.bootstrapConfigFile);
    }

    public BootstrapProperties getProtectedBootstrapProperties() {
        return BootstrapPropertiesLoader.loadProtectedProperties((File)this.bootstrapConfigFile);
    }

    public Properties getStatusProperties() {
        Properties props = new Properties();
        try {
            File statusFile = this.getStatusFile();
            if (statusFile == null || !statusFile.exists()) {
                LOGGER.debug("No status file to load properties from");
                return props;
            }
            try (FileInputStream fis = new FileInputStream(statusFile);){
                props.load(fis);
            }
        }
        catch (IOException exception) {
            LOGGER.error("Failed to load MiNiFi status properties");
        }
        this.logProperties("MiNiFi status", props);
        return props;
    }

    public synchronized void saveStatusProperties(Properties minifiProps) throws IOException {
        File statusFile;
        String pid = minifiProps.getProperty("pid");
        if (!StringUtils.isBlank((CharSequence)pid)) {
            this.writePidFile(pid);
        }
        if ((statusFile = this.getStatusFile()).exists() && !statusFile.delete()) {
            LOGGER.warn("Failed to delete {}", (Object)statusFile);
        }
        if (!statusFile.createNewFile()) {
            throw new IOException("Failed to create file " + String.valueOf(statusFile));
        }
        try {
            HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
            perms.add(PosixFilePermission.OWNER_WRITE);
            perms.add(PosixFilePermission.OWNER_READ);
            perms.add(PosixFilePermission.GROUP_READ);
            perms.add(PosixFilePermission.OTHERS_READ);
            Files.setPosixFilePermissions(statusFile.toPath(), perms);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to set permissions so that only the owner can read status file {}; this may allows others to have access to the key needed to communicate with MiNiFi. Permissions should be changed so that only the owner can read this file", (Object)statusFile);
        }
        try (FileOutputStream fos = new FileOutputStream(statusFile);){
            minifiProps.store(fos, null);
            fos.getFD().sync();
        }
        LOGGER.debug("Saving MiNiFi properties to {}", (Object)statusFile);
        this.logProperties("Saved MiNiFi", minifiProps);
    }

    private void writePidFile(String pid) throws IOException {
        File pidFile = this.getPidFile();
        if (pidFile.exists() && !pidFile.delete()) {
            LOGGER.warn("Failed to delete {}", (Object)pidFile);
        }
        if (!pidFile.createNewFile()) {
            throw new IOException("Failed to create file " + String.valueOf(pidFile));
        }
        try {
            HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
            perms.add(PosixFilePermission.OWNER_READ);
            perms.add(PosixFilePermission.OWNER_WRITE);
            Files.setPosixFilePermissions(pidFile.toPath(), perms);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to set permissions so that only the owner can read pid file {}; this may allows others to have access to the key needed to communicate with MiNiFi. Permissions should be changed so that only the owner can read this file", (Object)pidFile);
        }
        try (FileOutputStream fos = new FileOutputStream(pidFile);){
            fos.write(pid.getBytes(StandardCharsets.UTF_8));
            fos.getFD().sync();
        }
        LOGGER.debug("Saved Pid {} to {}", (Object)pid, (Object)pidFile);
    }

    private File getBootstrapFile(String fileName) throws IOException {
        File configFileDir = Optional.ofNullable(System.getProperty(MINIFI_PID_DIR_PROP)).map(String::trim).map(File::new).orElseGet(() -> {
            File confDir = this.bootstrapConfigFile.getParentFile();
            File nifiHome = confDir.getParentFile();
            return new File(nifiHome, DEFAULT_PID_DIR);
        });
        FileUtils.ensureDirectoryExistAndCanAccess((File)configFileDir);
        File statusFile = new File(configFileDir, fileName);
        LOGGER.debug("Run File: {}", (Object)statusFile);
        return statusFile;
    }

    private void logProperties(String type, Properties props) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("{} properties: {}", (Object)type, props.entrySet().stream().filter(e -> {
                String key = ((String)e.getKey()).toLowerCase();
                return !SensitiveProperty.SENSITIVE_PROPERTIES.contains(key);
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        }
    }
}

