/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.flow.diff;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.nifi.components.PortFunction;
import org.apache.nifi.flow.ExecutionEngine;
import org.apache.nifi.flow.ScheduledState;
import org.apache.nifi.flow.VersionedAsset;
import org.apache.nifi.flow.VersionedComponent;
import org.apache.nifi.flow.VersionedConfigurableExtension;
import org.apache.nifi.flow.VersionedConnection;
import org.apache.nifi.flow.VersionedControllerService;
import org.apache.nifi.flow.VersionedFlowAnalysisRule;
import org.apache.nifi.flow.VersionedFlowCoordinates;
import org.apache.nifi.flow.VersionedFlowRegistryClient;
import org.apache.nifi.flow.VersionedFunnel;
import org.apache.nifi.flow.VersionedLabel;
import org.apache.nifi.flow.VersionedParameter;
import org.apache.nifi.flow.VersionedParameterContext;
import org.apache.nifi.flow.VersionedParameterProvider;
import org.apache.nifi.flow.VersionedPort;
import org.apache.nifi.flow.VersionedProcessGroup;
import org.apache.nifi.flow.VersionedProcessor;
import org.apache.nifi.flow.VersionedPropertyDescriptor;
import org.apache.nifi.flow.VersionedRemoteGroupPort;
import org.apache.nifi.flow.VersionedRemoteProcessGroup;
import org.apache.nifi.flow.VersionedReportingTask;
import org.apache.nifi.registry.flow.diff.ComparableDataFlow;
import org.apache.nifi.registry.flow.diff.DifferenceDescriptor;
import org.apache.nifi.registry.flow.diff.DifferenceType;
import org.apache.nifi.registry.flow.diff.FlowComparator;
import org.apache.nifi.registry.flow.diff.FlowComparatorVersionedStrategy;
import org.apache.nifi.registry.flow.diff.FlowComparison;
import org.apache.nifi.registry.flow.diff.FlowDifference;
import org.apache.nifi.registry.flow.diff.StandardFlowComparison;
import org.apache.nifi.registry.flow.diff.StandardFlowDifference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardFlowComparator
implements FlowComparator {
    private static final Logger logger = LoggerFactory.getLogger(StandardFlowComparator.class);
    private static final String ENCRYPTED_VALUE_PREFIX = "enc{";
    private static final String ENCRYPTED_VALUE_SUFFIX = "}";
    private static final String FLOW_VERSION = "Flow Version";
    private static final String DEFAULT_LOAD_BALANCE_STRATEGY = "DO_NOT_LOAD_BALANCE";
    private static final String DEFAULT_PARTITIONING_ATTRIBUTE = "";
    private static final String DEFAULT_LOAD_BALANCE_COMPRESSION = "DO_NOT_COMPRESS";
    private static final String DEFAULT_FLOW_FILE_CONCURRENCY = "UNBOUNDED";
    private static final String DEFAULT_OUTBOUND_FLOW_FILE_POLICY = "STREAM_WHEN_AVAILABLE";
    private static final Pattern PARAMETER_REFERENCE_PATTERN = Pattern.compile("#\\{[A-Za-z0-9\\-_. ]+}");
    private final ComparableDataFlow flowA;
    private final ComparableDataFlow flowB;
    private final Set<String> externallyAccessibleServiceIds;
    private final DifferenceDescriptor differenceDescriptor;
    private final Function<String, String> propertyDecryptor;
    private final Function<VersionedComponent, String> idLookup;
    private final FlowComparatorVersionedStrategy flowComparatorVersionedStrategy;

    public StandardFlowComparator(ComparableDataFlow flowA, ComparableDataFlow flowB, Set<String> externallyAccessibleServiceIds, DifferenceDescriptor differenceDescriptor, Function<String, String> propertyDecryptor, Function<VersionedComponent, String> idLookup, FlowComparatorVersionedStrategy flowComparatorVersionedStrategy) {
        this.flowA = flowA;
        this.flowB = flowB;
        this.externallyAccessibleServiceIds = externallyAccessibleServiceIds;
        this.differenceDescriptor = differenceDescriptor;
        this.propertyDecryptor = propertyDecryptor;
        this.idLookup = idLookup;
        this.flowComparatorVersionedStrategy = flowComparatorVersionedStrategy;
    }

    @Override
    public FlowComparison compare() {
        VersionedProcessGroup groupA = this.flowA.getContents();
        VersionedProcessGroup groupB = this.flowB.getContents();
        Set<FlowDifference> differences = this.compare(groupA, groupB);
        differences.addAll(this.compareComponents(this.flowA.getControllerLevelServices(), this.flowB.getControllerLevelServices(), this::compare));
        differences.addAll(this.compareComponents(this.flowA.getReportingTasks(), this.flowB.getReportingTasks(), this::compare));
        differences.addAll(this.compareComponents(this.flowA.getFlowAnalysisRules(), this.flowB.getFlowAnalysisRules(), this::compare));
        differences.addAll(this.compareComponents(this.flowA.getParameterProviders(), this.flowB.getParameterProviders(), this::compare));
        differences.addAll(this.compareComponents(this.flowA.getParameterContexts(), this.flowB.getParameterContexts(), this::compare));
        differences.addAll(this.compareComponents(this.flowA.getFlowRegistryClients(), this.flowB.getFlowRegistryClients(), this::compare));
        return new StandardFlowComparison(this.flowA, this.flowB, differences);
    }

    private Set<FlowDifference> compare(VersionedProcessGroup groupA, VersionedProcessGroup groupB) {
        HashSet<FlowDifference> differences = new HashSet<FlowDifference>();
        this.compare(groupA, groupB, differences, false);
        return differences;
    }

    private <T extends VersionedComponent> Set<FlowDifference> compareComponents(Set<T> componentsA, Set<T> componentsB, ComponentComparator<T> comparator) {
        Map componentMapA = this.byId(componentsA == null ? Collections.emptySet() : componentsA);
        Map componentMapB = this.byId(componentsB == null ? Collections.emptySet() : componentsB);
        HashSet<FlowDifference> differences = new HashSet<FlowDifference>();
        componentMapA.forEach((key, componentA) -> {
            VersionedComponent componentB = (VersionedComponent)componentMapB.get(key);
            comparator.compare(componentA, componentB, differences);
        });
        componentMapB.forEach((key, componentB) -> {
            VersionedComponent componentA = (VersionedComponent)componentMapA.get(key);
            if (componentA == null) {
                comparator.compare(componentA, componentB, differences);
            }
        });
        return differences;
    }

    private boolean compareComponents(VersionedComponent componentA, VersionedComponent componentB, Set<FlowDifference> differences) {
        return this.compareComponents(componentA, componentB, differences, true, true, true);
    }

    private boolean compareComponents(VersionedComponent componentA, VersionedComponent componentB, Set<FlowDifference> differences, boolean compareName, boolean comparePos, boolean compareComments) {
        if (componentA == null) {
            differences.add(this.difference(DifferenceType.COMPONENT_ADDED, componentA, componentB, componentA, componentB));
            return true;
        }
        if (componentB == null) {
            differences.add(this.difference(DifferenceType.COMPONENT_REMOVED, componentA, componentB, componentA, componentB));
            return true;
        }
        if (compareComments) {
            this.addIfDifferent(differences, DifferenceType.COMMENTS_CHANGED, componentA, componentB, VersionedComponent::getComments, false);
        }
        if (compareName) {
            this.addIfDifferent(differences, DifferenceType.NAME_CHANGED, componentA, componentB, VersionedComponent::getName);
        }
        if (comparePos) {
            this.addIfDifferent(differences, DifferenceType.POSITION_CHANGED, componentA, componentB, VersionedComponent::getPosition);
        }
        return false;
    }

    private void compare(VersionedProcessor processorA, VersionedProcessor processorB, Set<FlowDifference> differences) {
        if (this.compareComponents((VersionedComponent)processorA, (VersionedComponent)processorB, differences)) {
            return;
        }
        this.addIfDifferent(differences, DifferenceType.ANNOTATION_DATA_CHANGED, processorA, processorB, VersionedProcessor::getAnnotationData);
        this.addIfDifferent(differences, DifferenceType.AUTO_TERMINATED_RELATIONSHIPS_CHANGED, processorA, processorB, VersionedProcessor::getAutoTerminatedRelationships);
        this.addIfDifferent(differences, DifferenceType.BULLETIN_LEVEL_CHANGED, processorA, processorB, VersionedProcessor::getBulletinLevel);
        this.addIfDifferent(differences, DifferenceType.BUNDLE_CHANGED, processorA, processorB, VersionedConfigurableExtension::getBundle);
        this.addIfDifferent(differences, DifferenceType.CONCURRENT_TASKS_CHANGED, processorA, processorB, VersionedProcessor::getConcurrentlySchedulableTaskCount);
        this.addIfDifferent(differences, DifferenceType.EXECUTION_MODE_CHANGED, processorA, processorB, VersionedProcessor::getExecutionNode);
        this.addIfDifferent(differences, DifferenceType.PENALTY_DURATION_CHANGED, processorA, processorB, VersionedProcessor::getPenaltyDuration);
        this.addIfDifferent(differences, DifferenceType.RUN_DURATION_CHANGED, processorA, processorB, VersionedProcessor::getRunDurationMillis);
        this.addIfDifferent(differences, DifferenceType.RUN_SCHEDULE_CHANGED, processorA, processorB, VersionedProcessor::getSchedulingPeriod);
        this.addIfDifferent(differences, DifferenceType.SCHEDULING_STRATEGY_CHANGED, processorA, processorB, VersionedProcessor::getSchedulingStrategy);
        this.addIfDifferent(differences, DifferenceType.SCHEDULED_STATE_CHANGED, processorA, processorB, VersionedProcessor::getScheduledState);
        this.addIfDifferent(differences, DifferenceType.STYLE_CHANGED, processorA, processorB, VersionedProcessor::getStyle);
        this.addIfDifferent(differences, DifferenceType.YIELD_DURATION_CHANGED, processorA, processorB, VersionedProcessor::getYieldDuration);
        this.addIfDifferent(differences, DifferenceType.RETRY_COUNT_CHANGED, processorA, processorB, VersionedProcessor::getRetryCount);
        this.addIfDifferent(differences, DifferenceType.RETRIED_RELATIONSHIPS_CHANGED, processorA, processorB, VersionedProcessor::getRetriedRelationships);
        this.addIfDifferent(differences, DifferenceType.BACKOFF_MECHANISM_CHANGED, processorA, processorB, VersionedProcessor::getBackoffMechanism);
        this.addIfDifferent(differences, DifferenceType.MAX_BACKOFF_PERIOD_CHANGED, processorA, processorB, VersionedProcessor::getMaxBackoffPeriod);
        this.compareProperties((VersionedComponent)processorA, (VersionedComponent)processorB, processorA.getProperties(), processorB.getProperties(), processorA.getPropertyDescriptors(), processorB.getPropertyDescriptors(), differences);
    }

    private void compare(VersionedReportingTask taskA, VersionedReportingTask taskB, Set<FlowDifference> differences) {
        if (this.compareComponents((VersionedComponent)taskA, (VersionedComponent)taskB, differences)) {
            return;
        }
        this.addIfDifferent(differences, DifferenceType.ANNOTATION_DATA_CHANGED, taskA, taskB, VersionedReportingTask::getAnnotationData);
        this.addIfDifferent(differences, DifferenceType.BUNDLE_CHANGED, taskA, taskB, VersionedConfigurableExtension::getBundle);
        this.addIfDifferent(differences, DifferenceType.RUN_SCHEDULE_CHANGED, taskA, taskB, VersionedReportingTask::getSchedulingPeriod);
        this.addIfDifferent(differences, DifferenceType.SCHEDULING_STRATEGY_CHANGED, taskA, taskB, VersionedReportingTask::getSchedulingStrategy);
        this.addIfDifferent(differences, DifferenceType.SCHEDULED_STATE_CHANGED, taskA, taskB, VersionedReportingTask::getScheduledState);
        this.compareProperties((VersionedComponent)taskA, (VersionedComponent)taskB, taskA.getProperties(), taskB.getProperties(), taskA.getPropertyDescriptors(), taskB.getPropertyDescriptors(), differences);
    }

    private void compare(VersionedFlowAnalysisRule ruleA, VersionedFlowAnalysisRule ruleB, Set<FlowDifference> differences) {
        if (this.compareComponents((VersionedComponent)ruleA, (VersionedComponent)ruleB, differences)) {
            return;
        }
        this.addIfDifferent(differences, DifferenceType.BUNDLE_CHANGED, ruleA, ruleB, VersionedConfigurableExtension::getBundle);
        this.addIfDifferent(differences, DifferenceType.ENFORCEMENT_POLICY_CHANGED, ruleA, ruleB, VersionedFlowAnalysisRule::getEnforcementPolicy);
        this.addIfDifferent(differences, DifferenceType.SCHEDULED_STATE_CHANGED, ruleA, ruleB, VersionedFlowAnalysisRule::getScheduledState);
        this.compareProperties((VersionedComponent)ruleA, (VersionedComponent)ruleB, ruleA.getProperties(), ruleB.getProperties(), ruleA.getPropertyDescriptors(), ruleB.getPropertyDescriptors(), differences);
    }

    private void compare(VersionedParameterProvider parameterProviderA, VersionedParameterProvider parameterProviderB, Set<FlowDifference> differences) {
        if (this.compareComponents((VersionedComponent)parameterProviderA, (VersionedComponent)parameterProviderB, differences)) {
            return;
        }
        this.addIfDifferent(differences, DifferenceType.ANNOTATION_DATA_CHANGED, parameterProviderA, parameterProviderB, VersionedParameterProvider::getAnnotationData);
        this.addIfDifferent(differences, DifferenceType.BUNDLE_CHANGED, parameterProviderA, parameterProviderB, VersionedParameterProvider::getBundle);
        this.compareProperties((VersionedComponent)parameterProviderA, (VersionedComponent)parameterProviderB, parameterProviderA.getProperties(), parameterProviderB.getProperties(), parameterProviderA.getPropertyDescriptors(), parameterProviderB.getPropertyDescriptors(), differences);
    }

    void compare(VersionedParameterContext contextA, VersionedParameterContext contextB, Set<FlowDifference> differences) {
        String name;
        if (this.compareComponents((VersionedComponent)contextA, (VersionedComponent)contextB, differences)) {
            return;
        }
        this.addIfDifferent(differences, DifferenceType.DESCRIPTION_CHANGED, contextA, contextB, VersionedParameterContext::getDescription);
        this.addIfDifferent(differences, DifferenceType.INHERITED_CONTEXTS_CHANGED, contextA, contextB, VersionedParameterContext::getInheritedParameterContexts);
        this.addIfDifferent(differences, DifferenceType.PARAMETER_GROUP_NAME_CHANGED, contextA, contextB, VersionedParameterContext::getParameterGroupName);
        this.addIfDifferent(differences, DifferenceType.PARAMETER_PROVIDER_SYNCHRONIZED_CHANGED, contextA, contextB, VersionedParameterContext::isSynchronized);
        Map<String, VersionedParameter> contextAParameters = this.parametersByName(contextA.getParameters());
        Map<String, VersionedParameter> contextBParameters = this.parametersByName(contextB.getParameters());
        for (VersionedParameter parameterA : contextA.getParameters()) {
            String description;
            Object valueB;
            Object valueA;
            Set assetIdsB;
            Set assetIdsA;
            String decryptedValueB;
            name = parameterA.getName();
            VersionedParameter parameterB = contextBParameters.get(parameterA.getName());
            if (parameterB == null) {
                differences.add(this.difference(DifferenceType.PARAMETER_REMOVED, (VersionedComponent)contextA, (VersionedComponent)contextB, name, name, null, parameterA.isSensitive() ? "<Sensitive Value>" : parameterA.getValue()));
                continue;
            }
            String decryptedValueA = this.decryptValue(parameterA);
            if (!Objects.equals(decryptedValueA, decryptedValueB = this.decryptValue(parameterB))) {
                String valueA2 = parameterA.isSensitive() ? "<Sensitive Value A>" : parameterA.getValue();
                String valueB2 = parameterB.isSensitive() ? "<Sensitive Value B>" : parameterB.getValue();
                String description2 = this.differenceDescriptor.describeDifference(DifferenceType.PARAMETER_VALUE_CHANGED, this.flowA.getName(), this.flowB.getName(), (VersionedComponent)contextA, (VersionedComponent)contextB, name, valueA2, valueB2);
                differences.add(new StandardFlowDifference(DifferenceType.PARAMETER_VALUE_CHANGED, (VersionedComponent)contextA, (VersionedComponent)contextB, name, valueA2, valueB2, description2));
            }
            if (!(assetIdsA = Stream.ofNullable(parameterA.getReferencedAssets()).flatMap(Collection::stream).map(VersionedAsset::getIdentifier).collect(Collectors.toSet())).equals(assetIdsB = Stream.ofNullable(parameterB.getReferencedAssets()).flatMap(Collection::stream).map(VersionedAsset::getIdentifier).collect(Collectors.toSet()))) {
                valueA = parameterA.getReferencedAssets();
                valueB = parameterB.getReferencedAssets();
                description = this.differenceDescriptor.describeDifference(DifferenceType.PARAMETER_ASSET_REFERENCES_CHANGED, this.flowA.getName(), this.flowB.getName(), (VersionedComponent)contextA, (VersionedComponent)contextB, name, valueA, valueB);
                differences.add(new StandardFlowDifference(DifferenceType.PARAMETER_ASSET_REFERENCES_CHANGED, (VersionedComponent)contextA, (VersionedComponent)contextB, name, valueA, valueB, description));
            }
            if (Objects.equals(parameterA.getDescription(), parameterB.getDescription())) continue;
            valueA = parameterA.getDescription();
            valueB = parameterB.getDescription();
            description = this.differenceDescriptor.describeDifference(DifferenceType.PARAMETER_DESCRIPTION_CHANGED, this.flowA.getName(), this.flowB.getName(), (VersionedComponent)contextA, (VersionedComponent)contextB, name, valueA, valueB);
            differences.add(new StandardFlowDifference(DifferenceType.PARAMETER_DESCRIPTION_CHANGED, (VersionedComponent)contextA, (VersionedComponent)contextB, name, valueA, valueB, description));
        }
        for (VersionedParameter parameter : contextB.getParameters()) {
            name = parameter.getName();
            if (contextAParameters.containsKey(name)) continue;
            differences.add(this.difference(DifferenceType.PARAMETER_ADDED, (VersionedComponent)contextA, (VersionedComponent)contextB, name, name, null, parameter.isSensitive() ? "<Sensitive Value>" : parameter.getValue()));
        }
    }

    void compare(VersionedFlowRegistryClient clientA, VersionedFlowRegistryClient clientB, Set<FlowDifference> differences) {
        if (this.compareComponents((VersionedComponent)clientA, (VersionedComponent)clientB, differences)) {
            return;
        }
        this.addIfDifferent(differences, DifferenceType.DESCRIPTION_CHANGED, clientA, clientB, VersionedFlowRegistryClient::getDescription);
        this.addIfDifferent(differences, DifferenceType.ANNOTATION_DATA_CHANGED, clientA, clientB, VersionedFlowRegistryClient::getAnnotationData);
        this.addIfDifferent(differences, DifferenceType.BUNDLE_CHANGED, clientA, clientB, VersionedConfigurableExtension::getBundle);
        this.compareProperties((VersionedComponent)clientA, (VersionedComponent)clientB, this.nullToEmpty(clientA.getProperties()), this.nullToEmpty(clientB.getProperties()), this.nullToEmpty(clientA.getPropertyDescriptors()), this.nullToEmpty(clientB.getPropertyDescriptors()), differences);
    }

    private <K, V> Map<K, V> nullToEmpty(Map<K, V> map) {
        return map == null ? Collections.emptyMap() : map;
    }

    private Map<String, VersionedParameter> parametersByName(Collection<VersionedParameter> parameters) {
        return parameters.stream().collect(Collectors.toMap(VersionedParameter::getName, Function.identity()));
    }

    @Override
    public Set<FlowDifference> compareControllerServices(VersionedControllerService serviceA, VersionedControllerService serviceB) {
        HashSet<FlowDifference> differences = new HashSet<FlowDifference>();
        this.compare(serviceA, serviceB, differences);
        return differences;
    }

    private void compare(VersionedControllerService serviceA, VersionedControllerService serviceB, Set<FlowDifference> differences) {
        if (this.compareComponents((VersionedComponent)serviceA, (VersionedComponent)serviceB, differences)) {
            return;
        }
        this.addIfDifferent(differences, DifferenceType.ANNOTATION_DATA_CHANGED, serviceA, serviceB, VersionedControllerService::getAnnotationData);
        this.addIfDifferent(differences, DifferenceType.BUNDLE_CHANGED, serviceA, serviceB, VersionedConfigurableExtension::getBundle);
        this.compareProperties((VersionedComponent)serviceA, (VersionedComponent)serviceB, serviceA.getProperties(), serviceB.getProperties(), serviceA.getPropertyDescriptors(), serviceB.getPropertyDescriptors(), differences);
        this.addIfDifferent(differences, DifferenceType.SCHEDULED_STATE_CHANGED, serviceA, serviceB, VersionedControllerService::getScheduledState);
        this.addIfDifferent(differences, DifferenceType.BULLETIN_LEVEL_CHANGED, serviceA, serviceB, VersionedControllerService::getBulletinLevel, true, "WARN");
    }

    private String decrypt(String value, VersionedPropertyDescriptor descriptor) {
        boolean sensitive;
        if (value == null) {
            return null;
        }
        boolean bl = sensitive = (descriptor == null || descriptor.isSensitive()) && value.startsWith(ENCRYPTED_VALUE_PREFIX) && value.endsWith(ENCRYPTED_VALUE_SUFFIX);
        if (!sensitive) {
            return value;
        }
        return this.propertyDecryptor.apply(value.substring(ENCRYPTED_VALUE_PREFIX.length(), value.length() - ENCRYPTED_VALUE_SUFFIX.length()));
    }

    private String decryptValue(VersionedParameter parameter) {
        boolean sensitive;
        String rawValue = parameter.getValue();
        if (rawValue == null) {
            return null;
        }
        boolean bl = sensitive = parameter.isSensitive() && rawValue.startsWith(ENCRYPTED_VALUE_PREFIX) && rawValue.endsWith(ENCRYPTED_VALUE_SUFFIX);
        if (!sensitive) {
            logger.debug("Will not decrypt value for parameter {} because it is not encrypted", (Object)parameter.getName());
            return rawValue;
        }
        return this.propertyDecryptor.apply(rawValue.substring(ENCRYPTED_VALUE_PREFIX.length(), rawValue.length() - ENCRYPTED_VALUE_SUFFIX.length()));
    }

    private void compareProperties(VersionedComponent componentA, VersionedComponent componentB, Map<String, String> propertiesA, Map<String, String> propertiesB, Map<String, VersionedPropertyDescriptor> descriptorsA, Map<String, VersionedPropertyDescriptor> descriptorsB, Set<FlowDifference> differences) {
        propertiesA.forEach((key, rawValueA) -> {
            String displayName;
            String rawValueB = (String)propertiesB.get(key);
            String valueB = this.decrypt(rawValueB, (VersionedPropertyDescriptor)descriptorsB.get(key));
            String valueA = this.decrypt((String)rawValueA, (VersionedPropertyDescriptor)descriptorsA.get(key));
            VersionedPropertyDescriptor descriptorA = (VersionedPropertyDescriptor)descriptorsA.get(key);
            VersionedPropertyDescriptor descriptorB = (VersionedPropertyDescriptor)descriptorsB.get(key);
            VersionedPropertyDescriptor descriptor = descriptorA;
            if (descriptor == null) {
                descriptor = descriptorB;
            }
            if (descriptor == null) {
                displayName = key;
            } else {
                String string = displayName = descriptor.getDisplayName() == null ? descriptor.getName() : descriptor.getDisplayName();
            }
            if (descriptorA != null && descriptorB != null && descriptorA.isSensitive() != descriptorB.isSensitive()) {
                differences.add(this.difference(DifferenceType.PROPERTY_SENSITIVITY_CHANGED, componentA, componentB, (String)key, displayName, descriptorA.isSensitive(), descriptorB.isSensitive()));
            }
            if (valueA == null && valueB != null) {
                if (this.isParameterReference(valueB)) {
                    differences.add(this.difference(DifferenceType.PROPERTY_PARAMETERIZED, componentA, componentB, (String)key, displayName, null, null));
                } else {
                    differences.add(this.difference(DifferenceType.PROPERTY_ADDED, componentA, componentB, (String)key, displayName, valueA, valueB));
                }
            } else if (valueA != null && valueB == null) {
                if (this.isParameterReference(valueA)) {
                    differences.add(this.difference(DifferenceType.PROPERTY_PARAMETERIZATION_REMOVED, componentA, componentB, (String)key, displayName, null, null));
                } else {
                    differences.add(this.difference(DifferenceType.PROPERTY_REMOVED, componentA, componentB, (String)key, displayName, valueA, valueB));
                }
            } else if (valueA != null && !valueA.equals(valueB)) {
                if (descriptor != null && descriptor.getIdentifiesControllerService()) {
                    boolean accessibleA = this.externallyAccessibleServiceIds.contains(valueA);
                    boolean accessibleB = this.externallyAccessibleServiceIds.contains(valueB);
                    if (!accessibleA && accessibleB) {
                        return;
                    }
                }
                boolean aParameterized = this.isParameterReference(valueA);
                boolean bParameterized = this.isParameterReference(valueB);
                if (aParameterized && !bParameterized) {
                    differences.add(this.difference(DifferenceType.PROPERTY_PARAMETERIZATION_REMOVED, componentA, componentB, (String)key, displayName, null, null));
                } else if (!aParameterized && bParameterized) {
                    differences.add(this.difference(DifferenceType.PROPERTY_PARAMETERIZED, componentA, componentB, (String)key, displayName, null, null));
                } else {
                    differences.add(this.difference(DifferenceType.PROPERTY_CHANGED, componentA, componentB, (String)key, displayName, valueA, valueB));
                }
            }
        });
        propertiesB.forEach((key, valueB) -> {
            String valueA = (String)propertiesA.get(key);
            if (valueA == null && valueB != null) {
                String displayName;
                VersionedPropertyDescriptor descriptor = (VersionedPropertyDescriptor)descriptorsB.get(key);
                if (descriptor == null) {
                    displayName = key;
                } else {
                    String string = displayName = descriptor.getDisplayName() == null ? descriptor.getName() : descriptor.getDisplayName();
                }
                if (this.isParameterReference((String)valueB)) {
                    differences.add(this.difference(DifferenceType.PROPERTY_PARAMETERIZED, componentA, componentB, (String)key, displayName, null, null));
                } else {
                    differences.add(this.difference(DifferenceType.PROPERTY_ADDED, componentA, componentB, (String)key, displayName, null, valueB));
                }
            }
        });
    }

    private boolean isParameterReference(String propertyValue) {
        return PARAMETER_REFERENCE_PATTERN.matcher(propertyValue).matches();
    }

    private void compare(VersionedFunnel funnelA, VersionedFunnel funnelB, Set<FlowDifference> differences) {
        this.compareComponents((VersionedComponent)funnelA, (VersionedComponent)funnelB, differences);
    }

    private void compare(VersionedLabel labelA, VersionedLabel labelB, Set<FlowDifference> differences) {
        if (this.compareComponents((VersionedComponent)labelA, (VersionedComponent)labelB, differences)) {
            return;
        }
        this.addIfDifferent(differences, DifferenceType.LABEL_VALUE_CHANGED, labelA, labelB, VersionedLabel::getLabel);
        this.addIfDifferent(differences, DifferenceType.SIZE_CHANGED, labelA, labelB, VersionedLabel::getHeight);
        this.addIfDifferent(differences, DifferenceType.SIZE_CHANGED, labelA, labelB, VersionedLabel::getWidth);
        this.addIfDifferent(differences, DifferenceType.STYLE_CHANGED, labelA, labelB, VersionedLabel::getStyle);
        this.addIfDifferent(differences, DifferenceType.ZINDEX_CHANGED, labelA, labelB, VersionedLabel::getzIndex);
    }

    private void compare(VersionedPort portA, VersionedPort portB, Set<FlowDifference> differences) {
        if (this.compareComponents((VersionedComponent)portA, (VersionedComponent)portB, differences)) {
            return;
        }
        if (portA != null && portA.isAllowRemoteAccess().booleanValue() && portB != null && portB.isAllowRemoteAccess().booleanValue()) {
            this.addIfDifferent(differences, DifferenceType.CONCURRENT_TASKS_CHANGED, portA, portB, VersionedPort::getConcurrentlySchedulableTaskCount);
        }
        this.addIfDifferent(differences, DifferenceType.SCHEDULED_STATE_CHANGED, portA, portB, VersionedPort::getScheduledState);
        this.addIfDifferent(differences, DifferenceType.PORT_FUNCTION_CHANGED, portA, portB, VersionedPort::getPortFunction, true, PortFunction.STANDARD);
    }

    private void compare(VersionedRemoteProcessGroup rpgA, VersionedRemoteProcessGroup rpgB, Set<FlowDifference> differences) {
        if (this.compareComponents((VersionedComponent)rpgA, (VersionedComponent)rpgB, differences, false, true, false)) {
            return;
        }
        this.addIfDifferent(differences, DifferenceType.RPG_COMMS_TIMEOUT_CHANGED, rpgA, rpgB, VersionedRemoteProcessGroup::getCommunicationsTimeout);
        this.addIfDifferent(differences, DifferenceType.RPG_NETWORK_INTERFACE_CHANGED, rpgA, rpgB, VersionedRemoteProcessGroup::getLocalNetworkInterface);
        this.addIfDifferent(differences, DifferenceType.RPG_PROXY_HOST_CHANGED, rpgA, rpgB, VersionedRemoteProcessGroup::getProxyHost);
        this.addIfDifferent(differences, DifferenceType.RPG_PROXY_PORT_CHANGED, rpgA, rpgB, VersionedRemoteProcessGroup::getProxyPort);
        this.addIfDifferent(differences, DifferenceType.RPG_PROXY_USER_CHANGED, rpgA, rpgB, VersionedRemoteProcessGroup::getProxyUser);
        this.addIfDifferent(differences, DifferenceType.RPG_TRANSPORT_PROTOCOL_CHANGED, rpgA, rpgB, VersionedRemoteProcessGroup::getTransportProtocol);
        this.addIfDifferent(differences, DifferenceType.YIELD_DURATION_CHANGED, rpgA, rpgB, VersionedRemoteProcessGroup::getYieldDuration);
        this.addIfDifferent(differences, DifferenceType.RPG_URL_CHANGED, rpgA, rpgB, VersionedRemoteProcessGroup::getTargetUris);
        differences.addAll(this.compareComponents(rpgA.getInputPorts(), rpgB.getInputPorts(), this::compare));
        differences.addAll(this.compareComponents(rpgA.getOutputPorts(), rpgB.getOutputPorts(), this::compare));
    }

    private void compare(VersionedRemoteGroupPort portA, VersionedRemoteGroupPort portB, Set<FlowDifference> differences) {
        if (this.compareComponents((VersionedComponent)portA, (VersionedComponent)portB, differences)) {
            return;
        }
        this.addIfDifferent(differences, DifferenceType.REMOTE_PORT_BATCH_SIZE_CHANGED, portA, portB, VersionedRemoteGroupPort::getBatchSize);
        this.addIfDifferent(differences, DifferenceType.REMOTE_PORT_COMPRESSION_CHANGED, portA, portB, VersionedRemoteGroupPort::isUseCompression);
        this.addIfDifferent(differences, DifferenceType.CONCURRENT_TASKS_CHANGED, portA, portB, VersionedRemoteGroupPort::getConcurrentlySchedulableTaskCount);
        this.addIfDifferent(differences, DifferenceType.SCHEDULED_STATE_CHANGED, portA, portB, VersionedRemoteGroupPort::getScheduledState);
    }

    private void compare(VersionedProcessGroup groupA, VersionedProcessGroup groupB, Set<FlowDifference> differences, boolean compareNamePos) {
        boolean compareGroupContents;
        if (this.compareComponents((VersionedComponent)groupA, (VersionedComponent)groupB, differences, compareNamePos, compareNamePos, true)) {
            return;
        }
        if (groupA == null) {
            differences.add(this.difference(DifferenceType.COMPONENT_ADDED, (VersionedComponent)groupA, (VersionedComponent)groupB, groupA, groupB));
            return;
        }
        if (groupB == null) {
            differences.add(this.difference(DifferenceType.COMPONENT_REMOVED, (VersionedComponent)groupA, (VersionedComponent)groupB, groupA, groupB));
            return;
        }
        HashSet<FlowDifference> flowCoordinateDifferences = new HashSet<FlowDifference>();
        this.compareFlowCoordinates(groupA, groupB, flowCoordinateDifferences);
        differences.addAll(flowCoordinateDifferences);
        this.addIfDifferent(differences, DifferenceType.FLOWFILE_CONCURRENCY_CHANGED, groupA, groupB, VersionedProcessGroup::getFlowFileConcurrency, true, DEFAULT_FLOW_FILE_CONCURRENCY);
        this.addIfDifferent(differences, DifferenceType.FLOWFILE_OUTBOUND_POLICY_CHANGED, groupA, groupB, VersionedProcessGroup::getFlowFileOutboundPolicy, true, DEFAULT_OUTBOUND_FLOW_FILE_POLICY);
        this.addIfDifferent(differences, DifferenceType.DEFAULT_BACKPRESSURE_DATA_SIZE_CHANGED, groupA, groupB, VersionedProcessGroup::getDefaultBackPressureDataSizeThreshold, true, "1 GB");
        this.addIfDifferent(differences, DifferenceType.DEFAULT_BACKPRESSURE_OBJECT_COUNT_CHANGED, groupA, groupB, VersionedProcessGroup::getDefaultBackPressureObjectThreshold, true, 10000L);
        this.addIfDifferent(differences, DifferenceType.DEFAULT_FLOWFILE_EXPIRATION_CHANGED, groupA, groupB, VersionedProcessGroup::getDefaultFlowFileExpiration, true, "0 sec");
        this.addIfDifferent(differences, DifferenceType.PARAMETER_CONTEXT_CHANGED, groupA, groupB, VersionedProcessGroup::getParameterContextName, true, null);
        this.addIfDifferent(differences, DifferenceType.LOG_FILE_SUFFIX_CHANGED, groupA, groupB, VersionedProcessGroup::getLogFileSuffix, true, null);
        this.addIfDifferent(differences, DifferenceType.EXECUTION_ENGINE_CHANGED, groupA, groupB, VersionedProcessGroup::getExecutionEngine, true, ExecutionEngine.INHERITED);
        this.addIfDifferent(differences, DifferenceType.SCHEDULED_STATE_CHANGED, groupA, groupB, VersionedProcessGroup::getScheduledState, true, ScheduledState.ENABLED);
        this.addIfDifferent(differences, DifferenceType.CONCURRENT_TASKS_CHANGED, groupA, groupB, VersionedProcessGroup::getMaxConcurrentTasks, true, 1);
        this.addIfDifferent(differences, DifferenceType.TIMEOUT_CHANGED, groupA, groupB, VersionedProcessGroup::getStatelessFlowTimeout, false, "1 min");
        VersionedFlowCoordinates groupACoordinates = groupA.getVersionedFlowCoordinates();
        VersionedFlowCoordinates groupBCoordinates = groupB.getVersionedFlowCoordinates();
        boolean shouldCompareVersioned = flowCoordinateDifferences.stream().anyMatch(diff -> !diff.getFieldName().isPresent() || !diff.getFieldName().get().equals(FLOW_VERSION)) || this.flowComparatorVersionedStrategy == FlowComparatorVersionedStrategy.DEEP;
        boolean bl = compareGroupContents = groupACoordinates == null && groupBCoordinates == null || groupACoordinates != null && groupBCoordinates != null && shouldCompareVersioned;
        if (compareGroupContents) {
            differences.addAll(this.compareComponents(groupA.getConnections(), groupB.getConnections(), this::compare));
            differences.addAll(this.compareComponents(groupA.getProcessors(), groupB.getProcessors(), this::compare));
            differences.addAll(this.compareComponents(groupA.getControllerServices(), groupB.getControllerServices(), this::compare));
            differences.addAll(this.compareComponents(groupA.getFunnels(), groupB.getFunnels(), this::compare));
            differences.addAll(this.compareComponents(groupA.getInputPorts(), groupB.getInputPorts(), this::compare));
            differences.addAll(this.compareComponents(groupA.getLabels(), groupB.getLabels(), this::compare));
            differences.addAll(this.compareComponents(groupA.getOutputPorts(), groupB.getOutputPorts(), this::compare));
            differences.addAll(this.compareComponents(groupA.getProcessGroups(), groupB.getProcessGroups(), (T a, T b, Set<FlowDifference> diffs) -> this.compare((VersionedProcessGroup)a, (VersionedProcessGroup)b, diffs, true)));
            differences.addAll(this.compareComponents(groupA.getRemoteProcessGroups(), groupB.getRemoteProcessGroups(), this::compare));
        }
    }

    private void compareFlowCoordinates(VersionedProcessGroup groupA, VersionedProcessGroup groupB, Set<FlowDifference> differences) {
        VersionedFlowCoordinates coordinatesA = groupA.getVersionedFlowCoordinates();
        VersionedFlowCoordinates coordinatesB = groupB.getVersionedFlowCoordinates();
        if (coordinatesA == null && coordinatesB == null) {
            return;
        }
        if (coordinatesA == null || coordinatesB == null) {
            this.addIfDifferent(differences, DifferenceType.VERSIONED_FLOW_COORDINATES_CHANGED, groupA, groupB, VersionedProcessGroup::getVersionedFlowCoordinates);
            return;
        }
        if (!Objects.equals(coordinatesA.getBucketId(), coordinatesB.getBucketId())) {
            differences.add(this.difference(DifferenceType.VERSIONED_FLOW_COORDINATES_CHANGED, (VersionedComponent)groupA, (VersionedComponent)groupB, coordinatesA, coordinatesB));
            return;
        }
        if (!Objects.equals(coordinatesA.getFlowId(), coordinatesB.getFlowId())) {
            differences.add(this.difference(DifferenceType.VERSIONED_FLOW_COORDINATES_CHANGED, (VersionedComponent)groupA, (VersionedComponent)groupB, coordinatesA, coordinatesB));
            return;
        }
        if (!Objects.equals(coordinatesA.getVersion(), coordinatesB.getVersion())) {
            differences.add(this.difference(DifferenceType.VERSIONED_FLOW_COORDINATES_CHANGED, (VersionedComponent)groupA, (VersionedComponent)groupB, FLOW_VERSION, FLOW_VERSION, coordinatesA, coordinatesB));
            return;
        }
        String storageLocationA = coordinatesA.getStorageLocation();
        String storageLocationB = coordinatesB.getStorageLocation();
        if (storageLocationA != null && storageLocationB != null && !storageLocationA.equals(storageLocationB)) {
            differences.add(this.difference(DifferenceType.VERSIONED_FLOW_COORDINATES_CHANGED, (VersionedComponent)groupA, (VersionedComponent)groupB, coordinatesA, coordinatesB));
            return;
        }
    }

    private void compare(VersionedConnection connectionA, VersionedConnection connectionB, Set<FlowDifference> differences) {
        if (this.compareComponents((VersionedComponent)connectionA, (VersionedComponent)connectionB, differences)) {
            return;
        }
        this.addIfDifferent(differences, DifferenceType.BACKPRESSURE_DATA_SIZE_THRESHOLD_CHANGED, connectionA, connectionB, VersionedConnection::getBackPressureDataSizeThreshold);
        this.addIfDifferent(differences, DifferenceType.BACKPRESSURE_OBJECT_THRESHOLD_CHANGED, connectionA, connectionB, VersionedConnection::getBackPressureObjectThreshold);
        this.addIfDifferent(differences, DifferenceType.BENDPOINTS_CHANGED, connectionA, connectionB, VersionedConnection::getBends);
        this.addIfDifferent(differences, DifferenceType.DESTINATION_CHANGED, connectionA, connectionB, VersionedConnection::getDestination);
        this.addIfDifferent(differences, DifferenceType.FLOWFILE_EXPIRATION_CHANGED, connectionA, connectionB, VersionedConnection::getFlowFileExpiration);
        this.addIfDifferent(differences, DifferenceType.PRIORITIZERS_CHANGED, connectionA, connectionB, VersionedConnection::getPrioritizers);
        this.addIfDifferent(differences, DifferenceType.SELECTED_RELATIONSHIPS_CHANGED, connectionA, connectionB, VersionedConnection::getSelectedRelationships);
        this.addIfDifferent(differences, DifferenceType.SOURCE_CHANGED, connectionA, connectionB, c -> c.getSource().getId());
        this.addIfDifferent(differences, DifferenceType.ZINDEX_CHANGED, connectionA, connectionB, VersionedConnection::getzIndex);
        this.addIfDifferent(differences, DifferenceType.LOAD_BALANCE_STRATEGY_CHANGED, connectionA, connectionB, conn -> conn.getLoadBalanceStrategy() == null ? DEFAULT_LOAD_BALANCE_STRATEGY : conn.getLoadBalanceStrategy());
        this.addIfDifferent(differences, DifferenceType.PARTITIONING_ATTRIBUTE_CHANGED, connectionA, connectionB, conn -> conn.getPartitioningAttribute() == null ? DEFAULT_PARTITIONING_ATTRIBUTE : conn.getPartitioningAttribute());
        this.addIfDifferent(differences, DifferenceType.LOAD_BALANCE_COMPRESSION_CHANGED, connectionA, connectionB, conn -> conn.getLoadBalanceCompression() == null ? DEFAULT_LOAD_BALANCE_COMPRESSION : conn.getLoadBalanceCompression());
    }

    private <T extends VersionedComponent> Map<String, T> byId(Set<T> components) {
        return components.stream().collect(Collectors.toMap(this.idLookup::apply, Function.identity()));
    }

    private <T extends VersionedComponent> void addIfDifferent(Set<FlowDifference> differences, DifferenceType type, T componentA, T componentB, Function<T, Object> transform) {
        this.addIfDifferent(differences, type, componentA, componentB, transform, true);
    }

    private <T extends VersionedComponent> void addIfDifferent(Set<FlowDifference> differences, DifferenceType type, T componentA, T componentB, Function<T, Object> transform, boolean differentiateNullAndEmptyString) {
        this.addIfDifferent(differences, type, componentA, componentB, transform, differentiateNullAndEmptyString, null);
    }

    private <T extends VersionedComponent> void addIfDifferent(Set<FlowDifference> differences, DifferenceType type, T componentA, T componentB, Function<T, Object> transform, boolean differentiateNullAndEmptyString, Object defaultValue) {
        Object valueB;
        Object valueA = transform.apply(componentA);
        if (valueA == null) {
            valueA = defaultValue;
        }
        if ((valueB = transform.apply(componentB)) == null) {
            valueB = defaultValue;
        }
        if (Objects.equals(valueA, valueB)) {
            return;
        }
        if ((valueA == null || valueA instanceof Collection) && (valueB == null || valueB instanceof Collection) && this.isEmpty((Collection)valueA) && this.isEmpty((Collection)valueB)) {
            return;
        }
        if (!differentiateNullAndEmptyString && this.isEmptyString(valueA) && this.isEmptyString(valueB)) {
            return;
        }
        differences.add(this.difference(type, componentA, componentB, valueA, valueB));
    }

    private boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    private boolean isEmptyString(Object potentialString) {
        if (potentialString == null) {
            return true;
        }
        if (potentialString instanceof String) {
            String string = (String)potentialString;
            return string.isEmpty();
        }
        return false;
    }

    private FlowDifference difference(DifferenceType type, VersionedComponent componentA, VersionedComponent componentB, Object valueA, Object valueB) {
        String description = this.differenceDescriptor.describeDifference(type, this.flowA.getName(), this.flowB.getName(), componentA, componentB, null, valueA, valueB);
        return new StandardFlowDifference(type, componentA, componentB, valueA, valueB, description);
    }

    private FlowDifference difference(DifferenceType type, VersionedComponent componentA, VersionedComponent componentB, String fieldName, String prettyPrintFieldName, Object valueA, Object valueB) {
        String description = this.differenceDescriptor.describeDifference(type, this.flowA.getName(), this.flowB.getName(), componentA, componentB, prettyPrintFieldName, valueA, valueB);
        return new StandardFlowDifference(type, componentA, componentB, fieldName, valueA, valueB, description);
    }

    private static interface ComponentComparator<T extends VersionedComponent> {
        public void compare(T var1, T var2, Set<FlowDifference> var3);
    }
}

