/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.api;

import java.util.regex.Pattern;
import org.flywaydb.core.api.MigrationVersion;

public class MigrationPattern {
    private static final Pattern VERSION_NUMBER_PATTERN = Pattern.compile("-?\\d+(\\.\\d+)*");
    private final String migrationName;

    public boolean matches(MigrationVersion version, String description) {
        String migrationNameAsVersion = this.migrationName.replace("_", ".");
        if (version != null && MigrationPattern.isValidVersionNumber(migrationNameAsVersion)) {
            MigrationVersion patternVersion = MigrationVersion.fromVersion(migrationNameAsVersion);
            return patternVersion.equals(version);
        }
        String pattern = this.migrationName.replace("_", " ");
        return pattern.equals(description);
    }

    public String toString() {
        return this.migrationName;
    }

    public int hashCode() {
        return this.migrationName.hashCode();
    }

    private static boolean isValidVersionNumber(String versionNumber) {
        return VERSION_NUMBER_PATTERN.matcher(versionNumber).matches();
    }

    public MigrationPattern(String migrationName) {
        this.migrationName = migrationName;
    }
}

