/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authorization.method;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.function.Function;
import org.springframework.aop.support.AopUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.expression.Expression;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.authorization.method.AbstractExpressionAttributeRegistry;
import org.springframework.security.authorization.method.AuthorizationAnnotationUtils;
import org.springframework.security.authorization.method.ExpressionAttribute;
import org.springframework.security.authorization.method.HandleAuthorizationDenied;
import org.springframework.security.authorization.method.MethodAuthorizationDeniedHandler;
import org.springframework.security.authorization.method.PreAuthorizeAuthorizationManager;
import org.springframework.security.authorization.method.PreAuthorizeExpressionAttribute;
import org.springframework.security.authorization.method.ReflectiveMethodAuthorizationDeniedHandler;
import org.springframework.security.authorization.method.ThrowingMethodAuthorizationDeniedHandler;
import org.springframework.util.Assert;
import reactor.util.annotation.NonNull;

final class PreAuthorizeExpressionAttributeRegistry
extends AbstractExpressionAttributeRegistry<ExpressionAttribute> {
    private final MethodAuthorizationDeniedHandler defaultHandler = new ThrowingMethodAuthorizationDeniedHandler();
    private Function<Class<? extends MethodAuthorizationDeniedHandler>, MethodAuthorizationDeniedHandler> handlerResolver = clazz -> new ReflectiveMethodAuthorizationDeniedHandler((Class<?>)clazz, PreAuthorizeAuthorizationManager.class);

    PreAuthorizeExpressionAttributeRegistry() {
    }

    @Override
    @NonNull
    ExpressionAttribute resolveAttribute(Method method, Class<?> targetClass) {
        Method specificMethod = AopUtils.getMostSpecificMethod((Method)method, targetClass);
        PreAuthorize preAuthorize = this.findPreAuthorizeAnnotation(specificMethod);
        if (preAuthorize == null) {
            return ExpressionAttribute.NULL_ATTRIBUTE;
        }
        Expression expression = this.getExpressionHandler().getExpressionParser().parseExpression(preAuthorize.value());
        MethodAuthorizationDeniedHandler handler = this.resolveHandler(method);
        return new PreAuthorizeExpressionAttribute(expression, handler);
    }

    private MethodAuthorizationDeniedHandler resolveHandler(Method method) {
        Function<AnnotatedElement, HandleAuthorizationDenied> lookup = AuthorizationAnnotationUtils.withDefaults(HandleAuthorizationDenied.class);
        HandleAuthorizationDenied deniedHandler = lookup.apply(method);
        if (deniedHandler != null) {
            return this.handlerResolver.apply(deniedHandler.handlerClass());
        }
        deniedHandler = lookup.apply(method.getDeclaringClass());
        if (deniedHandler != null) {
            return this.handlerResolver.apply(deniedHandler.handlerClass());
        }
        return this.defaultHandler;
    }

    private PreAuthorize findPreAuthorizeAnnotation(Method method) {
        Function<AnnotatedElement, PreAuthorize> lookup = this.findUniqueAnnotation(PreAuthorize.class);
        PreAuthorize preAuthorize = lookup.apply(method);
        return preAuthorize != null ? preAuthorize : lookup.apply(method.getDeclaringClass());
    }

    void setApplicationContext(ApplicationContext context) {
        Assert.notNull((Object)context, (String)"context cannot be null");
        this.handlerResolver = clazz -> this.resolveHandler(context, (Class<? extends MethodAuthorizationDeniedHandler>)clazz);
    }

    private MethodAuthorizationDeniedHandler resolveHandler(ApplicationContext context, Class<? extends MethodAuthorizationDeniedHandler> handlerClass) {
        if (handlerClass == this.defaultHandler.getClass()) {
            return this.defaultHandler;
        }
        Object[] beanNames = context.getBeanNamesForType(handlerClass);
        if (beanNames.length == 0) {
            throw new IllegalStateException("Could not find a bean of type " + handlerClass.getName());
        }
        if (beanNames.length > 1) {
            throw new IllegalStateException("Expected to find a single bean of type " + handlerClass.getName() + " but found " + Arrays.toString(beanNames));
        }
        return (MethodAuthorizationDeniedHandler)context.getBean(beanNames[0], handlerClass);
    }
}

