/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.api;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.PacketFormat;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPadding;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.api.OpenPGPMessageGenerator;
import org.bouncycastle.util.io.TeeOutputStream;

public class OpenPGPMessageOutputStream
extends OutputStream {
    private final OutputStream baseOut;
    private final OutputStream armorOut;
    private final OutputStream encodeOut;
    private final OutputStream encryptOut;
    private final OutputStream paddingOut;
    private final OutputStream signOut;
    private final OutputStream compressOut;
    private final OutputStream literalOut;
    private final OutputStream plaintextOut;

    OpenPGPMessageOutputStream(OutputStream outputStream, Builder builder) throws PGPException, IOException {
        this.baseOut = outputStream;
        OutputStream outputStream2 = outputStream;
        if (builder.armorFactory != null) {
            outputStream2 = this.armorOut = builder.armorFactory.get(outputStream2);
        } else {
            this.armorOut = null;
        }
        outputStream2 = this.encodeOut = new BCPGOutputStream(outputStream2, PacketFormat.CURRENT);
        if (builder.encryptionStreamFactory != null) {
            outputStream2 = this.encryptOut = builder.encryptionStreamFactory.get(outputStream2);
        } else {
            this.encryptOut = null;
        }
        if (builder.paddingStreamFactory != null) {
            outputStream2 = this.paddingOut = builder.paddingStreamFactory.get(outputStream2);
        } else {
            this.paddingOut = null;
        }
        this.signOut = builder.signatureStreamFactory != null ? builder.signatureStreamFactory.get(outputStream2) : null;
        if (builder.compressionStreamFactory != null) {
            outputStream2 = this.compressOut = builder.compressionStreamFactory.get(outputStream2);
        } else {
            this.compressOut = null;
        }
        if (builder.literalDataStreamFactory == null) {
            throw new PGPException("Missing instructions for LiteralData encoding.");
        }
        this.literalOut = builder.literalDataStreamFactory.get(outputStream2);
        this.plaintextOut = this.signOut != null ? new TeeOutputStream(this.literalOut, this.signOut) : this.literalOut;
    }

    @Override
    public void write(int n) throws IOException {
        this.plaintextOut.write(n);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.plaintextOut.write(byArray, n, n2);
    }

    @Override
    public void flush() throws IOException {
        this.literalOut.flush();
        if (this.compressOut != null) {
            this.compressOut.flush();
        }
        if (this.signOut != null) {
            this.signOut.flush();
        }
        if (this.paddingOut != null) {
            this.paddingOut.flush();
        }
        if (this.encryptOut != null) {
            this.encryptOut.flush();
        }
        this.encodeOut.flush();
        if (this.armorOut != null) {
            this.armorOut.flush();
        }
        this.baseOut.flush();
    }

    @Override
    public void close() throws IOException {
        this.literalOut.close();
        if (this.compressOut != null) {
            this.compressOut.close();
        }
        if (this.signOut != null) {
            this.signOut.close();
        }
        if (this.paddingOut != null) {
            this.paddingOut.close();
        }
        if (this.encryptOut != null) {
            this.encryptOut.close();
        }
        this.encodeOut.close();
        if (this.armorOut != null) {
            this.armorOut.close();
        }
        this.baseOut.close();
    }

    static Builder builder() {
        return new Builder();
    }

    static class Builder {
        private OpenPGPMessageGenerator.ArmoredOutputStreamFactory armorFactory;
        private OutputStreamFactory paddingStreamFactory;
        private OutputStreamFactory encryptionStreamFactory;
        private OutputStreamFactory signatureStreamFactory;
        private OutputStreamFactory compressionStreamFactory;
        private OutputStreamFactory literalDataStreamFactory;

        Builder() {
        }

        public Builder armor(OpenPGPMessageGenerator.ArmoredOutputStreamFactory armoredOutputStreamFactory) {
            this.armorFactory = armoredOutputStreamFactory;
            return this;
        }

        public Builder encrypt(OutputStreamFactory outputStreamFactory) {
            this.encryptionStreamFactory = outputStreamFactory;
            return this;
        }

        public Builder padding(OutputStreamFactory outputStreamFactory) {
            this.paddingStreamFactory = outputStreamFactory;
            return this;
        }

        public Builder sign(OutputStreamFactory outputStreamFactory) {
            this.signatureStreamFactory = outputStreamFactory;
            return this;
        }

        public Builder compress(OutputStreamFactory outputStreamFactory) {
            this.compressionStreamFactory = outputStreamFactory;
            return this;
        }

        public Builder literalData(OutputStreamFactory outputStreamFactory) {
            this.literalDataStreamFactory = outputStreamFactory;
            return this;
        }

        public OpenPGPMessageOutputStream build(OutputStream outputStream) throws PGPException, IOException {
            return new OpenPGPMessageOutputStream(outputStream, this);
        }
    }

    public static interface OutputStreamFactory {
        public OutputStream get(OutputStream var1) throws PGPException, IOException;
    }

    static class PaddingPacketAppenderOutputStream
    extends OutputStream {
        private final OutputStream out;
        private final PaddingPacketFactory packetFactory;

        public PaddingPacketAppenderOutputStream(OutputStream outputStream, PaddingPacketFactory paddingPacketFactory) {
            this.out = outputStream;
            this.packetFactory = paddingPacketFactory;
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            this.out.write(byArray);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.out.write(byArray, n, n2);
        }

        @Override
        public void write(int n) throws IOException {
            this.out.write(n);
        }

        @Override
        public void close() throws IOException {
            this.packetFactory.providePaddingPacket().encode(this.out);
            this.out.close();
        }
    }

    public static interface PaddingPacketFactory {
        public PGPPadding providePaddingPacket();
    }

    static class SignatureGeneratorOutputStream
    extends OutputStream {
        private final OutputStream out;
        private final List<PGPSignatureGenerator> signatureGenerators;

        public SignatureGeneratorOutputStream(OutputStream outputStream, List<PGPSignatureGenerator> list) {
            this.out = outputStream;
            this.signatureGenerators = list;
        }

        @Override
        public void write(int n) throws IOException {
            for (PGPSignatureGenerator pGPSignatureGenerator : this.signatureGenerators) {
                pGPSignatureGenerator.update((byte)n);
            }
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            for (PGPSignatureGenerator pGPSignatureGenerator : this.signatureGenerators) {
                pGPSignatureGenerator.update(byArray);
            }
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            for (PGPSignatureGenerator pGPSignatureGenerator : this.signatureGenerators) {
                pGPSignatureGenerator.update(byArray, n, n2);
            }
        }

        @Override
        public void close() throws IOException {
            for (int i = this.signatureGenerators.size() - 1; i >= 0; --i) {
                PGPSignatureGenerator pGPSignatureGenerator = this.signatureGenerators.get(i);
                PGPSignature pGPSignature = null;
                try {
                    pGPSignature = pGPSignatureGenerator.generate();
                }
                catch (PGPException pGPException) {
                    throw new RuntimeException(pGPException);
                }
                pGPSignature.encode(this.out);
            }
        }
    }
}

