/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.core.support;

import io.micrometer.observation.ObservationRegistry;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.ldap.core.support.BaseLdapPathContextSource;
import org.springframework.ldap.core.support.ObservationContextSource;

public final class ContextSourceObservationPostProcessor
implements BeanPostProcessor {
    private final ObjectProvider<ObservationRegistry> observationRegistry;

    public ContextSourceObservationPostProcessor(ObjectProvider<ObservationRegistry> observationRegistry) {
        this.observationRegistry = observationRegistry;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof ObservationContextSource) {
            return bean;
        }
        if (!(bean instanceof BaseLdapPathContextSource)) {
            return bean;
        }
        BaseLdapPathContextSource ldap = (BaseLdapPathContextSource)bean;
        ObservationRegistry observationRegistry = (ObservationRegistry)this.observationRegistry.getIfAvailable(() -> ObservationRegistry.NOOP);
        if (observationRegistry.isNoop()) {
            return bean;
        }
        return new ObservationContextSource(ldap, observationRegistry);
    }
}

