/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.servlet.util.matcher;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Objects;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.PathContainer;
import org.springframework.http.server.RequestPath;
import org.springframework.lang.Nullable;
import org.springframework.security.web.util.matcher.AnyRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.web.util.ServletRequestPathUtils;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;

public final class PathPatternRequestMatcher
implements RequestMatcher {
    private final PathPattern pattern;
    private final RequestMatcher method;

    private PathPatternRequestMatcher(PathPattern pattern, RequestMatcher method) {
        this.pattern = pattern;
        this.method = method;
    }

    public static Builder withDefaults() {
        return new Builder();
    }

    public static Builder withPathPatternParser(PathPatternParser parser) {
        Assert.notNull((Object)parser, (String)"pathPatternParser cannot be null");
        return new Builder(parser);
    }

    @Override
    public boolean matches(HttpServletRequest request) {
        return this.matcher(request).isMatch();
    }

    @Override
    public RequestMatcher.MatchResult matcher(HttpServletRequest request) {
        if (!this.method.matches(request)) {
            return RequestMatcher.MatchResult.notMatch();
        }
        PathContainer path = this.getPathContainer(request);
        PathPattern.PathMatchInfo info = this.pattern.matchAndExtract(path);
        return info != null ? RequestMatcher.MatchResult.match(info.getUriVariables()) : RequestMatcher.MatchResult.notMatch();
    }

    private PathContainer getPathContainer(HttpServletRequest request) {
        RequestPath path;
        if (ServletRequestPathUtils.hasParsedRequestPath((ServletRequest)request)) {
            path = ServletRequestPathUtils.getParsedRequestPath((ServletRequest)request);
        } else {
            path = ServletRequestPathUtils.parseAndCache((HttpServletRequest)request);
            ServletRequestPathUtils.clearParsedRequestPath((ServletRequest)request);
        }
        PathContainer contextPath = path.contextPath();
        return path.subPath(contextPath.elements().size());
    }

    public boolean equals(Object o) {
        if (!(o instanceof PathPatternRequestMatcher)) {
            return false;
        }
        PathPatternRequestMatcher that = (PathPatternRequestMatcher)o;
        return Objects.equals(this.pattern, that.pattern) && Objects.equals(this.method, that.method);
    }

    public int hashCode() {
        return Objects.hash(this.pattern, this.method);
    }

    public String toString() {
        StringBuilder request = new StringBuilder();
        RequestMatcher requestMatcher = this.method;
        if (requestMatcher instanceof HttpMethodRequestMatcher) {
            HttpMethodRequestMatcher m = (HttpMethodRequestMatcher)requestMatcher;
            request.append(m.method.name()).append(' ');
        }
        return "PathPattern [" + String.valueOf(request) + String.valueOf(this.pattern) + "]";
    }

    public static final class Builder {
        private final PathPatternParser parser;
        private final String basePath;

        Builder() {
            this(PathPatternParser.defaultInstance);
        }

        Builder(PathPatternParser parser) {
            this(parser, "");
        }

        Builder(PathPatternParser parser, String basePath) {
            this.parser = parser;
            this.basePath = basePath;
        }

        public Builder basePath(String basePath) {
            Assert.notNull((Object)basePath, (String)"basePath cannot be null");
            Assert.isTrue((boolean)basePath.startsWith("/"), (String)"basePath must start with '/'");
            Assert.isTrue(("/".equals(basePath) || !basePath.endsWith("/") ? 1 : 0) != 0, (String)"basePath must not end with a slash");
            Assert.isTrue((!basePath.contains("*") ? 1 : 0) != 0, (String)"basePath must not contain a star");
            return new Builder(this.parser, basePath);
        }

        public PathPatternRequestMatcher matcher(String path) {
            return this.matcher(null, path);
        }

        public PathPatternRequestMatcher matcher(@Nullable HttpMethod method, String path) {
            Assert.notNull((Object)path, (String)"pattern cannot be null");
            Assert.isTrue((boolean)path.startsWith("/"), (String)"pattern must start with a /");
            String prefix = "/".equals(this.basePath) ? "" : this.basePath;
            PathPattern pathPattern = this.parser.parse(prefix + path);
            return new PathPatternRequestMatcher(pathPattern, method != null ? new HttpMethodRequestMatcher(method) : AnyRequestMatcher.INSTANCE);
        }
    }

    private static final class HttpMethodRequestMatcher
    implements RequestMatcher {
        private final HttpMethod method;

        HttpMethodRequestMatcher(HttpMethod method) {
            this.method = method;
        }

        @Override
        public boolean matches(HttpServletRequest request) {
            return this.method.name().equals(request.getMethod());
        }

        public String toString() {
            return "HttpMethod [" + String.valueOf(this.method) + "]";
        }
    }
}

