/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.http.client;

import java.net.URI;
import org.apache.hc.client5.http.impl.DefaultRedirectStrategy;
import org.apache.hc.client5.http.protocol.RedirectStrategy;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.springframework.boot.http.client.HttpRedirects;

final class HttpComponentsRedirectStrategy {
    private HttpComponentsRedirectStrategy() {
    }

    static RedirectStrategy get(HttpRedirects redirects) {
        return switch (redirects) {
            default -> throw new IncompatibleClassChangeError();
            case HttpRedirects.FOLLOW_WHEN_POSSIBLE, HttpRedirects.FOLLOW -> DefaultRedirectStrategy.INSTANCE;
            case HttpRedirects.DONT_FOLLOW -> NoFollowRedirectStrategy.INSTANCE;
        };
    }

    private static final class NoFollowRedirectStrategy
    implements RedirectStrategy {
        private static final RedirectStrategy INSTANCE = new NoFollowRedirectStrategy();

        private NoFollowRedirectStrategy() {
        }

        public boolean isRedirected(HttpRequest request, HttpResponse response, HttpContext context) {
            return false;
        }

        public URI getLocationURI(HttpRequest request, HttpResponse response, HttpContext context) {
            return null;
        }
    }
}

