/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.http.client;

import java.time.Duration;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.http.client.AbstractHttpClientProperties;
import org.springframework.boot.autoconfigure.http.client.AbstractHttpRequestFactoryProperties;
import org.springframework.boot.http.client.ClientHttpRequestFactoryBuilder;
import org.springframework.boot.http.client.ClientHttpRequestFactorySettings;
import org.springframework.boot.http.client.HttpRedirects;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.util.StringUtils;

class ClientHttpRequestFactories {
    private final ObjectProvider<SslBundles> sslBundles;
    private final AbstractHttpRequestFactoryProperties[] orderedProperties;

    ClientHttpRequestFactories(ObjectProvider<SslBundles> sslBundles, AbstractHttpRequestFactoryProperties ... orderedProperties) {
        this.sslBundles = sslBundles;
        this.orderedProperties = orderedProperties;
    }

    ClientHttpRequestFactoryBuilder<?> builder(ClassLoader classLoader) {
        AbstractHttpRequestFactoryProperties.Factory factory = this.getProperty(AbstractHttpRequestFactoryProperties::getFactory);
        return factory != null ? factory.builder() : ClientHttpRequestFactoryBuilder.detect((ClassLoader)classLoader);
    }

    ClientHttpRequestFactorySettings settings() {
        HttpRedirects redirects = this.getProperty(AbstractHttpClientProperties::getRedirects);
        Duration connectTimeout = this.getProperty(AbstractHttpClientProperties::getConnectTimeout);
        Duration readTimeout = this.getProperty(AbstractHttpClientProperties::getReadTimeout);
        String sslBundleName = this.getProperty(AbstractHttpClientProperties::getSsl, AbstractHttpClientProperties.Ssl::getBundle, StringUtils::hasLength);
        SslBundle sslBundle = StringUtils.hasLength((String)sslBundleName) ? ((SslBundles)this.sslBundles.getObject()).getBundle(sslBundleName) : null;
        return new ClientHttpRequestFactorySettings(ClientHttpRequestFactorySettings.Redirects.of((HttpRedirects)redirects), connectTimeout, readTimeout, sslBundle);
    }

    private <T> T getProperty(Function<AbstractHttpRequestFactoryProperties, T> accessor) {
        return (T)this.getProperty(accessor, Function.identity(), Objects::nonNull);
    }

    private <P, T> T getProperty(Function<AbstractHttpRequestFactoryProperties, P> accessor, Function<P, T> extractor, Predicate<T> predicate) {
        for (AbstractHttpRequestFactoryProperties properties : this.orderedProperties) {
            T extracted;
            P value = accessor.apply(properties);
            T t = extracted = value != null ? (T)extractor.apply(value) : null;
            if (!predicate.test(extracted)) continue;
            return extracted;
        }
        return null;
    }
}

