/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.extension.component;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.nifi.extension.manifest.ExtensionType;
import org.apache.nifi.registry.extension.bundle.BundleType;

public class ExtensionFilterParams {
    private final BundleType bundleType;
    private final ExtensionType extensionType;
    private final Set<String> tags;

    private ExtensionFilterParams() {
        this.bundleType = null;
        this.extensionType = null;
        this.tags = null;
    }

    private ExtensionFilterParams(Builder builder) {
        this.bundleType = builder.bundleType;
        this.extensionType = builder.extensionType;
        this.tags = Collections.unmodifiableSet(new HashSet<String>(builder.tags));
    }

    @Schema(description="The type of bundle")
    public BundleType getBundleType() {
        return this.bundleType;
    }

    @Schema(description="The type of extension")
    public ExtensionType getExtensionType() {
        return this.extensionType;
    }

    @Schema(description="The tags")
    public Set<String> getTags() {
        return this.tags;
    }

    public static class Builder {
        private BundleType bundleType;
        private ExtensionType extensionType;
        private Set<String> tags = new HashSet<String>();

        public Builder bundleType(BundleType bundleType) {
            this.bundleType = bundleType;
            return this;
        }

        public Builder extensionType(ExtensionType extensionType) {
            this.extensionType = extensionType;
            return this;
        }

        public Builder tag(String tag) {
            if (tag != null) {
                this.tags.add(tag);
            }
            return this;
        }

        public Builder addTags(Collection<String> tags) {
            if (tags != null) {
                this.tags.addAll(tags);
            }
            return this;
        }

        public ExtensionFilterParams build() {
            return new ExtensionFilterParams(this);
        }
    }
}

