/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.functions;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.nifi.attribute.expression.language.EvaluationContext;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.StringQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.functions.JsonPathBaseEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JsonPathUpdateEvaluator
extends JsonPathBaseEvaluator {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonPathUpdateEvaluator.class);
    protected Evaluator<?> valueEvaluator;

    public JsonPathUpdateEvaluator(Evaluator<String> subject, Evaluator<String> jsonPathExp, Evaluator<?> valueEvaluator) {
        super(subject, jsonPathExp);
        this.valueEvaluator = valueEvaluator;
    }

    @Override
    public QueryResult<String> evaluate(EvaluationContext context) {
        String result;
        DocumentContext documentContext = this.getDocumentContext(context);
        JsonPath compiledJsonPath = this.getJsonPath(context);
        Object value = this.valueEvaluator.evaluate(context).getValue();
        try {
            result = this.updateAttribute(documentContext, compiledJsonPath, value).jsonString();
        }
        catch (PathNotFoundException pnf) {
            LOGGER.debug("JSON Path not found: {}", (Object)compiledJsonPath.getPath(), (Object)pnf);
            result = documentContext.jsonString();
        }
        catch (Exception e) {
            LOGGER.error("Failed to update attribute", (Throwable)e);
            return EMPTY_RESULT;
        }
        return new StringQueryResult(JsonPathUpdateEvaluator.getResultRepresentation(result, EMPTY_RESULT.getValue()));
    }

    public DocumentContext updateAttribute(DocumentContext documentContext, JsonPath jsonPath, Object value) {
        throw new NotImplementedException("Please implement updateAttribute method in the implementation class");
    }
}

