/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.functions;

import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.attribute.expression.language.EvaluationContext;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.StringEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.StringQueryResult;
import org.apache.nifi.attribute.expression.language.exception.AttributeExpressionLanguageException;

public class RepeatEvaluator
extends StringEvaluator {
    private final Evaluator<String> subject;
    private final Evaluator<Long> minRepeats;
    private final Evaluator<Long> maxRepeats;

    public RepeatEvaluator(Evaluator<String> subject, Evaluator<Long> minRepeats, Evaluator<Long> maxRepeats) {
        this.subject = subject;
        this.minRepeats = minRepeats;
        this.maxRepeats = maxRepeats;
    }

    public RepeatEvaluator(Evaluator<String> subject, Evaluator<Long> minRepeats) {
        this.subject = subject;
        this.minRepeats = minRepeats;
        this.maxRepeats = null;
    }

    @Override
    public QueryResult<String> evaluate(EvaluationContext evaluationContext) {
        String subjectValue = this.subject.evaluate(evaluationContext).getValue();
        if (subjectValue == null) {
            return new StringQueryResult("");
        }
        int firstRepeatValue = this.minRepeats.evaluate(evaluationContext).getValue().intValue();
        if (this.maxRepeats == null) {
            if (firstRepeatValue <= 0) {
                throw new AttributeExpressionLanguageException("Number of repeats must be > 0");
            }
            return new StringQueryResult(StringUtils.repeat((String)subjectValue, (int)firstRepeatValue));
        }
        if (firstRepeatValue <= 0) {
            throw new AttributeExpressionLanguageException("Minimum number of repeats must be > 0");
        }
        int maxRepeatCount = this.maxRepeats.evaluate(evaluationContext).getValue().intValue();
        if (firstRepeatValue > maxRepeatCount) {
            throw new AttributeExpressionLanguageException("Min repeats must not be greater than max repeats");
        }
        int randomRepeatCount = (int)(Math.random() * (double)(maxRepeatCount - firstRepeatValue + 1)) + firstRepeatValue;
        return new StringQueryResult(StringUtils.repeat((String)subjectValue, (int)randomRepeatCount));
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return this.subject;
    }
}

