/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.bootstrap.command;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.apache.nifi.minifi.bootstrap.RunMiNiFi;
import org.apache.nifi.minifi.bootstrap.Status;
import org.apache.nifi.minifi.bootstrap.command.CommandRunner;
import org.apache.nifi.minifi.bootstrap.service.CurrentPortProvider;
import org.apache.nifi.minifi.bootstrap.service.MiNiFiCommandSender;
import org.slf4j.Logger;

public class DumpRunner
implements CommandRunner {
    protected static final String DUMP_CMD = "DUMP";
    private final MiNiFiCommandSender miNiFiCommandSender;
    private final CurrentPortProvider currentPortProvider;

    public DumpRunner(MiNiFiCommandSender miNiFiCommandSender, CurrentPortProvider currentPortProvider) {
        this.miNiFiCommandSender = miNiFiCommandSender;
        this.currentPortProvider = currentPortProvider;
    }

    @Override
    public int runCommand(String[] args) {
        return this.dump(this.getArg(args, 1).map(File::new).orElse(null));
    }

    private int dump(File dumpFile) {
        Optional<String> dump;
        Integer port = this.currentPortProvider.getCurrentPort();
        if (port == null) {
            RunMiNiFi.CMD_LOGGER.error("Apache MiNiFi is not currently running");
            return Status.MINIFI_NOT_RUNNING.getStatusCode();
        }
        try {
            dump = this.miNiFiCommandSender.sendCommand(DUMP_CMD, port, new String[0]);
        }
        catch (IOException e) {
            RunMiNiFi.CMD_LOGGER.error("Failed to get DUMP response from MiNiFi");
            RunMiNiFi.DEFAULT_LOGGER.error("Exception:", (Throwable)e);
            return Status.ERROR.getStatusCode();
        }
        return Optional.ofNullable(dumpFile).map(dmp -> this.writeDumpToFile((File)dmp, dump)).orElseGet(() -> {
            dump.ifPresent(arg_0 -> ((Logger)RunMiNiFi.CMD_LOGGER).info(arg_0));
            return Status.OK.getStatusCode();
        });
    }

    private Integer writeDumpToFile(File dumpFile, Optional<String> dump) {
        try (FileOutputStream fos = new FileOutputStream(dumpFile);){
            fos.write(dump.orElse("Dump has empty response").getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            RunMiNiFi.CMD_LOGGER.error("Failed to write DUMP response to file");
            RunMiNiFi.DEFAULT_LOGGER.error("Exception:", (Throwable)e);
            return Status.ERROR.getStatusCode();
        }
        RunMiNiFi.CMD_LOGGER.info("Successfully wrote thread dump to {}", (Object)dumpFile.getAbsolutePath());
        return Status.OK.getStatusCode();
    }

    private Optional<String> getArg(String[] args, int index) {
        return Optional.ofNullable(args.length > index ? args[index] : null);
    }
}

