/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.bootstrap.configuration.differentiators;

import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.nifi.minifi.bootstrap.ConfigurationFileHolder;
import org.apache.nifi.minifi.bootstrap.configuration.differentiators.Differentiator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WholeConfigDifferentiator {
    public static final String WHOLE_CONFIG_KEY = "Whole Config";
    private static final Logger logger = LoggerFactory.getLogger(WholeConfigDifferentiator.class);
    protected volatile ConfigurationFileHolder configurationFileHolder;

    public void initialize(ConfigurationFileHolder configurationFileHolder) {
        this.configurationFileHolder = configurationFileHolder;
    }

    public static Differentiator<ByteBuffer> getByteBufferDifferentiator() {
        return new ByteBufferInputDifferentiator();
    }

    public static class ByteBufferInputDifferentiator
    extends WholeConfigDifferentiator
    implements Differentiator<ByteBuffer> {
        @Override
        public boolean isNew(ByteBuffer newFlowConfig) {
            AtomicReference<ByteBuffer> currentFlowConfigReference = this.configurationFileHolder.getConfigFileReference();
            ByteBuffer currentFlowConfig = currentFlowConfigReference.get();
            boolean compareResult = Optional.ofNullable(currentFlowConfig).map(newFlowConfig::compareTo).map(result -> result != 0).orElse(Boolean.TRUE);
            logger.debug("New flow is different from existing flow: {}", (Object)compareResult);
            return compareResult;
        }
    }
}

