/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.bootstrap.configuration.ingestors;

import java.io.IOException;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.nifi.minifi.bootstrap.ConfigurationFileHolder;
import org.apache.nifi.minifi.bootstrap.configuration.ConfigurationChangeNotifier;
import org.apache.nifi.minifi.bootstrap.configuration.ingestors.interfaces.ChangeIngestor;
import org.apache.nifi.minifi.properties.BootstrapProperties;

public abstract class AbstractPullChangeIngestor
implements Runnable,
ChangeIngestor {
    protected static final String DEFAULT_POLLING_PERIOD_MILLISECONDS = "300000";
    protected final AtomicInteger pollingPeriodMS = new AtomicInteger();
    protected final AtomicReference<BootstrapProperties> properties = new AtomicReference();
    private final ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(1);
    protected volatile ConfigurationChangeNotifier configurationChangeNotifier;

    @Override
    public void initialize(BootstrapProperties properties, ConfigurationFileHolder configurationFileHolder, ConfigurationChangeNotifier configurationChangeNotifier) {
        this.configurationChangeNotifier = configurationChangeNotifier;
        this.properties.set(properties);
    }

    @Override
    public void start() {
        this.scheduledThreadPoolExecutor.scheduleAtFixedRate(this, this.pollingPeriodMS.get(), this.pollingPeriodMS.get(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void close() throws IOException {
        this.scheduledThreadPoolExecutor.shutdownNow();
    }

    @Override
    public abstract void run();
}

