/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.bootstrap.service;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiNiFiStdLogHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(MiNiFiStdLogHandler.class);
    private static final String READ_FAILURE_MESSAGE = "Failed to read from MiNiFi's Standard {} stream";
    private static final String EXCEPTION_MESSAGE = "Exception: ";
    private final ExecutorService loggingExecutor = Executors.newFixedThreadPool(2, runnable -> {
        Thread t = Executors.defaultThreadFactory().newThread(runnable);
        t.setDaemon(true);
        t.setName("MiNiFi logging handler");
        return t;
    });
    private Set<Future<?>> loggingFutures;

    public void initLogging(Process process) {
        LOGGER.debug("Initializing MiNiFi's standard output/error loggers...");
        Optional.ofNullable(this.loggingFutures).map(Collection::stream).orElse(Stream.empty()).forEach(future -> future.cancel(false));
        HashSet futures = new HashSet();
        futures.add(this.getFuture(process.getInputStream(), LoggerType.STDOUT));
        futures.add(this.getFuture(process.getErrorStream(), LoggerType.ERROR));
        this.loggingFutures = futures;
    }

    @NotNull
    private Future<?> getFuture(InputStream in, LoggerType loggerType) {
        return this.loggingExecutor.submit(() -> {
            Logger logger = LoggerFactory.getLogger((String)loggerType.getLoggerName());
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (loggerType == LoggerType.ERROR) {
                        logger.error(line);
                        continue;
                    }
                    logger.info(line);
                }
            }
            catch (IOException e) {
                LOGGER.warn(READ_FAILURE_MESSAGE, (Object)loggerType.getDisplayName());
                LOGGER.warn(EXCEPTION_MESSAGE, (Throwable)e);
            }
        });
    }

    public void shutdown() {
        LOGGER.debug("Shutting down MiNiFi's standard output/error loggers...");
        this.loggingExecutor.shutdown();
    }

    static enum LoggerType {
        STDOUT("Output", "org.apache.nifi.minifi.StdOut"),
        ERROR("Error", "org.apache.nifi.minifi.StdErr");

        final String displayName;
        final String loggerName;

        private LoggerType(String displayName, String loggerName) {
            this.displayName = displayName;
            this.loggerName = loggerName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getLoggerName() {
            return this.loggerName;
        }
    }
}

