/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.rewrite.handler;

import java.io.IOException;
import java.util.Objects;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.rewrite.handler.Rule;
import org.eclipse.jetty.util.StringUtil;

public class ForceRequestHeaderValueRule
extends Rule {
    private String headerName;
    private String headerValue;
    private HttpField field;

    public String getHeaderName() {
        return this.headerName;
    }

    public void setHeaderName(String headerName) {
        this.headerName = Objects.requireNonNull(headerName);
        this.field = new HttpField(headerName, this.headerValue);
    }

    public String getHeaderValue() {
        return this.headerValue;
    }

    public void setHeaderValue(String headerValue) {
        this.headerValue = headerValue;
        this.field = !StringUtil.isBlank((String)this.headerName) ? new HttpField(this.headerName, headerValue) : null;
    }

    @Override
    public Rule.Handler matchAndApply(Rule.Handler input) throws IOException {
        String existingValue;
        HttpFields headers = input.getHeaders();
        String string = existingValue = this.field == null || this.field.getHeader() == null ? headers.get(this.headerName) : headers.get(this.field.getHeader());
        if (existingValue == null) {
            return null;
        }
        if (existingValue.equals(this.headerValue)) {
            return null;
        }
        final HttpFields.Mutable newHeaders = HttpFields.build((HttpFields)headers);
        if (this.field != null) {
            newHeaders.put(this.field);
        } else {
            newHeaders.put(this.headerName, this.headerValue);
        }
        return new Rule.Handler(this, input){
            final /* synthetic */ ForceRequestHeaderValueRule this$0;
            {
                this.this$0 = this$0;
                super(handler);
            }

            public HttpFields getHeaders() {
                return newHeaders;
            }
        };
    }
}

