/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.remote.io.http;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.nifi.remote.io.InterruptableOutputStream;
import org.apache.nifi.remote.protocol.CommunicationsOutput;
import org.apache.nifi.stream.io.ByteCountingOutputStream;

public class HttpOutput
implements CommunicationsOutput {
    private ByteCountingOutputStream countingOut;
    private InterruptableOutputStream interruptableOut;

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.countingOut;
    }

    @Override
    public long getBytesWritten() {
        if (this.countingOut != null) {
            return this.countingOut.getBytesWritten();
        }
        return 0L;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.interruptableOut = new InterruptableOutputStream(outputStream);
        this.countingOut = new ByteCountingOutputStream((OutputStream)this.interruptableOut);
    }

    public void interrupt() {
        if (this.interruptableOut != null) {
            this.interruptableOut.interrupt();
        }
    }
}

