/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.commons.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FlowUpdateUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlowUpdateUtils.class);

    private FlowUpdateUtils() {
    }

    public static void backup(Path current, Path backup) throws IOException {
        if (current != null && Files.exists(current, new LinkOption[0])) {
            Files.copy(current, backup, StandardCopyOption.REPLACE_EXISTING);
        } else {
            LOGGER.warn("Flow configuration files does not exist. No backup copy will be created");
        }
    }

    public static void persist(byte[] flowConfig, Path flowPath, boolean compress) throws IOException {
        LOGGER.debug("Persisting flow to path {} with content\n{}\n and compress {}", new Object[]{flowPath, new String(flowConfig, StandardCharsets.UTF_8), compress});
        try (ByteArrayInputStream flowInputStream = new ByteArrayInputStream(flowConfig);
             OutputStream fileOut = compress ? new GZIPOutputStream(Files.newOutputStream(flowPath, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING)) : Files.newOutputStream(flowPath, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            flowInputStream.transferTo(fileOut);
        }
        LOGGER.info("Updated configuration was written to: {}", (Object)flowPath);
    }

    public static void revert(Path backupFlowConfigFile, Path currentFlowConfigFile) {
        if (backupFlowConfigFile != null && Files.exists(backupFlowConfigFile, new LinkOption[0])) {
            try {
                Files.copy(backupFlowConfigFile, currentFlowConfigFile, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                LOGGER.error("Revert to previous flow failed. Please stop MiNiFi and revert the flow manually");
                throw new UncheckedIOException("Failed to revert flow", e);
            }
        } else {
            LOGGER.error("Backup flow configuration file does not exist");
            throw new RuntimeException("Backup flow configuration file does not exist");
        }
    }

    public static void removeIfExists(Path flowConfigFile) {
        if (flowConfigFile != null) {
            try {
                Files.deleteIfExists(flowConfigFile);
            }
            catch (IOException e) {
                LOGGER.warn("Unable to remove flow configuration backup file", (Throwable)e);
            }
        }
    }
}

