/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util.concurrency;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.apache.nifi.util.concurrency.DebuggableTimedLock;
import org.apache.nifi.util.concurrency.TimedLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugEnabledTimedLock
implements DebuggableTimedLock {
    private final Lock lock;
    private static final Logger logger = LoggerFactory.getLogger((String)TimedLock.class.getName());
    private long lockTime = 0L;
    private final Map<String, Long> lockIterations = new HashMap<String, Long>();
    private final Map<String, Long> lockNanos = new HashMap<String, Long>();
    private final String name;
    private final int iterationFrequency;

    public DebugEnabledTimedLock(Lock lock, String name, int iterationFrequency) {
        this.lock = lock;
        this.name = name;
        this.iterationFrequency = iterationFrequency;
    }

    @Override
    public boolean tryLock() {
        logger.trace("Trying to obtain Lock: {}", (Object)this.name);
        boolean success = this.lock.tryLock();
        if (!success) {
            logger.trace("TryLock failed for Lock: {}", (Object)this.name);
            return false;
        }
        logger.trace("TryLock successful for Lock: {}", (Object)this.name);
        return true;
    }

    @Override
    public boolean tryLock(long timeout, TimeUnit timeUnit) {
        boolean success;
        logger.trace("Trying to obtain Lock {} with a timeout of {} {}", new Object[]{this.name, timeout, timeUnit});
        try {
            success = this.lock.tryLock(timeout, timeUnit);
        }
        catch (InterruptedException ie) {
            return false;
        }
        if (!success) {
            logger.trace("TryLock failed for Lock {} with a timeout of {} {}", new Object[]{this.name, timeout, timeUnit});
            return false;
        }
        logger.trace("TryLock successful for Lock: {}", (Object)this.name);
        return true;
    }

    @Override
    public void lock() {
        logger.trace("Obtaining Lock {}", (Object)this.name);
        this.lock.lock();
        this.lockTime = System.nanoTime();
        logger.trace("Obtained Lock {}", (Object)this.name);
    }

    @Override
    public void unlock(String task) {
        if (this.lockTime <= 0L) {
            this.lock.unlock();
            return;
        }
        logger.trace("Releasing Lock {}", (Object)this.name);
        long nanosLocked = System.nanoTime() - this.lockTime;
        Long startIterations = this.lockIterations.get(task);
        if (startIterations == null) {
            startIterations = 0L;
        }
        long iterations = startIterations + 1L;
        this.lockIterations.put(task, iterations);
        Long startNanos = this.lockNanos.get(task);
        if (startNanos == null) {
            startNanos = 0L;
        }
        long totalNanos = startNanos + nanosLocked;
        this.lockNanos.put(task, totalNanos);
        this.lockTime = -1L;
        this.lock.unlock();
        logger.trace("Released Lock {}", (Object)this.name);
        if (iterations % (long)this.iterationFrequency == 0L) {
            logger.debug("Lock {} held for {} nanos for task: {}; total lock iterations: {}; total lock nanos: {}", new Object[]{this.name, nanosLocked, task, iterations, totalNanos});
        }
    }
}

